<?php
if(!isset($vendorViewBySuperAdmin))
$vendorViewBySuperAdmin = false;
?>
<?php if(hasCentralAccess() and !$vendorViewBySuperAdmin ): ?>
<div class="header pb-5 pt-2 pt-md-7">
    <div class="container-fluid">
        <div class="header-body" x-cloak x-data="{totalVendors:<?php echo e($totalVendors); ?>,totalActiveVendors:<?php echo e($totalActiveVendors); ?>,totalCampaigns:<?php echo e($totalCampaigns); ?>,messagesInQueue:<?php echo e($messagesInQueue); ?>,totalContacts:<?php echo e($totalContacts); ?>,totalMessagesProcessed:<?php echo e($totalMessagesProcessed); ?> }">
            <!-- Card stats -->
            <div class="row">
                <div class="col-md-6 col-lg col-sm-12">
                    <div class="card card-stats mb-4 mb-xl-0">
                        <div class="card-body">
                            <div class="row">
                                <div class="col">
                                    <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e(__tr('Total Vendors')); ?>

                                    </h5>
                                    <span class="h2 font-weight-bold mb-0"
                                        x-text="__Utils.formatAsLocaleNumber(totalVendors)"></span>
                                </div>
                                <div class="col-auto">
                                    <div class="icon icon-shape bg-danger text-white rounded-circle shadow">
                                        <i class="fas fa-store text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                            <p class="mt-3 mb-0 text-muted text-sm">
                                <span><?php echo e(__tr('Total Vendors in the system')); ?></span>
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg col-sm-12">
                    <div class="card card-stats mb-4 mb-xl-0">
                        <div class="card-body">
                            <div class="row">
                                <div class="col">
                                    <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e(__tr('Total Active Vendors')); ?></h5>
                                    <span class="h2 font-weight-bold mb-0"
                                        x-text="__Utils.formatAsLocaleNumber(totalActiveVendors)"></span>
                                </div>
                                <div class="col-auto">
                                    <div class="icon icon-shape bg-danger text-white rounded-circle shadow">
                                        <i class="fas fa-store text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md col-sm-12">
                    <div class="card card-stats mb-4 mb-xl-0">
                        <div class="card-body">
                            <div class="row">
                                <div class="col">
                                    <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e(__tr('Total Contacts')); ?></h5>
                                    <span class="h2 font-weight-bold mb-0"
                                        x-text="__Utils.formatAsLocaleNumber(totalContacts)"></span>
                                </div>
                                <div class="col-auto">
                                    <div class="icon icon-shape bg-danger text-white rounded-circle shadow">
                                        <i class="fas fa-users text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-md-4">
                <div class="col-md-6 col-lg col-sm-12">
                    <div class="card card-stats mb-4 mb-xl-0">
                        <div class="card-body">
                            <div class="row">
                                <div class="col">
                                    <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e(__tr('Total Campaigns')); ?></h5>
                                    <span class="h2 font-weight-bold mb-0"
                                        x-text="__Utils.formatAsLocaleNumber(totalCampaigns)"></span>
                                </div>
                                <div class="col-auto">
                                    <div class="icon icon-shape bg-primary text-white rounded-circle shadow">
                                        <i class="fas fa-bullhorn text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg col-sm-12">
                    <div class="card card-stats mb-4 mb-xl-0">
                        <div class="card-body">
                            <div class="row">
                                <div class="col">
                                    <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e(__tr('Messages in Queue')); ?></h5>
                                    <span class="h2 font-weight-bold mb-0"
                                        x-text="__Utils.formatAsLocaleNumber(messagesInQueue)"></span>
                                </div>
                                <div class="col-auto">
                                    <div class="icon icon-shape bg-primary text-white rounded-circle shadow">
                                        <i class="fas fa-stream text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md col-sm-12">
                    <div class="card card-stats mb-4 mb-xl-0">
                        <div class="card-body">
                            <div class="row">
                                <div class="col">
                                    <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e(__tr('Messages Processed')); ?></h5>
                                    <span class="h2 font-weight-bold mb-0"
                                        x-text="__Utils.formatAsLocaleNumber(totalMessagesProcessed)"></span>
                                </div>
                                <div class="col-auto">
                                    <div class="icon icon-shape bg-primary text-white rounded-circle shadow">
                                        <i class="fas fa-tasks text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php elseif(hasVendorAccess() or hasVendorUserAccess() or $vendorViewBySuperAdmin ): ?>
<div class="header">
    <div class="container-fluid">
        <div class="header-body">
            <!-- Card stats -->
            <div class="row">
                <div class="col-12">
                    <div class="row mb-2">
                        <?php if(hasVendorAccess('manage_contacts')): ?>
                        
                        <div class="col-xl-3 col-lg-4 col-md-6 mb-md-4">
                            <div class="card card-stats mb-4 mb-xl-0">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col">
                                            <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e(__tr('Total Contacts')); ?></h5>
                                            <span class="h2 font-weight-bold mb-0"><?php echo e(__tr($totalContacts)); ?></span>
                                        </div>
                                        <div class="col-auto">
                                            <div
                                                class="icon icon-shape bg-info text-white rounded-circle shadow">
                                                <i class="fas fa-user"></i>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if(!$vendorViewBySuperAdmin): ?>
                                    <p class="mt-3 mb-0 text-muted text-sm">
                                        <a href="<?php echo e(route('vendor.contact.read.list_view')); ?>"><?php echo e(__tr('Manage Contacts')); ?></a>
                                    </p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        
                        
                        <div class="col-xl-3 col-lg-4 col-md-6 mb-md-4">
                            <div class="card card-stats mb-4 mb-xl-0">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col">
                                            <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e(__tr('Total Groups')); ?></h5>
                                            <span class="h2 font-weight-bold mb-0"><?php echo e(__tr($totalGroups)); ?></span>
                                        </div>
                                        <div class="col-auto">
                                            <div
                                                class="icon icon-shape bg-primary text-white rounded-circle shadow">
                                                <i class="fas fa-users"></i>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if(!$vendorViewBySuperAdmin): ?>
                                    <p class="mt-3 mb-0 text-muted text-sm">
                                        <a href="<?php echo e(route('vendor.contact.group.read.list_view')); ?>"><?php echo e(__tr('Manage Groups')); ?></a>
                                    </p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        
                        <?php endif; ?>
                        <?php if(hasVendorAccess('manage_campaigns')): ?>
                        
                        <div class="col-xl-3 col-lg-4 col-md-6 mb-md-4">
                            <div class="card card-stats mb-4 mb-xl-0">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col">
                                            <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e(__tr('Total Campaigns')); ?></h5>
                                            <span class="h2 font-weight-bold mb-0"><?php echo e(__tr($totalCampaigns)); ?></span>
                                        </div>
                                        <div class="col-auto">
                                            <div
                                                class="icon icon-shape bg-danger text-white rounded-circle shadow">
                                                <i class="fa fa-bullhorn"></i>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if(!$vendorViewBySuperAdmin): ?>
                                    <p class="mt-3 mb-0 text-muted text-sm">
                                        <a href="<?php echo e(route('vendor.campaign.read.list_view')); ?>"><?php echo e(__tr('Manage Campaigns')); ?></a>
                                    </p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        
                        <?php endif; ?>
                        <?php if(hasVendorAccess('manage_templates')): ?>
                        
                        <div class="col-xl-3 col-lg-4 col-md-6 mb-md-4">
                            <div class="card card-stats mb-4 mb-xl-0">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col">
                                            <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e(__tr('Total Templates')); ?></h5>
                                            <span class="h2 font-weight-bold mb-0"><?php echo e(__tr($totalTemplates)); ?></span>
                                        </div>
                                        <div class="col-auto">
                                            <div
                                                class="icon icon-shape bg-primary text-white rounded-circle shadow">
                                                <i class="fa fa-layer-group"></i>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if(!$vendorViewBySuperAdmin): ?>
                                    <p class="mt-3 mb-0 text-muted text-sm">
                                        <a href="<?php echo e(route('vendor.whatsapp_service.templates.read.list_view')); ?>"><?php echo e(__tr('Manage Templates')); ?></a>
                                    </p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        
                        <?php endif; ?>
                        <?php if(hasVendorAccess('manage_bot_replies')): ?>
                        
                        <div class="col-xl-3 col-lg-4 col-md-6 mb-md-4">
                            <div class="card card-stats mb-4 mb-xl-0">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col">
                                            <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e(__tr('Total Bot Replies')); ?></h5>
                                            <span class="h2 font-weight-bold mb-0"><?php echo e(__tr($totalBotReplies)); ?></span>
                                        </div>
                                        <div class="col-auto">
                                            <div
                                                class="icon icon-shape bg-primary text-white rounded-circle shadow">
                                                <i class="fa fa-robot"></i>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if(!$vendorViewBySuperAdmin): ?>
                                    <p class="mt-3 mb-0 text-muted text-sm">
                                        <a href="<?php echo e(route('vendor.bot_reply.read.list_view')); ?>"><?php echo e(__tr('Manage Bot Replies')); ?></a>
                                    </p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        
                        <?php endif; ?>
                          
                          <?php if(hasVendorAccess('administrative')): ?>
                          <div class="col-xl-3 col-lg-4 col-md-6 mb-md-4">
                             <div class="card card-stats mb-4 mb-xl-0">
                                 <div class="card-body">
                                     <div class="row">
                                         <div class="col">
                                             <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e(__tr('Active Team Members')); ?></h5>
                                             <span class="h2 font-weight-bold mb-0"><?php echo e(__tr($activeTeamMembers)); ?></span>
                                         </div>
                                         <div class="col-auto">
                                             <div
                                                 class="icon icon-shape bg-warning text-white rounded-circle shadow">
                                                 <i class="fas fa-user-tie"></i>
                                             </div>
                                         </div>
                                     </div>
                                     <?php if(!$vendorViewBySuperAdmin): ?>
                                     <p class="mt-3 mb-0 text-muted text-sm">
                                         <a href="<?php echo e(route('vendor.user.read.list_view')); ?>"><?php echo e(__tr('Manage Team Member')); ?></a>
                                     </p>
                                     <?php endif; ?>
                                 </div>
                             </div>
                         </div>
                         <?php endif; ?>
                         
                          
                        <?php if(hasVendorAccess('manage_campaigns')): ?>
                        <div class="col-xl-3 col-lg-4 col-md-6 mb-md-4">
                            <div class="card card-stats mb-4 mb-xl-0">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col">
                                            <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e(__tr('Messages in Queue')); ?></h5>
                                            <span class="h2 font-weight-bold mb-0"><?php echo e(__tr($messagesInQueue)); ?></span>
                                        </div>
                                        <div class="col-auto">
                                            <div class="icon icon-shape bg-primary text-white rounded-circle shadow">
                                                <i class="fas fa-stream text-gray-300"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                         
                        <?php if(hasVendorAccess('messaging')): ?>
                        <div class="col-md-6 col-lg col-sm-12">
                            <div class="card card-stats mb-4 mb-xl-0">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col">
                                            <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e(__tr('Messages Processed')); ?></h5>
                                            <span class="h2 font-weight-bold mb-0"><?php echo e(__tr($totalMessagesProcessed)); ?></span>
                                        </div>
                                        <div class="col-auto">
                                            <div class="icon icon-shape bg-primary text-white rounded-circle shadow">
                                                <i class="fas fa-tasks text-gray-300"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                         
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?><?php /**PATH /home/ndmidia/public_html/chatbot.ndmidia.com.br/resources/views/layouts/headers/cards.blade.php ENDPATH**/ ?>