<?php
    $currentAppTheme = '';
    $currentAppTheme = getUserAppTheme();
?>

<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?= config('CURRENT_LOCALE_DIRECTION') ?>">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="">
    <!-- Primary Meta Tags -->
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <meta name="title" content="<?php echo $__env->yieldContent('title'); ?>">
    <meta name="description" content="<?php echo $__env->yieldContent('title'); ?>">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo e(url('/')); ?>">
    <meta property="og:title" content="<?php echo $__env->yieldContent('title'); ?>">
    <meta property="og:description" content="<?php echo $__env->yieldContent('title'); ?>">
    <meta property="og:image" content="<?php echo e(getAppSettings('logo_image_url')); ?>">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo e(url('/')); ?>">
    <meta property="twitter:title" content="<?php echo $__env->yieldContent('title'); ?>">
    <meta property="twitter:description" content="<?php echo $__env->yieldContent('title'); ?>">
    <meta property="twitter:image" content="<?php echo e(getAppSettings('logo_image_url')); ?>">

    <?= __yesset(['static-assets/packages/fontawesome/css/all.css', 'dist/css/vendorlibs.css', 'argon/css/argon.min.css', 'dist/css/app.css'], true) ?>

    <link rel="shortcut icon" href="<?= getAppSettings('favicon_image_url') ?>" type="image/x-icon">
    <link rel="icon" href="<?= getAppSettings('favicon_image_url') ?>" type="image/x-icon">

    <!-- App Theme Change -->
    <?php if($currentAppTheme == 'dark'): ?>
        <link rel="stylesheet" href="<?php echo e(__yesset('dist/css/dark-theme.css')); ?>">
        <!-- Dark Theme Favicon -->
        <link href="<?php echo e(getAppSettings('dark_theme_favicon_image_url')); ?>" rel="icon"
            media="(prefers-color-scheme: dark)">
    <?php elseif($currentAppTheme == 'system_default'): ?>
        <link rel="stylesheet" href="<?php echo e(__yesset('dist/css/dark-theme.css')); ?>" media="(prefers-color-scheme: dark)">
    <?php endif; ?>
    <!-- /App Theme Change -->
</head>

<body id="page-top" class="lw-gradient-bg">

  
 
    <!-- Page Wrapper -->
    <!-- Begin Page Content -->
    <div class="lw-page-content lw-other-page-content lw-error-page-block-section">
        <section class="container text-center">
            <!-- App Theme Change -->
            <?php if($currentAppTheme == 'dark'): ?>
                
                <img src="<?php echo e(getAppSettings('dark_theme_logo_image_url')); ?>" class=" dark-theme-logo lw-error-logo mb-5"
                    alt="<?php echo e(getAppSettings('name')); ?>">
                <!-- /dark theme -->
            <?php elseif($currentAppTheme == 'system_default'): ?>
                <img src="<?php echo e(getAppSettings('logo_image_url')); ?>"
                    class="light-theme-logo system-theme-light-logo lw-error-logo" alt="<?php echo e(getAppSettings('name')); ?>">
                
                <img src="<?php echo e(getAppSettings('dark_theme_logo_image_url')); ?> mb-5"
                    class=" dark-theme-logo system-theme-dark-logo lw-error-logo mb-5"
                    alt="<?php echo e(getAppSettings('name')); ?>" media="(prefers-color-scheme: dark)">
            <?php else: ?>
                
                <img src="<?php echo e(getAppSettings('logo_image_url')); ?>" class="light-theme-logo lw-error-logo mb-5"
                    alt="<?php echo e(getAppSettings('name')); ?>">
                <!-- /App Theme Change -->
            <?php endif; ?>
            <!-- App Theme Change -->

            <div class="row">
                <div class="col-lg-7 col-sm-12 m-auto col-xl-5">
                    <div class="lw-error-page-block d-flex justify-content-center align-items-center p-5">
                        <div class="row">
                            <div class="col-12">
                                <i class="far fa-frown fa-5x text-danger"></i>
                                <h1 class="fa-7x font-weight-bold"><?php echo $__env->yieldContent('code'); ?></h1>
                                <h2 class="text-dark font-weight-bold"> <?php echo $__env->yieldContent('title'); ?></h2>
                                <p class="my-3" ><?php echo $__env->yieldContent('message'); ?></p>
                                <a href="<?php echo e(url('')); ?>" class="btn btn-primary"><?php echo e(__tr('Back to Home')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</body>

</html>
<?php /**PATH /home/ndmidia/public_html/chatbot.ndmidia.com.br/resources/views/errors/minimal.blade.php ENDPATH**/ ?>