<!DOCTYPE html>
<?php

    $currentAppTheme = '';
    // Default theme from settings
    $currentAppTheme = getUserAppTheme();
?>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e($CURRENT_LOCALE_DIRECTION ?? ''); ?>"
    data-theme="<?php echo e($currentAppTheme); ?>">
<?php
    $appName = getAppSettings('name');
    $currentAppTheme = '';
    // Default theme from settings
    $currentAppTheme = getUserAppTheme();
?>

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title> <?php echo e((isset($title) and $title) ? ' - ' . $title : __tr('Welcome')); ?> - <?php echo e($appName); ?></title>
    <!-- Primary Meta Tags -->
    <meta name="title" content="<?php echo e($appName); ?>" />
    <meta name="description" content="<?php echo e(getAppSettings('description')); ?>" />
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="<?php echo e($appName); ?>" />
    <meta property="og:url" content="<?php echo e(url('/')); ?>" />
    <meta property="og:title" content="<?php echo e($appName); ?>" />
    <meta property="og:description" content="<?php echo e(getAppSettings('description')); ?>" />
    <meta property="og:image" content="<?php echo e(getAppSettings('logo_image_url')); ?>" />

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image" />
    <meta property="twitter:url" content="<?php echo e(url('/')); ?>" />
    <meta property="twitter:title" content="<?php echo e($appName); ?>" />
    <meta property="twitter:description" content="<?php echo e(getAppSettings('description')); ?>" />
    <meta property="twitter:image" content="<?php echo e(getAppSettings('logo_image_url')); ?>" />


    <!-- Light Theme Favicon -->
    <link href="<?php echo e(getAppSettings('favicon_image_url')); ?>" rel="icon" media="(prefers-color-scheme: light)">

    <!-- Dark Theme Favicon -->
    <link href="<?php echo e(getAppSettings('dark_theme_favicon_image_url')); ?>" rel="icon"
        media="(prefers-color-scheme: dark)">

    <?php echo __yesset([
        'static-assets/packages/fontawesome/css/all.css',
        'static-assets/packages/bootstrap-icons/font/bootstrap-icons.css',
    ]); ?>

    <!-- Google fonts-->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet">
    <!-- /Google fonts-->

    <!-- /App Theme Change -->
    <link rel="stylesheet" href="<?php echo e(__yesset('dist/css/app-theme.css')); ?>">
</head>

<body id="page-top" class="lw-outer-home-page">
    <!-- Navigation-->
    <nav class="navbar navbar-expand-lg fixed-top bg-dark-blue" id="mainNav">
        <div class="container">
            <!-- Logo -->
            <a class="navbar-brand pt-0" href="<?php echo e(url('/')); ?>">
                <!-- App Theme Change -->
                <?php if($currentAppTheme == 'dark'): ?>
                    
                    <img src="<?php echo e(getAppSettings('dark_theme_logo_image_url')); ?>"
                        class="navbar-brand-img  dark-theme-logo" alt="<?php echo e(getAppSettings('name')); ?>">
                    <!-- /dark theme -->
                <?php elseif($currentAppTheme == 'system_default'): ?>
                    <img src="<?php echo e(getAppSettings('logo_image_url')); ?>"
                        class="navbar-brand-img light-theme-logo system-theme-light-logo"
                        alt="<?php echo e(getAppSettings('name')); ?>">
                    
                    <img src="<?php echo e(getAppSettings('dark_theme_logo_image_url')); ?>"
                        class="navbar-brand-img  dark-theme-logo system-theme-dark-logo"
                        alt="<?php echo e(getAppSettings('name')); ?>" media="(prefers-color-scheme: dark)">
                <?php else: ?>
                    
                    <img src="<?php echo e(getAppSettings('logo_image_url')); ?>" class="navbar-brand-img light-theme-logo"
                        alt="<?php echo e(getAppSettings('name')); ?>">
                    <!-- /App Theme Change -->
                <?php endif; ?>
                <!-- App Theme Change -->
            </a>
            <!-- Logo -->
            <button class="navbar-toggler lw-btn-block-mobile" type="button" data-bs-toggle="collapse"
                data-bs-target="#navbarResponsive" aria-controls="navbarResponsive" aria-expanded="false"
                aria-label="<?php echo e(__tr('Toggle navigation')); ?>">
                <?php echo e(__tr('Menu')); ?>

                <i class="bi-list"></i>
            </button>
            <div class="collapse navbar-collapse" id="navbarResponsive">
                <ul class="navbar-nav ms-auto me-4 my-3 my-lg-0 text-center">

                    <!-- Features -->
                    <li class="nav-item"><a class="nav-link" href="#features"><?php echo e(__tr('Features')); ?></a>
                    </li>
                    <!-- /Features -->

                    <!-- Pricing -->
                    <li class="nav-item"><a class="nav-link" href="#pricing"><?php echo e(__tr('Pricing')); ?></a></li>
                    <!-- /Pricing -->

                    <!-- Contact -->
                    <li class="nav-item"><a class="nav-link"
                            href="<?php echo e(route('user.contact.form')); ?>"><?php echo e(__tr('Contact')); ?></a></li>
                    <!-- /Contact -->

                    <!-- pages -->
                    <li class="nav-item">
                        <?php echo $__env->make('layouts.navbars.navs.pages-menu-partial', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </li>
                    <!-- /pages -->
                    <!--theme change -->
                    <?php if(getAppSettings('allow_to_change_theme')): ?>
                        <li class="nav-item">
                            <?php echo $__env->make('layouts.navbars.app-theme', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        </li>
                    <?php endif; ?>
                    <!--theme change -->
                    <!-- language -->
                    <?php echo $__env->make('layouts.navbars.locale-menu', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <!-- /language -->

                    <?php if(!isLoggedIn()): ?>
                        <?php if(getAppSettings('enable_vendor_registration') or getAppSettings('message_for_disabled_registration')): ?>
                            <!-- Register -->
                            <li class="nav-item"><a class="nav-link text-danger fw-bold"
                                    href="<?php echo e(route('auth.register')); ?>"><?php echo e(__tr('Register')); ?></a></li>
                        <?php endif; ?>
                        <!-- /Register -->

                        <!-- Login -->
                        <li class="nav-item"><a class="nav-link "
                                href="<?php echo e(route('auth.login')); ?>"><?php echo e(__tr('Login')); ?></a></li>
                    <?php endif; ?>
                    <!-- /Login -->

                    <!-- Dashboard -->
                    <?php if(isLoggedIn()): ?>
                        <li class="nav-item"><a class="nav-link fw-bold text-orange lw-warning-text"
                                href="<?php echo e(route('central.console')); ?>"><?php echo e(__tr('Dashboard')); ?></a></li>
                    <?php endif; ?>
                    <!-- /Dashboard -->
                </ul>
            </div>
        </div>
    </nav>
    <!-- /Navigation -->

    <!-- masthead section -->
    <header class="bg-dark-blue">
        <div class="container">
            <div class="lw-masthead-section d-flex align-items-center">
                <div class="text-white text-center">
                    <!-- heading -->
                    <div class="lw-masthead-title fw-bolder">
                        <?php echo e(__tr('Transform Customer Engagement with WhatsApp – Experience the Power of __appName__', [
                            '__appName__' => $appName,
                        ])); ?>

                    </div>
                    <!-- heading -->

                    <!-- description -->
                    <div class="description my-4">
                        <?php echo e(__tr(
                            'Unlock the full potential of customer engagement with __appName__  your comprehensive WhatsApp Marketing Platform.',
                            [
                                '__appName__' => $appName,
                            ],
                        )); ?>

                    </div>
                    <!-- /description -->

                    <!-- buttons -->
                    <div class="my-5">
                        <a href="<?php echo e(route('auth.login')); ?>" class="btn btn-primary mx-1 lw-special-btn">
                            <?php echo e(__tr('Get Started')); ?>

                        </a>
                        <a href="<?php echo e(route('auth.register')); ?>" class="btn btn-secondary mx-1">
                            <?php echo e(__tr('Learn more')); ?>

                        </a>
                    </div>
                    <!-- buttons -->

                    <!-- image -->
                    <div class="mt-4"><img class="" src="<?php echo e(asset('imgs/outer-home/lw-masthead.png')); ?>"
                            alt="lw-masthead" />
                    </div>
                    <!-- /image -->
                </div>
            </div>
        </div>
    </header>
    <!-- /masthead section -->

    <!-- why choose section -->
    <section class="lw-why-choose-section">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-sm-12 col-md-12 col-lg-6">

                    <!-- heading -->
                    <h5 class="text-primary">
                        <?php echo e(__tr('Why __appName__ Stands Out :', [
                            '__appName__' => $appName,
                        ])); ?>

                    </h5>
                    <h1 class="fw-bold"><?php echo e(__tr('Top Reasons to Choose Our Services')); ?></h1>
                    <!-- /heading -->

                    <!-- Increased Engagement -->
                    <div class="card d-flex flex-row mt-4 mb-3">
                        <i class="fas fa-trophy"></i>
                        <div class="ms-3">
                            <h6><?php echo e(__tr('Increased Engagement')); ?></h6>
                            <p><?php echo e(__tr('Engage directly with your customers in real-time on WhatsApp.')); ?>

                            </p>
                        </div>
                    </div>
                    <!-- /Increased Engagement -->

                    <!-- Higher Conversion -->
                    <div class="card d-flex flex-row mb-3">
                        <i class="fas fa-people-arrows btn-primary"></i>
                        <div class="ms-3">
                            <h6><?php echo e(__tr('Higher Conversion Rates')); ?></h6>
                            <p><?php echo e(__tr('Turn conversations into conversions with targeted messaging through __appName__.',
                                [
                                    '__appName__' => $appName,
                                ],
                            )); ?>

                            </p>
                        </div>
                    </div>
                    <!-- /Higher Conversion -->

                    <!-- Customer Support -->
                    <div class="card d-flex flex-row mb-3">
                        <i class="fas fa-hands-helping btn-secondary"></i>
                        <div class="ms-3">
                            <h6><?php echo e(__tr('24/7 Customer Support')); ?></h6>
                            <p><?php echo e(__tr("Automated responses ensure you're always there for your customers with __appName__.", [
                                    '__appName__' => $appName,
                                ],
                            )); ?>

                            </p>
                        </div>
                    </div>
                    <!-- /Customer Support -->
                </div>
                <div class="col-sm-12 col-md-12 col-lg-6">
                    <!-- image -->
                    <img class="img-fluid image-fluid" src="<?php echo e(asset('imgs/outer-home/why-choose.png')); ?>" />
                    <!-- image -->
                </div>
            </div>
        </div>
    </section>
    <!-- /why choose section -->

    <!-- Features section -->
    <section class="lw-features-section" id="features">
        <div class="container">
            <!-- heading -->
            <h1 class="text-center text-primary mb-5 fw-bolder">
                <?php echo e(__tr('__appName__ : Simplify Connections, Boost Your Brand!', [
                    '__appName__' => $appName,
                ])); ?>

            </h1>
            <!-- /heading -->
            <!-- Campaign Management -->
            <div class="row align-items-center p-3">
                <div class="col-sm-12 col-md-12 col-lg-6">

                    <!-- heading -->
                    <h4 class="fw-bold my-4"><?php echo e(__tr('Campaign Management')); ?></h4>
                    <!-- /heading -->

                    <!-- description -->
                    <p class="lw-secondary-text">
                        <?php echo e(__tr('Effortlessly manage your campaigns with our intuitive campaign management feature. Create or schedule campaigns instantly for all contacts or specific groups, allowing for immediate reach or strategic timing. Maximize the impact of your marketing efforts and take control of your messaging with ease.')); ?>

                    </p>
                    <!-- /description -->

                    <!-- button -->
                    <a href="<?php echo e(route('auth.login')); ?>" class="btn text-primary"><?php echo e(__tr('Learn more')); ?>

                        <span><i class="fa fa-arrow-right"></i></span></a>
                    <!-- / button -->
                </div>
                <div class="col-sm-12 col-md-12 col-lg-6">
                    <!-- image -->
                    <img class="img-fluid my-4 image-fluid" src="<?php echo e(asset('imgs/outer-home/campaign-man.png')); ?>" />
                    <!-- image -->
                </div>
            </div>
            <!-- /Campaign Management -->

            <!-- Application Colors System -->
            <div class="row align-items-center p-3 lw-flex-wrap">
                <div class="col-sm-12 col-md-12 col-lg-6">
                    <!-- image -->
                    <img class="img-fluid my-4 image-block"
                        src="<?php echo e(asset('imgs/outer-home/app-color-system.png')); ?>" />
                    <!-- image -->
                </div>
                <div class="col-sm-12 col-md-12 col-lg-6">

                    <!-- heading -->
                    <h4 class="fw-bold my-4"><?php echo e(__tr('Application Colors  System')); ?></h4>
                    <!-- /heading -->

                    <!-- description -->
                    <p class="lw-secondary-text">
                        <?php echo e(__tr(
                            'Custom app colors made easy — __appName__ gives you the power of pick and apply the colors to customize your app as per your choice.',
                            [
                                '__appName__' => $appName,
                            ],
                        )); ?>

                    </p>
                    <!-- /description -->

                    <!-- button -->
                    <a href="<?php echo e(route('auth.login')); ?>" class="btn text-primary"><?php echo e(__tr('Learn more')); ?>

                        <span><i class="fa fa-arrow-right"></i></span></a>
                    <!-- / button -->
                </div>
            </div>
            <!-- /Application Colors System -->

            <!-- Flowise AI -->
            <div class="row align-items-center p-3">
                <div class="col-sm-12 col-md-12 col-lg-6">

                    <!-- heading -->
                    <h4 class="fw-bold my-4"><?php echo e(__tr('AI Bot Integration For Vendor Using Flowise AI Setting')); ?>

                    </h4>
                    <!-- /heading -->

                    <!-- description -->
                    <p class="lw-secondary-text">
                        <?php echo e(__tr('Flowise AI offers AI-powered chatbots for vendors to automate customer interactions and enhance engagement.')); ?>

                    </p>
                    <!-- /description -->

                    <!-- button -->
                    <a href="<?php echo e(route('auth.login')); ?>" class="btn text-primary"><?php echo e(__tr('Learn more')); ?>

                        <span><i class="fa fa-arrow-right"></i></span></a>
                    <!-- / button -->
                </div>
                <div class="col-sm-12 col-md-12 col-lg-6">
                    <!-- image -->
                    <img class="img-fluid my-4" src="<?php echo e(asset('imgs/outer-home/ai-bot-integration.png')); ?>" />
                    <!-- image -->
                </div>
            </div>
            <!-- /Flowise AI -->

            <!-- Subscription system used Stripe -->
            <div class="row align-items-center p-3 lw-flex-wrap">
                <div class="col-sm-12 col-md-12 col-lg-6">
                    <!-- image -->
                    <img class="img-fluid my-4 image-block" src="<?php echo e(asset('imgs/outer-home/payment.png')); ?>" />
                    <!-- image -->
                </div>
                <div class="col-sm-12 col-md-12 col-lg-6">

                    <!-- heading -->
                    <h4 class="fw-bold my-4"><?php echo e(__tr('Subscription System Used Stripe')); ?></h4>
                    <!-- /heading -->

                    <!-- description -->
                    <p class="lw-secondary-text">
                        <?php echo e(__tr('Automate recurring Subscription Payments effortlessly with Stripe. Receive payments from your users seamlessly, ensuring a smooth and efficient subscription process. Simplify your payment management and enhance user experience with our Stripe integration.')); ?>

                    </p>
                    <!-- /description -->

                    <!-- button -->
                    <a href="<?php echo e(route('auth.login')); ?>" class="btn text-primary"><?php echo e(__tr('Learn more')); ?>

                        <span><i class="fa fa-arrow-right"></i></span></a>
                    <!-- / button -->
                </div>
            </div>
            <!-- /Subscription system used Stripe -->
        </div>
    </section>
    <!-- /Features section -->

    <!-- advance features section -->
    <section class="bg-dark-blue lw-advanced-feature-cards">
        <div class="container">
            <!-- Heading -->
            <div class="text-center text-white mb-5">
                <h1 class="fw-bolder mb-3"><?php echo e(__tr('Tech Empowerment')); ?> </h1>
                <p><?php echo e(__tr('Features that would make your life easier with WhatsApp Marketing')); ?></p>
            </div>
            <!-- /Heading -->
            <div class="row">
                <!-- Embedded Signup -->
                <div class="col-sm-12 col-md-6 col-lg-3 mb-4">
                    <div class="card border-0 h-100 text-center text-white">
                        <i class="fas fa-sign-in-alt"></i>
                        <h5 class="mt-3 mb-2 fw-normal"><?php echo e(__tr('Embedded Signup')); ?></h5>
                        <p class="fw-light m-0">
                            <?php echo e(__tr('Onboard customers with ease with our integrated Embedded Signup system.')); ?>

                        </p>
                    </div>
                </div>
                <!-- /Embedded Signup -->

                <!-- Template Management -->
                <div class="col-sm-12 col-md-6 col-lg-3 mb-4">
                    <div class="card border-0 h-100 text-center text-white">
                        <i class="fas fa-file-invoice"></i>
                        <h5 class="mt-3 mb-2 fw-normal"><?php echo e(__tr('Template Management')); ?></h5>
                        <p class="fw-light m-0">
                            <?php echo e(__tr('Handle templates directly within the application without requiring a visit to Meta for creating templates.')); ?>

                        </p>
                    </div>
                </div>
                <!-- /Template Management -->

                <!-- Multiple Phone Numbers -->
                <div class="col-sm-12 col-md-6 col-lg-3 mb-4">
                    <div class="card border-0 h-100 text-center text-white">
                        <i class="fas fa-phone-alt"></i>
                        <h5 class="mt-3 mb-2 fw-normal"><?php echo e(__tr('Multiple Phone Numbers')); ?></h5>
                        <p class="fw-light m-0">
                            <?php echo e(__tr('Supports multiple phone numbers for  same WhatsApp Business Account.')); ?>

                        </p>
                    </div>
                </div>
                <!-- /Multiple Phone Numbers -->

                <!-- WhatsApp Chat -->
                <div class="col-sm-12 col-md-6 col-lg-3 mb-4">
                    <div class="card border-0 h-100 text-center text-white">
                        <i class="fab fa-rocketchat"></i>
                        <h5 class="mt-3 mb-2 fw-normal"><?php echo e(__tr('WhatsApp Chat')); ?></h5>
                        <p class="fw-light m-0">
                            <?php echo e(__tr(
                                '__appName__ chat feature replicates the native WhatsApp interface, guaranteeing users a seamless and familiar messaging experience.',
                                [
                                    '__appName__' => $appName,
                                ],
                            )); ?>

                        </p>
                    </div>
                </div>
                <!-- /WhatsApp Chat -->

                <!-- Bot Replies/ Chat Bot -->
                <div class="col-sm-12 col-md-6 col-lg-3 mb-4">
                    <div class="card border-0 h-100 text-center text-white">
                        <i class="fas fa-robot"></i>
                        <h5 class="mt-3 mb-2 fw-normal"><?php echo e(__tr('Bot Replies/ Chat Bot')); ?></h5>
                        <p class="fw-light m-0">
                            <?php echo e(__tr('Automate responses and engage customers 24/7 with intelligent bot replies through.')); ?>

                        </p>
                    </div>
                </div>
                <!-- /Bot Replies/ Chat Bot -->

                <!-- APIs -->
                <div class="col-sm-12 col-md-6 col-lg-3 mb-4">
                    <div class="card border-0 h-100 text-center text-white">
                        <i class="fas fa-cogs"></i>
                        <h5 class="mt-3 mb-2 fw-normal"><?php echo e(__tr('APIs to connect with other services')); ?></h5>
                        <p class="fw-light m-0">
                            <?php echo e(__tr('API’s enable seamless connection between different services, allowing data sharing and functionality integration.')); ?>

                        </p>
                    </div>
                </div>
                <!-- /APIs -->

                <!-- Custom Fields -->
                <div class="col-sm-12 col-md-6 col-lg-3 mb-4">
                    <div class="card border-0 h-100 text-center text-white">
                        <i class="fas fa-bars"></i>
                        <h5 class="mt-3 mb-2 fw-normal"><?php echo e(__tr('Custom Fields')); ?></h5>
                        <p class="fw-light m-0">
                            <?php echo e(__tr('Personalize your messages with user base information and custom fields tailored to your audience on __appName__', ['__appName__' => $appName])); ?>

                        </p>
                    </div>
                </div>
                <!-- /Custom Fields -->

                <!-- Team Members/Agents -->
                <div class="col-sm-12 col-md-6 col-lg-3 mb-4">
                    <div class="card border-0 h-100 text-center text-white">
                        <i class="fas fa-user"></i>
                        <h5 class="mt-3 mb-2 fw-normal"><?php echo e(__tr('Team Members/Agents')); ?></h5>
                        <p class="fw-light m-0">
                            <?php echo e(__tr('Onboard customers with ease with our integrated Embedded Signup system.')); ?>

                        </p>
                    </div>
                </div>
                <!-- /Team Members/Agents -->
            </div>
        </div>
    </section>
    <!-- /advance features section -->

    <!-- call to action -->
    <section class="lw-call-to-action-block">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-sm-12 col-md-12 col-lg-6">
                    <!-- heading -->
                    <h2 class="fw-bold mb-3 text-primary"><?php echo e(__tr('Built for Customer Engagements')); ?>

                    </h2>
                    <!-- /heading -->

                    <!-- description -->
                    <p class="lw-secondary-text">
                        <?php echo e(__tr('__appName__ is a helpful tool for businesses to communicate better with customers. It makes talking to customers easier and simpler, helping businesses grow and build strong relationships.', ['__appName__' => $appName])); ?>

                    </p>
                    <!-- /description -->

                    <!-- button -->
                    <a href="<?php echo e(route('auth.register')); ?>"
                        class="btn btn-primary lw-special-btn"><?php echo e(__tr('Sign up now')); ?> </a>
                    <!-- / button -->
                </div>
                <div class="col-sm-12 col-md-12 col-lg-6">
                    <!-- image -->
                    <img class="img-fluid my-4 lw-call-to-action-img"
                        src="<?php echo e(asset('imgs/outer-home/call-to-action-img.png')); ?>" />
                    <!-- image -->
                </div>
            </div>
        </div>
    </section>
    <!-- /call to action -->

    <!-- AI bot features -->
    <section class="bg-dark-blue lw-ai-oi-cards">
        <div class="container">
            <!-- heading -->
            <h2 class="fw-bold mb-5 text-white text-center">
                <?php echo e(__tr('AI Chat Bot Quickly build Automated Chatbots')); ?>

            </h2>
            <!-- /heading -->

            <div class="lw-ai-card">
                <!-- Bot Flow Builder -->
                <div class="lw-card-io-list">
                    <span><?php echo e(__tr('Bot Flow Builder')); ?></span>
                    <div class="lw-card-io-list-content w-100 fade-in">
                        <p class="text-center text-white px-5">
                            <?php echo e(__tr('Our Advanced Bot Flow Builder streamlines bot conversation creation, enabling easy setup of triggers between bots using button and list row links.')); ?>

                        </p>
                        <div class="d-flex justify-content-center">
                            <!-- image -->
                            <img class="img-fluid" src="<?php echo e(asset('imgs/outer-home/aibot.png')); ?>" />
                            <!-- /image -->
                        </div>
                    </div>
                </div>
                <!-- /Bot Flow Builder -->

                <!-- Bot Timing restrictions setting -->
                <div class="lw-card-io-list">
                    <span><?php echo e(__tr('Bot Timing Restrictions Setting')); ?></span>
                    <div class="lw-card-io-list-content w-100  fade-in">
                        <p class="text-center text-white px-5">
                            <?php echo e(__tr('Set bot operation hours with start/end times, timezone, and enable timing for specific bots, applying restrictions only to selected bots.')); ?>

                        </p>
                        <div class="d-flex justify-content-center">
                            <!-- image -->
                            <img class="img-fluid lw-ai-bot-img"
                                src="<?php echo e(asset('imgs/outer-home/ai-timing.png')); ?>" />
                            <!-- /image -->
                        </div>
                    </div>
                </div>
                <!-- /Bot Timing restrictions setting -->

                <!-- AI Start / Stop Bots -->
                <div class="lw-card-io-list">
                    <span><?php echo e(__tr('AI General Setting')); ?></span>
                    <div class="lw-card-io-list-content w-100  fade-in">
                        <p class="text-center text-white px-5">
                            <?php echo e(__tr('A message will be sent if the AI Bot fails to respond due to an error. You can also enable the AI Bot automatically for all new contacts created from incoming messages or imports.')); ?>

                        </p>
                        <div class="d-flex justify-content-center">
                            <!-- image -->
                            <img class="img-fluid lw-ai-bot-img"
                                src="<?php echo e(asset('imgs/outer-home/ai-general-setting.png')); ?>" />
                            <!-- /image -->
                        </div>
                    </div>
                </div>
                <!-- /AI Start / Stop Bots -->
            </div>
        </div>
    </section>
    <!-- /AI bot features -->

    <!-- pricing blocks -->
    <section class="lw-pricing-block-cards" id="pricing">
        <div class="container text-center">
            <!-- heading -->
            <button class="lw-link-primary text-primary border-0 mb-4"><?php echo e(__tr('Our Solution')); ?></button>
            <h1 class="fw-bold mb-5 text-center text-white"><?php echo e(__tr('Pricing or Features')); ?>

            </h1>
            <!-- /heading -->
            <!-- free plan  -->
            <div class="row justify-content-center">
                <?php
                    $freePlanDetails = getFreePlan();
                    $freePlanStructure = getConfigFreePlan();
                    $paidPlans = getPaidPlans();
                    $planStructure = getConfigPaidPlans();
                ?>

                <?php if($freePlanDetails['enabled']): ?>
                    <div class="col-sm-12 col-md-6 col-lg-4 col-xl-4 mb-4">
                        <div class="card border-0 text-center text-dark h-100">
                            <div class="card-header bg-transparent border-0">
                                <!-- title -->
                                <h4 class="mt-3"><?php echo e($freePlanDetails['title']); ?></h4>
                                <!-- title -->
                            </div>
                            <hr class="my-3">
                            <div class="card-body">
                                <!--  pricing -->
                                <h3 class="price mb-4"><?php echo e(formatAmount(0, true, true)); ?>

                                    <span><?php echo e(__tr('/ monthly')); ?></span>
                                </h3>
                                <br>
                                <h3 class="price mb-4">
                                    <?php echo e(formatAmount(0, true, true)); ?><span><?php echo e(__tr('/ yearly')); ?></span>
                                </h3>
                                <!--  /pricing -->

                                <small><a class="text-muted " target="_blank"
                                        href="https://business.whatsapp.com/products/platform-pricing"><?php echo e(__tr('+ WhatsApp Cloud Messaging Charges')); ?>

                                        <i class="fas fa-external-link-alt "></i></a></small>
                                <hr class="my-4">
                                <!-- features  -->
                                <ul class="p-0 m-0">
                                    <?php $__currentLoopData = $freePlanStructure['features']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $featureKey => $featureValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $configFeatureValue = $featureValue;
                                            $featureValue = $freePlanDetails['features'][$featureKey];
                                        ?>
                                        <li>
                                            <?php if(isset($featureValue['type']) and $featureValue['type'] == 'switch'): ?>
                                                <?php if(isset($featureValue['limit']) and $featureValue['limit']): ?>
                                                    <i class="fa fa-check mr-3 text-success"></i>
                                                <?php else: ?>
                                                    <i class="fa fa-times mr-3 text-danger"></i>
                                                <?php endif; ?>
                                                <?php echo e($configFeatureValue['description']); ?>

                                            <?php else: ?>
                                                <strong>
                                                    <?php if(isset($featureValue['limit']) and $featureValue['limit'] < 0): ?>
                                                        <?php echo e(__tr('Unlimited')); ?>

                                                    <?php elseif(isset($featureValue['limit'])): ?>
                                                        <?php echo e(__tr($featureValue['limit'])); ?>

                                                    <?php endif; ?>
                                                </strong>
                                                <?php echo e($configFeatureValue['description']); ?>

                                                <?php echo e($configFeatureValue['limit_duration_title'] ?? ''); ?>

                                            <?php endif; ?>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                                <!-- /features -->
                                <div class="pricing-price"></div>
                            </div>
                        </div>
                    </div>
                    <!-- /free plan-->
                <?php endif; ?>
                <!-- paid plan -->
                <?php $__currentLoopData = $planStructure; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $planKey => $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $planId = $plan['id'];
                        $features = $plan['features'];
                        $savedPlan = $paidPlans[$planKey];
                        $charges = $savedPlan['charges'];
                        if (!$savedPlan['enabled']) {
                            continue;
                        }
                    ?>
                    <div class="col-sm-12 col-md-6 col-lg-4 col-xl-4 mb-4">
                        <div class="card border-0 text-center text-dark h-100">
                            <div class="card-header border-0 bg-transparent">
                                <!-- title -->
                                <h4 class="mt-3"><?php echo e($savedPlan['title'] ?? $plan['title']); ?>

                                </h4>
                                <!-- /title -->
                            </div>
                            <hr class="my-3">
                            <div class="card-body">

                                <!--  pricing -->
                                <?php $__currentLoopData = $charges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $itemKey => $itemValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        if (!$itemValue['enabled']) {
                                            continue;
                                        }
                                    ?>
                                    <h2 class="price mb-3">
                                        <?php echo e(formatAmount($itemValue['charge'], true, true)); ?><span>
                                            /<?php echo e(Arr::get($plan['charges'][$itemKey], 'title', '')); ?></span></h2>
                                    <br>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <!--  /pricing -->

                                <small><a class="text-muted" target="_blank"
                                        href="https://business.whatsapp.com/products/platform-pricing"><?php echo e(__tr('+ WhatsApp Cloud Messaging Charges')); ?>

                                        <i class="fas fa-external-link-alt"></i></a></small>

                                <hr class="my-4">
                                <!-- features  -->
                                <ul class="p-0 m-0">
                                    <?php $__currentLoopData = $plan['features']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $featureKey => $featureValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $configFeatureValue = $featureValue;
                                            $featureValue = $savedPlan['features'][$featureKey];
                                        ?>
                                        <li>
                                            <?php if(isset($featureValue['type']) and $featureValue['type'] == 'switch'): ?>
                                                <?php if(isset($featureValue['limit']) and $featureValue['limit']): ?>
                                                    <i class="fa fa-check mr-3 text-success"></i>
                                                <?php else: ?>
                                                    <i class="fa fa-times mr-3 text-danger"></i>
                                                <?php endif; ?>
                                                <?php echo e($configFeatureValue['description']); ?>

                                            <?php else: ?>
                                                <strong>
                                                    <?php if(isset($featureValue['limit']) and $featureValue['limit'] < 0): ?>
                                                        <?php echo e(__tr('Unlimited')); ?>

                                                    <?php elseif(isset($featureValue['limit'])): ?>
                                                        <?php echo e(__tr($featureValue['limit'])); ?>

                                                    <?php endif; ?>
                                                </strong>
                                                <?php echo e($configFeatureValue['description']); ?>

                                                <?php echo e($configFeatureValue['limit_duration_title'] ?? ''); ?>

                                            <?php endif; ?>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                                <!-- /features  -->
                                <div class="pricing-price"></div>
                            </div>

                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <!-- /paid plan  -->
            </div>
        </div>
    </section>
    <!-- /pricing blocks -->

    <!-- testimonials -->
    <section class="text-dark lw-testimonial-block">
        <div class="container">

            <!-- heading -->
            <h2 class="fw-bold mb-5 text-dark text-center">
                <?php echo e(__tr('Success Stories from the __appName__ Community', [
                    '__appName__' => $appName,
                ])); ?>

            </h2>
            <!-- /heading -->

            <div class="row">
                <!-- first testimonial -->
                <div class="col-sm-12 col-md-12 col-lg-4 mb-4">
                    <div class="card border-0 p-5 shadow h-100">
                        <i class="fa fa-quote-left fs-3 text-primary mb-3"></i>
                        <p class="lw-secondary-text">
                            <?php echo e(__tr(
                                'Using __appName__ has transformed our customer engagement strategy. The import/export feature is a game-changer for managing our contacts efficiently.',
                                [
                                    '__appName__' => $appName,
                                ],
                            )); ?>

                        </p>
                        <h5><?php echo e(__tr('John Doe')); ?></h5>
                        <p class="lw-secondary-text"><?php echo e(__tr('Marketing Manager')); ?></p>
                        <div class="d-flex text-warning lw-spacing">
                            <i class="fa fa-star mx-1"></i>
                            <i class="fa fa-star"></i>
                            <i class="fa fa-star mx-1"></i>
                            <i class="fa fa-star"></i>
                            <i class="fa fa-star mx-1"></i>
                        </div>
                    </div>
                </div>
                <!-- /first testimonial -->

                <div class="col-sm-12 col-md-12 col-lg-4 mb-4">
                    <div class="card border-0 p-5 shadow h-100">
                        <i class="fa fa-quote-left fs-3 text-primary mb-3"></i>
                        <p class="lw-secondary-text">
                            <?php echo e(__tr(
                                'The automation capabilities of __appName__, especially the bot replies, have significantly reduced our response times and improved customer satisfaction.',
                                [
                                    '__appName__' => $appName,
                                ],
                            )); ?>

                        </p>
                        <h5><?php echo e(__tr('Jane Smith')); ?></h5>
                        <p class="lw-secondary-text"><?php echo e(__tr('Customer Service Lead')); ?></p>
                        <div class="d-flex text-warning lw-spacing">
                            <i class="fa fa-star mx-1"></i>
                            <i class="fa fa-star"></i>
                            <i class="fa fa-star mx-1"></i>
                            <i class="fa fa-star"></i>
                            <i class="fa fa-star mx-1"></i>
                        </div>
                    </div>
                </div>

                <div class="col-sm-12 col-md-12 col-lg-4 mb-4">
                    <div class="card border-0 p-5 shadow h-100">
                        <i class="fa fa-quote-left fs-3 text-primary mb-3"></i>
                        <p class="lw-secondary-text">
                            <?php echo e(__tr(
                                '__appName__\'s intuitive design and easy Facebook WhatsApp Business integration made it simple for us to start our marketing campaigns quickly.',
                                [
                                    '__appName__' => $appName,
                                ],
                            )); ?>

                        </p>
                        <h5><?php echo e(__tr('Alex Johnson')); ?></h5>
                        <p class="lw-secondary-text"><?php echo e(__tr('Digital Marketing Specialist')); ?></p>
                        <div class="d-flex text-warning lw-spacing">
                            <i class="fa fa-star mx-1"></i>
                            <i class="fa fa-star"></i>
                            <i class="fa fa-star mx-1"></i>
                            <i class="fa fa-star"></i>
                            <i class="fa fa-star mx-1"></i>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- /testimonials -->

    <!-- FAQ -->
    <section class="bg-dark-blue">
        <div class="container">

            <!-- heading -->
            <h2 class="fw-bold mb-5 text-white text-center"><?php echo e(__tr('Frequently Asked Questions')); ?>

            </h2>
            <!-- /heading -->

            <div class="accordion" id="faqAccordion">
                <!-- FAQ Item 1 -->
                <div class="accordion-item">
                    <h5 class="accordion-header" id="headingOne">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            <?php echo e(__tr('How do I sign up for __appName__?', [
                                '__appName__' => $appName,
                            ])); ?>

                        </button>
                    </h5>
                    <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                        data-bs-parent="#faqAccordion">
                        <div class="accordion-body text-muted p-4">
                            <?php echo e(__tr(
                                'Signing up for __appName__ is easy and straightforward. Just visit our sign-up page, fill in your details, and follow the instructions to get started.',
                                [
                                    '__appName__' => $appName,
                                ],
                            )); ?>

                        </div>
                    </div>
                </div>
                <!-- /FAQ Item 1 -->

                <!-- FAQ Item 2 -->
                <div class="accordion-item">
                    <h5 class="accordion-header" id="headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            <?php echo e(__tr('Can I import contacts from an existing customer database?')); ?>

                        </button>
                    </h5>
                    <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                        data-bs-parent="#faqAccordion">
                        <div class="accordion-body text-muted p-4">
                            <?php echo e(__tr(
                                'Yes, __appName__ supports importing contacts through XLSX files. You can easily upload your existing customer database and start sending messages right away.',
                                [
                                    '__appName__' => $appName,
                                ],
                            )); ?>

                        </div>
                    </div>
                </div>
                <!-- /FAQ Item 2 -->

                <!-- FAQ Item 3 -->
                <div class="accordion-item">
                    <h5 class="accordion-header" id="headingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            <?php echo e(__tr('What kind of support does __appName__ offer?', [
                                '__appName__' => $appName,
                            ])); ?>

                        </button>
                    </h5>
                    <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree"
                        data-bs-parent="#faqAccordion">
                        <div class="accordion-body text-muted p-4">
                            <?php echo e(__tr(
                                '__appName__ offers 24/7 customer support through live chat, email, and phone. Our dedicated team is here to help you with any issues or questions you might have.',
                                [
                                    '__appName__' => $appName,
                                ],
                            )); ?>

                        </div>
                    </div>
                </div>
                <!-- /FAQ Item 3 -->
            </div>
        </div>
    </section>
    <!-- /FAQ -->

    <!-- footer -->
    <footer class="pt-5 pb-2">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-sm-12 col-md-12 col-lg-4">
                    <!-- Logo -->
                    <div class="d-flex justify-content-center">
                        <a class="navbar-brand pt-0" href="<?php echo e(url('/')); ?>">
                            <!-- App Theme Change -->
                            <?php if($currentAppTheme == 'dark'): ?>
                                
                                <img src="<?php echo e(getAppSettings('dark_theme_logo_image_url')); ?>"
                                    class="navbar-brand-img  dark-theme-logo" alt="<?php echo e(getAppSettings('name')); ?>">
                                <!-- /dark theme -->
                            <?php elseif($currentAppTheme == 'system_default'): ?>
                                <img src="<?php echo e(getAppSettings('logo_image_url')); ?>"
                                    class="navbar-brand-img light-theme-logo system-theme-light-logo"
                                    alt="<?php echo e(getAppSettings('name')); ?>">
                                
                                <img src="<?php echo e(getAppSettings('dark_theme_logo_image_url')); ?>"
                                    class="navbar-brand-img  dark-theme-logo system-theme-dark-logo"
                                    alt="<?php echo e(getAppSettings('name')); ?>" media="(prefers-color-scheme: dark)">
                            <?php else: ?>
                                
                                <img src="<?php echo e(getAppSettings('logo_image_url')); ?>"
                                    class="navbar-brand-img light-theme-logo" alt="<?php echo e(getAppSettings('name')); ?>">
                                <!-- /App Theme Change -->
                            <?php endif; ?>
                            <!-- App Theme Change -->
                        </a>
                    </div>
                    <!-- Logo -->
                </div>
                <div class="col-sm-12 col-md-12 col-lg-8">
                    <!-- Links -->
                    <div class="d-flex lw-links">
                        <a href="#" class="text-dark"><?php echo e(__tr('Home')); ?></a>
                        <div class="separator-line"></div>
                        <a href="<?php echo e(route('user.contact.form')); ?>" class="text-dark"><?php echo e(__tr('Contact')); ?></a>
                        <a href="<?php echo e(route('auth.login')); ?>" class="text-dark"><?php echo e(__tr('Login')); ?></a>
                        <a href="<?php echo e(route('auth.register')); ?>" class="text-dark"><?php echo e(__tr('Register')); ?></a>
                    </div>
                    <!-- /Links -->
                </div>
            </div>
            <hr>
            <div class="text-muted small text-center">
                <div class="mb-2">&copy; <?php echo e(getAppSettings('name')); ?> <?php echo e(__tr(date('Y'))); ?>.
                    <?php echo e(__tr('All Rights Reserved.')); ?></div>
            </div>
        </div>
    </footer>
    <!-- /footer -->

    <script>
        (function() {
            'use strict';
            window.appConfig = {
                debug: "<?php echo e(config('app.debug')); ?>",
                csrf_token: "<?php echo e(csrf_token()); ?>",
                locale: '<?php echo e(app()->getLocale()); ?>',
            }
        })();
    </script>
    <?php echo __yesset([
        'dist/js/common-vendorlibs.js',
        'dist/js/vendorlibs.js',
        'dist/packages/bootstrap/js/bootstrap.bundle.min.js',
        'dist/js/jsware.js',
    ]); ?>

    <?php echo getAppSettings('page_footer_code_all'); ?>

    <?php if(isLoggedIn()): ?>
        <?php echo getAppSettings('page_footer_code_logged_user_only'); ?>

    <?php endif; ?>
</body>

</html>
<?php /**PATH /home/ndmidia/public_html/chatbot.ndmidia.com.br/resources/views/outer-home-3.blade.php ENDPATH**/ ?>