<!-- theme Menu -->
<?php
$themeOptions = configItem('theme_options');
// Default theme from settings
$currentAppTheme = getUserAppTheme()
?>
<li class="nav-item dropdown no-arrow">
    <a class="nav-link dropdown-toggle" href="#" id="themeMenuDropdown" role="button" data-bs-toggle="dropdown"
        data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
        
        <span class="d-md-inline-block">
            <?php if($currentAppTheme === 'dark'): ?>
            <i class="fas fa-moon"></i> <!-- Icon for dark theme -->
            <?php elseif($currentAppTheme === 'light'): ?>
            <i class="fas fa-sun text-yellow"></i> <!-- Icon for light theme -->
            <?php elseif($currentAppTheme === 'system_default'): ?>
            <i class=" fas fa-desktop text-dark text-black"></i> <!-- Icon for default theme -->
            <?php else: ?>
            <i class="fas fa-palette"></i> <!-- Fallback icon for unknown themes -->
            <?php endif; ?>
        </span>
    </a>
    <ul class="dropdown-menu dropdown-menu-right dropdown-menu-end shadow animated--grow-in"
        aria-labelledby="themeMenuDropdown">
        <li class="dropdown-item dropdown-header text-gray disabled">
            <?php echo e(__tr('Choose Mode')); ?>

        </li>
        <li class="dropdown-divider"></li>
        <!-- System -->
        <li class="<?php if($currentAppTheme === 'system_default'): ?> active <?php endif; ?>">
            <a class="dropdown-item lw-ajax-link-action d-flex align-items-center" data-show-processing="true"
                href="<?php echo e(route('change.app.theme', ['themeID' => 'system_default'])); ?>">
                <span >
                    <i class="fas fa-desktop mr-3 "></i>
                </span>
                <span > <?php echo e(__tr('System')); ?></span>
            </a>
        </li>
        <!-- /System -->

        <!-- Dark -->
        <li class="<?php if($currentAppTheme  === 'dark'): ?> active <?php endif; ?>">
            <a class="dropdown-item lw-ajax-link-action d-flex align-items-center " data-show-processing="true"
                href="<?php echo e(route('change.app.theme', ['themeID' => 'dark'])); ?>">
                <span class="">
                    <i class="fas fa-moon mr-3"></i>
                </span>
                <span> <?php echo e(__tr('Dark')); ?></span>
            </a>
        </li>
        <!-- /Dark -->

        <!-- Light  -->
        <li class="<?php if($currentAppTheme  === 'light'): ?> active <?php endif; ?>">
            <a class="dropdown-item lw-ajax-link-action d-flex align-items-center " data-show-processing="true"
                href="<?php echo e(route('change.app.theme', ['themeID' => 'light'])); ?>">
                <span class="">
                    <i class="fas fa-sun mr-3 text-yellow"></i>
                </span>
                <span> <?php echo e(__tr('Light')); ?></span>
            </a>
        </li>
        <!-- /Light -->
    </ul>
</li>


<!--theme Menu --><?php /**PATH /home/ndmidia/public_html/chatbot.ndmidia.com.br/resources/views/layouts/navbars/app-theme.blade.php ENDPATH**/ ?>