<!-- theme Menu -->
<?php
//user current theme
$currentAppTheme=getUserAppTheme();
?>

<nav class="navbar navbar-vertical fixed-left navbar-expand-md navbar-light bg-white lw-sidebar-container"
    id="sidenav-main">
    <div class="container-fluid">
        <span>
            <!-- Toggler -->
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#sidenav-collapse-main"
                aria-controls="sidenav-main" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span><span class="fa fa-bars d-none"></span>
            </button>
            <!-- Brand -->
            <a class="navbar-brand pt-0 d-none d-sm-inline" href="<?php echo e(url('/')); ?>">
                <!-- App Theme Change -->
                <?php if( $currentAppTheme=='dark'): ?>
                <!-- dark theme -->
                <img src="<?php echo e(getAppSettings('dark_theme_logo_image_url')); ?>"
                    class="navbar-brand-img lw-sidebar-logo-normal dark-theme-logo text-dark" alt="<?php echo e(getAppSettings('name')); ?>">
                <img src="<?php echo e(getAppSettings('dark_theme_small_logo_image_url')); ?>"
                    class="navbar-brand-img lw-sidebar-logo-small dark-theme-small-logo text-dark"
                    alt="<?php echo e(getAppSettings('name')); ?>">
                <!-- /dark theme -->
                <?php elseif($currentAppTheme=='system_default'): ?>
                <!-- dark theme -->
                <img src="<?php echo e(getAppSettings('dark_theme_logo_image_url')); ?>"
                    class="navbar-brand-img lw-sidebar-logo-normal dark-theme-logo system-theme-dark-logo text-dark"
                    alt="<?php echo e(getAppSettings('name')); ?>" media="(prefers-color-scheme: dark)">
                <img src="<?php echo e(getAppSettings('dark_theme_small_logo_image_url')); ?>"
                    class="navbar-brand-img lw-sidebar-logo-small dark-theme-small-logo system-theme-dark-small-logo text-dark"
                    alt="<?php echo e(getAppSettings('name')); ?>">
                <!-- /dark theme -->
                <!-- light theme -->
                <img src="<?php echo e(getAppSettings('logo_image_url')); ?>"
                    class="navbar-brand-img lw-sidebar-logo-normal light-theme-logo system-theme-light-logo"
                    alt="<?php echo e(getAppSettings('name')); ?>">
                <img src="<?php echo e(getAppSettings('small_logo_image_url')); ?>"
                    class="navbar-brand-img lw-sidebar-logo-small light-theme-small-logo system-theme-light-small-logo text-dark"
                    alt="<?php echo e(getAppSettings('name')); ?>">

                <?php else: ?>
                <!-- light theme -->
                <img src="<?php echo e(getAppSettings('logo_image_url')); ?>"
                    class="navbar-brand-img lw-sidebar-logo-normal light-theme-logo" alt="<?php echo e(getAppSettings('name')); ?>">
                <img src="<?php echo e(getAppSettings('small_logo_image_url')); ?>"
                    class="navbar-brand-img lw-sidebar-logo-small light-theme-small-logo text-dark"
                    alt="<?php echo e(getAppSettings('name')); ?>">
                <!-- /light theme -->

                <?php endif; ?>
                <!-- /App Theme Change -->


            </a>
        </span>
        <!-- User -->
        <ul class="nav align-items-center d-md-none">
            <!--theme change -->
            <?php if(getAppSettings('allow_to_change_theme')): ?>
            <li class="nav-item">
                <?php echo $__env->make('layouts.navbars.app-theme', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </li>
            <?php endif; ?>
            <!--theme change -->
            <li class="nav-item">
                <?php echo $__env->make('layouts.navbars.locale-menu', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </li>
            <li class="nav-item dropdown">
                <a class="nav-link" href="#" role="button" data-toggle="dropdown" aria-haspopup="true"
                    aria-expanded="false">
                    <div class="media align-items-center">
                        <span class="avatar avatar-sm rounded-circle">
                            <i class="fa fa-user"></i>
                        </span>
                    </div>
                </a>
                <div class="dropdown-menu dropdown-menu-arrow dropdown-menu-right">
                    <div class=" dropdown-header noti-title">
                        <h6 class="text-overflow m-0"><?php echo e(__tr('Welcome!')); ?></h6>
                    </div>
                    <a href="<?php echo e(route('user.profile.edit')); ?>" class="dropdown-item">
                        <i class="fa fa-user"></i>
                        <span><?php echo e(__tr('My profile')); ?></span>
                    </a>
                    <div class="dropdown-divider"></div>
                    <a data-method="post" href="<?php echo e(route('auth.logout')); ?>" class="dropdown-item lw-ajax-link-action">
                        <i class="fas fa-sign-out-alt"></i>
                        <span><?php echo e(__tr('Logout')); ?></span>
                    </a>
                </div>
            </li>
        </ul>
        <!-- Collapse -->
        <div class="collapse navbar-collapse" id="sidenav-collapse-main">
            <!-- Collapse header -->
            <div class="navbar-collapse-header d-md-none">
                <div class="row">
                    <div class="col-6 collapse-brand">
                        <a href="<?php echo e(url('/')); ?>">

                            <!-- App Theme Change -->
                            <?php if( $currentAppTheme=='dark'): ?>

                            <!-- dark theme logo  -->
                            <img src="<?php echo e(getAppSettings('dark_theme_logo_image_url')); ?>" class="dark-theme-logo "
                                alt="<?php echo e(getAppSettings('name')); ?>">

                            <!-- /dark theme -->
                            <?php elseif($currentAppTheme=='system_default'): ?>

                            <!-- dark theme logo  -->
                            <img src="<?php echo e(getAppSettings('dark_theme_logo_image_url')); ?>"
                                class="dark-theme-logo system-theme-dark-logo" alt="<?php echo e(getAppSettings('name')); ?>">
                            <!-- light theme logo  -->
                            <img src="<?php echo e(getAppSettings('logo_image_url')); ?>"
                                class="light-theme-logo system-theme-light-logo" alt="<?php echo e(getAppSettings('name')); ?>">


                            <?php else: ?>

                            <!-- light theme logo  -->
                            <img src="<?php echo e(getAppSettings('logo_image_url')); ?>" class="light-theme-logo "
                                alt="<?php echo e(getAppSettings('name')); ?>">
                            <!-- /light theme -->

                            <?php endif; ?>
                            <!-- /App Theme Change -->


                        </a>
                    </div>
                    <div class="col-6 collapse-close">
                        <button type="button" class="navbar-toggler" data-toggle="collapse"
                            data-target="#sidenav-collapse-main" aria-controls="sidenav-main" aria-expanded="false"
                            aria-label="Toggle sidenav">
                            <span></span>
                            <span></span>
                        </button>
                    </div>
                </div>
            </div>
            <!-- Navigation -->
            <ul class="navbar-nav">
                <?php if(hasCentralAccess()): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo e(markAsActiveLink('central.console')); ?>" href="<?php echo e(route('central.console')); ?>">
                        <i class="fa fa-tachometer-alt"></i> <?php echo e(__tr('Dashboard')); ?>

                    </a>
                </li>

                <li class="nav-item <?php echo e(markAsActiveLink('central.vendors')); ?>">
                    <a class="nav-link" href="<?php echo e(route('central.vendors')); ?>">
                        <i class="fa fa-store"></i> <?php echo e(__tr('Vendors')); ?>

                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="#lwSubscriptionSubMenu" data-toggle="collapse" role="button"
                        aria-expanded="true" aria-controls="lwSubscriptionSubMenu">
                        <i class="fa fa-user-tag text-dark"></i>
                        <span class="nav-link-text"><?php echo e(__tr('Subscriptions')); ?></span>
                    </a>
                    <div class="collapse show lw-expandable-nav" id="lwSubscriptionSubMenu">
                        <ul class="nav nav-sm flex-column">
                            <li class="nav-item <?php echo e(markAsActiveLink('central.subscriptions')); ?>">
                                <a class="nav-link" href="<?php echo e(route('central.subscriptions')); ?>">
                                    <i class="fa fa-sync-alt"></i> <?php echo e(__tr('Auto')); ?>

                                </a>
                            </li>
                            <li
                                class="nav-item <?php echo e(markAsActiveLink('central.subscription.manual_subscription.read.list_view')); ?>">
                                <a class="nav-link"
                                    href="<?php echo e(route('central.subscription.manual_subscription.read.list_view')); ?>">
                                    <i class="fa fa-user-tag"></i> <?php echo e(__tr('Manual/Prepaid')); ?>

                                    <?php if(getPendingSubscriptionCount()): ?><span class="badge badge-danger ml-2"><?php echo e(getPendingSubscriptionCount()); ?></span> <?php endif; ?>
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>

                <li class="nav-item">
                    <a class="nav-link <?php echo e(markAsActiveLink('manage.translations.languages')); ?>"
                        href="<?php echo e(route('manage.translations.languages')); ?>">
                        <i class="fa fa-language"></i> <?php echo e(__tr('Translations')); ?>

                    </a>
                </li>
                <li class="nav-item ">
                    <a class="nav-link <?php echo e(markAsActiveLink('page.list')); ?>" href="<?php echo e(route('page.list')); ?>">
                        <i class="fas fa-file"></i> <?php echo e(__tr('Pages')); ?>

                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="#configurationMenu" data-toggle="collapse" role="button"
                        aria-expanded="true" aria-controls="configurationMenu">
                        <i class="fa fa-cogs text-dark"></i>
                        <span class="nav-link-text"><?php echo e(__tr('Configurations')); ?></span>
                    </a>

                    <div class="collapse show lw-expandable-nav" id="configurationMenu">
                        <ul class="nav nav-sm flex-column">
                            <li class="nav-item">
                                <a class="nav-link <?php echo e(request('pageType') == 'general' ? 'active' : ''); ?>"
                                    href="<?php echo e(route('manage.configuration.read', ['pageType' => 'general'])); ?>">
                                    <i class="fa fa-cog"></i>
                                    <?php echo e(__tr('General')); ?>

                                </a>
                            </li>
                            <li class="nav-item <?php echo e(request('pageType') == 'user' ? 'active' : ''); ?>">
                                <a class="nav-link"
                                    href="<?php echo e(route('manage.configuration.read', ['pageType' => 'user'])); ?>">
                                    <i class="fa fa-user"></i>
                                    <?php echo __tr('User & Vendor'); ?>

                                </a>
                            </li>
                            <li class="nav-item <?php echo e(request('pageType') == 'currency' ? 'active' : ''); ?>">
                                <a class="nav-link"
                                    href="<?php echo e(route('manage.configuration.read', ['pageType' => 'currency'])); ?>">
                                    <i class="fa fa-money-check-alt"></i>
                                    <?php echo e(__tr('Currency')); ?>

                                </a>
                            </li>
                            <li class="nav-item <?php echo e(markAsActiveLink('manage.configuration.payment')); ?>">
                                <a class="nav-link <?= (isset($pageType) and $pageType == 'payment') ? 'active' : '' ?>"
                                    href="<?= route('manage.configuration.read', ['pageType' => 'payment']) ?>">
                                    <i class="fa fa-money-check-alt"></i>
                                    <?php echo e(__tr('Payment Gateways')); ?>

                                </a>
                            </li>
                            <li class="nav-item <?php echo e(markAsActiveLink('manage.configuration.subscription-plans')); ?>">
                                <a class="nav-link" href="<?php echo e(route('manage.configuration.subscription-plans')); ?>">
                                    <i class="fa fa-user"></i>
                                    <?php echo e(__tr('Subscription Plans')); ?>

                                </a>
                            </li>
                            <li class="nav-item <?php echo e(request('pageType') == 'email' ? 'active' : ''); ?>">
                                <a class="nav-link"
                                    href="<?php echo e(route('manage.configuration.read', ['pageType' => 'email'])); ?>">
                                    <i class="fa fa-at"></i>
                                    <?php echo e(__tr('Email')); ?>

                                </a>
                            </li>
                            <li class="nav-item <?php echo e(request('pageType') == 'social-login' ? 'active' : ''); ?>">
                                <a class="nav-link"
                                    href="<?php echo e(route('manage.configuration.read', ['pageType' => 'social-login'])); ?>">
                                    <i class="fas fa-user-plus"></i>
                                    <?php echo e(__tr('Social Login')); ?>

                                </a>
                            </li>
                            <li class="nav-item <?php echo e(request('pageType') == 'other' ? 'active' : ''); ?>">
                                <a class="nav-link"
                                    href="<?php echo e(route('manage.configuration.read', ['pageType' => 'other'])); ?>">
                                    <i class="fa fa-cog"></i>
                                    <?php echo __tr('Setup & Integrations'); ?>

                                </a>
                            </li>
                            <li class="nav-item <?php echo e(request('pageType') == 'misc' ? 'active' : ''); ?>">
                                <a class="nav-link"
                                    href="<?php echo e(route('manage.configuration.read', ['pageType' => 'misc'])); ?>">
                                    <i class=" fa fa-cogs"></i>
                                    <?php echo __tr('Misc'); ?>

                                </a>
                            </li>
                            <li class="nav-item <?php echo e(request('pageType') == 'whatsapp-onboarding' ? 'active' : ''); ?>">
                                <a class="nav-link"
                                    href="<?php echo e(route('manage.configuration.read', ['pageType' => 'whatsapp-onboarding'])); ?>">
                                    <i class="fab fa-facebook text-blue"></i>
                                    <?php echo __tr('WhatsApp Onboarding'); ?>

                                </a>
                            </li>
                            <li class="nav-item ">
                                <a class="nav-link <?php echo e(markAsActiveLink('central.addons.read.list')); ?>"
                                    href="<?php echo e(route('central.addons.read.list')); ?>">
                                    <i class="fas fa-puzzle-piece text-danger"></i> <?php echo e(__tr('Addons')); ?>

                                </a>
                            </li>
                            <?php echo $__env->yieldPushContent('centralSidebarSettingsLinks'); ?>
                            <li
                                class="nav-item <?= Request::fullUrl() == route('manage.configuration.read', ['pageType' => 'licence-information']) ? 'active' : '' ?>">
                                <a class="nav-link"
                                    href="<?= route('manage.configuration.read', ['pageType' => 'licence-information']) ?>">
                                    <i class="fas fa-certificate"></i>
                                    <span>
                                        <?= __tr('License') ?>
                                    </span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>
                <?php endif; ?>
                <?php if(hasVendorAccess() or hasVendorUserAccess()): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo e(markAsActiveLink('vendor.console')); ?>" href="<?php echo e(route('vendor.console')); ?>">
                        <i class="fa fa-tachometer-alt"></i>
                        <?php echo e(__tr('Dashboard')); ?>

                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="#" data-toggle="modal" data-target="#lwScanMeDialog">
                        <i class="fa fa-qrcode text-dark"></i>
                        <?php echo e(__tr('QR Code')); ?>

                    </a>
                </li>
                <?php if(hasVendorAccess('messaging')): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo e(markAsActiveLink('vendor.chat_message.contact.view')); ?>"
                        href="<?php echo e(route('vendor.chat_message.contact.view')); ?>">
                        <span x-cloak x-show="unreadMessagesCount" class="badge badge-success rounded-pill ml--2"
                            x-text="unreadMessagesCount"></span><i class="fa fa-comments mr-2"></i> <span
                            class="ml--2"><?php echo e(__tr('WhatsApp Chat')); ?></span>
                    </a>
                </li>
                <?php endif; ?>
                <?php if(hasVendorAccess('manage_campaigns')): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo e(markAsActiveLink('vendor.campaign.read.list_view')); ?>"
                        href="<?php echo e(route('vendor.campaign.read.list_view')); ?>">
                        <i class="fa fa-bullhorn"></i>
                        <?php echo e(__tr('Campaigns')); ?>

                    </a>
                </li>
                <?php endif; ?>
                <?php if(hasVendorAccess('manage_contacts')): ?>
                <li class="nav-item">
                    <a class="nav-link" href="#vendorContactSubmenuNav" data-toggle="collapse" role="button"
                        aria-expanded="false" aria-controls="vendorContactSubmenuNav">
                        <i class="fa fa-users text-dark"></i>
                        <span class=""><?php echo e(__tr('Contacts')); ?></span>
                    </a>
                    <div class="collapse lw-expandable-nav" id="vendorContactSubmenuNav">
                        <ul class="nav nav-sm flex-column">
                            <li class="nav-item">
                                <a class="nav-link <?php echo e(markAsActiveLink('vendor.contact.read.list_view')); ?>"
                                    href="<?php echo e(route('vendor.contact.read.list_view')); ?>">
                                    <i class="fa fa-list"></i>
                                    <?php echo e(__tr('List')); ?>

                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link <?php echo e(markAsActiveLink('vendor.contact.group.read.list_view')); ?>"
                                    href="<?php echo e(route('vendor.contact.group.read.list_view')); ?>">
                                    <i class="fa fa-list-alt"></i>
                                    <?php echo e(__tr('Groups')); ?>

                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link <?php echo e(markAsActiveLink('vendor.contact.custom_field.read.list_view')); ?>"
                                    href="<?php echo e(route('vendor.contact.custom_field.read.list_view')); ?>">
                                    <i class="fa fa-stream"></i>
                                    <?php echo e(__tr('Custom Fields')); ?>

                                </a>
                            </li>
                        </ul>
                    </div>
                </li>
                <?php endif; ?>
                <?php if(hasVendorAccess('manage_templates')): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo e(markAsActiveLink('vendor.whatsapp_service.templates.read.list_view')); ?>"
                        href="<?php echo e(route('vendor.whatsapp_service.templates.read.list_view')); ?>">
                        <i class="fa fa-layer-group"></i>
                        <?php echo e(__tr('Templates')); ?>

                    </a>
                </li>
                <?php endif; ?>
                <?php if(hasVendorAccess('manage_bot_replies')): ?>
                <li class="nav-item">
                    <a class="nav-link" href="#vendorAutomationSubmenuNav" data-toggle="collapse" role="button"
                        aria-expanded="false" aria-controls="vendorAutomationSubmenuNav">
                        <i class="fa fa-robot text-dark"></i>
                        <span class=""><?php echo e(__tr('Bot Replies')); ?></span>
                    </a>
                    <div class="collapse lw-expandable-nav" id="vendorAutomationSubmenuNav">
                        <ul class="nav nav-sm flex-column">
                            <li class="nav-item">
                                <a class="nav-link <?php echo e(markAsActiveLink('vendor.bot_reply.read.list_view')); ?>"
                                    href="<?php echo e(route('vendor.bot_reply.read.list_view')); ?>">
                                    <i class="fa fa-robot"></i>
                                    <?php echo e(__tr('List')); ?>

                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link <?php echo e(markAsActiveLink('vendor.bot_reply.bot_flow.read.list_view')); ?>"
                                    href="<?php echo e(route('vendor.bot_reply.bot_flow.read.list_view')); ?>">
                                    <i class="fas fa-project-diagram"></i>
                                    <?php echo e(__tr('Flows')); ?>

                                </a>
                            </li>
                        </ul>
                    </div>
                </li>
                <?php endif; ?>
                <?php if(hasVendorAccess('administrative')): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo e(markAsActiveLink('vendor.user.read.list_view')); ?>"
                        href="<?php echo e(route('vendor.user.read.list_view')); ?>">
                        <i class="fa fa-users"></i>
                        <?php echo e(__tr('Team Members')); ?>

                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo e(markAsActiveLink('subscription.read.show')); ?>"
                        href="<?php echo e(route('subscription.read.show')); ?>">
                        <i class="fa fa-id-card"></i>
                        <?php echo e(__tr('My Subscription')); ?>

                    </a>
                </li>
                <li class="nav-item">

                <a class="nav-link <?php echo e(markAsActiveLink('vendor.whatsapp.message.log.view')); ?>"
                                            href="<?php echo e(route('vendor.whatsapp.message.log.view')); ?>">
                                            <i class="fas fa-history"></i>
                                            <?php echo e(__tr('Message Log')); ?>

                                        </a>
                                    </li>
                <li class="nav-item">
                    <a class="nav-link <?php if(isWhatsAppBusinessAccountReady()): ?> collapsed <?php else: ?> text-warning <?php endif; ?>"
                        href="#vendorSettingsNav" data-toggle="collapse" role="button"
                        aria-expanded="<?php echo !isWhatsAppBusinessAccountReady() ? 'true' : 'false'; ?>"
                        aria-controls="vendorSettingsNav">
                        <i class="fa fa-cogs"></i>
                        <span class=""><?php echo e(__tr('Settings')); ?></span>
                    </a>
                    <div class="collapse <?php if(!isWhatsAppBusinessAccountReady()): ?> show <?php endif; ?> lw-expandable-nav"
                        id="vendorSettingsNav">
                        <ul class="nav nav-sm flex-column">
                            <li class="nav-item">
                                <a class="nav-link <?= (isset($pageType) and $pageType == 'general') ? 'active' : '' ?>"
                                    href="<?= route('vendor.settings.read', ['pageType' => 'general']) ?>">
                                    <i class="fa fa-cog"></i>
                                    <?php echo e(__tr('General')); ?>

                                </a>
                            </li>
                            <li class="nav-item">
                                <strong><a
                                        class="nav-link <?= (isset($pageType) and $pageType == 'whatsapp-cloud-api-setup') ? 'active' : '' ?> <?php if(!isWhatsAppBusinessAccountReady()): ?> text-warning <?php endif; ?>"
                                        href="<?= route('vendor.settings.read', ['pageType' => 'whatsapp-cloud-api-setup']) ?>">
                                        <i class="fab fa-whatsapp"></i>
                                        <?php echo e(__tr('WhatsApp Setup')); ?> <?php if(!isWhatsAppBusinessAccountReady()): ?><i
                                            class="fas fa-exclamation-triangle ml-1"></i><?php endif; ?>
                                    </a></strong>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link <?= (isset($pageType) and $pageType == 'ai-chat-bot-setup') ? 'active' : '' ?>"
                                    href="<?= route('vendor.settings.read', ['pageType' => 'ai-chat-bot-setup']) ?>">
                                    <i class="fa fa-brain"></i>
                                    <?php echo __tr('AI Bot & Bot Settings'); ?>

                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link <?= (isset($pageType) and $pageType == 'api-access') ? 'active' : '' ?>"
                                    href="<?= route('vendor.settings.read', ['pageType' => 'api-access']) ?>">
                                    <i class="fa fa-terminal"></i>
                                    <?php echo __tr('API & Webhook'); ?>

                                </a>
                            </li>
                            <?php echo $__env->yieldPushContent('vendorSidebarSettingsLinks'); ?>
                        </ul>
                    </div>
                </li>
                <?php endif; ?>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</nav><?php /**PATH /home/ndmidia/public_html/chatbot.ndmidia.com.br/resources/views/layouts/navbars/sidebar.blade.php ENDPATH**/ ?>