<?php
declare(strict_types=1);
require_once __DIR__ . '/../../core.php';
header('Content-Type: application/json; charset=UTF-8');

if (session_status() === PHP_SESSION_NONE) session_start();
// Se quiser travar para logado no admin, descomente:
// if (empty($_SESSION['admin_id'])) { http_response_code(403); echo '[]'; exit; }

$q  = isset($_GET['q'])  ? trim((string)$_GET['q'])  : '';
$uf = isset($_GET['uf']) ? strtoupper(substr((string)$_GET['uf'], 0, 2)) : '';
$limit = 50;

$where  = "WHERE location_status = 1";
$params = [];

if ($q !== '') {
  $where .= " AND (location_title LIKE :q OR location_slug LIKE :q2)";
  $params[':q']  = "%$q%";
  $params[':q2'] = "%".strtolower($q)."%";
}
if ($uf !== '' && preg_match('/^[A-Z]{2}$/', $uf)) {
  // location_title no seu projeto é "Cidade - UF"
  $where .= " AND location_title LIKE :uf";
  $params[':uf'] = "% - $uf";
}

$sql = "SELECT location_id, location_title 
          FROM locations
          $where
         ORDER BY location_title ASC
         LIMIT $limit";

$stmt = $connect->prepare($sql);
$stmt->execute($params);

$out = [];
while ($r = $stmt->fetch(PDO::FETCH_ASSOC)) {
  $out[] = ['id' => (int)$r['location_id'], 'text' => $r['location_title']];
}
echo json_encode($out, JSON_UNESCAPED_UNICODE);
