
// fix-expire-datetime.js
(function(){
  function pad(n){ return (n<10?'0':'') + n; }
  function normFromLocal(val){
    // Accept "YYYY-MM-DDTHH:MM" or "YYYY-MM-DDTHH:MM:SS"
    if(!val || typeof val !== 'string') return '';
    var t = val.trim();
    // Safari can send without "T" if set manually
    t = t.replace('T',' ');
    // If only has minutes, add :00
    var m = t.match(/^(\d{4}-\d{2}-\d{2})\s+(\d{2}):(\d{2})(?::(\d{2}))?$/);
    if(m){
      var sec = m[4] ? m[4] : '00';
      return m[1] + ' ' + m[2] + ':' + m[3] + ':' + sec;
    }
    // dd/mm/yyyy hh:mm
    var m2 = t.match(/^(\d{2})\/(\d{2})\/(\d{4})\s+(\d{2}):(\d{2})(?::(\d{2}))?$/);
    if(m2){
      var sec2 = m2[6] ? m2[6] : '00';
      return m2[3] + '-' + m2[2] + '-' + m2[1] + ' ' + m2[4] + ':' + m2[5] + ':' + sec2;
    }
    // Only date
    var d = t.match(/^(\d{4}-\d{2}-\d{2})$/);
    if(d){ return d[1] + ' 00:00:00'; }
    return '';
  }

  function ensureHidden(form){
    var hidden = form.querySelector('input[type="hidden"][name="deal_expire"]');
    if(!hidden){
      hidden = document.createElement('input');
      hidden.type = 'hidden';
      hidden.name = 'deal_expire';
      form.appendChild(hidden);
    }
    return hidden;
  }

  function wire(form){
    var dt = form.querySelector('input[name="deal_expire"][type="datetime-local"], input#saved-end-date[type="datetime-local"]');
    if(!dt) return;

    // Avoid name collision: move visible name away, use hidden for final post
    if(dt.getAttribute('name') === 'deal_expire'){
      dt.setAttribute('data-name-original', 'deal_expire');
      dt.setAttribute('name', 'deal_expire_visible');
    }

    // Pre-fill from data-db-value (server should set this if available)
    var dbVal = dt.getAttribute('data-db-value') || '';
    if(dbVal && !dt.value){
      // Expect "YYYY-MM-DD HH:MM:SS"
      var parts = dbVal.trim().replace('T',' ').split(' ');
      if(parts.length >= 2){
        var ymd = parts[0].split('-');
        var hms = parts[1].split(':');
        if(ymd.length===3 && hms.length>=2){
          var v = ymd[0] + '-' + ymd[1] + '-' + ymd[2] + 'T' + hms[0] + ':' + hms[1];
          dt.value = v;
        }
      }
    }

    function sync(){
      var hidden = ensureHidden(form);
      var normalized = normFromLocal(dt.value);
      hidden.value = normalized || '';
    }

    dt.addEventListener('change', sync);
    dt.addEventListener('input', sync);
    form.addEventListener('submit', function(){
      sync();
      // If hidden is empty, ensure we post null (let backend interpret as null)
      var hidden = ensureHidden(form);
      if(!hidden.value){ hidden.value = ''; }
    });

    // First sync
    sync();
  }

  document.addEventListener('DOMContentLoaded', function(){
    Array.prototype.forEach.call(document.querySelectorAll('form'), wire);
  });
})();
