<?php
declare(strict_types=1);

if (!headers_sent()) { @ob_start(); }

/*--------------------*/
// Descrição: ND Cupons 
// Autor: ND Tecnologia 
// Autor URI: https://www.ndmidia.com.br 
/*--------------------*/

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../functions.php';
require_once __DIR__ . '/../twofa_log.php';

if (function_exists('nd_ensure_session')) { nd_ensure_session(); }
elseif (session_status() !== PHP_SESSION_ACTIVE) { @session_start(); }

if (!function_exists('check_session') || !check_session()) { header('Location: ' . SITE_URL); exit; }
if (function_exists('isAdmin') && !isAdmin()) { header('Location: ' . SITE_URL); exit; }

$success = '';
$error   = '';
$target  = (string)($_POST['email'] ?? $_GET['email'] ?? '');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $email = filter_var(strtolower(trim((string)($_POST['email'] ?? ''))), FILTER_SANITIZE_EMAIL);
  if (!$email || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $error = 'E-mail inválido.';
  } else {
    try {
      $pdo = connect();
      $stmt = $pdo->prepare("
        UPDATE users
           SET twofa_enabled = 0,
               twofa_secret  = NULL,
               twofa_recovery_codes = NULL
         WHERE user_email = :email
         LIMIT 1
      ");
      $stmt->execute([':email' => $email]);

      if ($stmt->rowCount() > 0) {
        $twofa_lib = __DIR__ . '/../twofa_lib.php';
        if (is_file($twofa_lib)) {
          require_once $twofa_lib;
          if (function_exists('twofa_cookie_clear')) { try { twofa_cookie_clear($email); } catch (\Throwable $e) {} }
        }
        twofa_log('reset.ok', $email, ['by'=>($_SESSION['user_email'] ?? 'unknown')]);
        $success = '2FA resetado com sucesso para ' . htmlspecialchars($email);
      } else {
        $error = 'Usuário não encontrado ou já sem 2FA.';
      }
    } catch (\Throwable $e) {
      $error = 'Erro ao resetar 2FA: ' . $e->getMessage();
    }
  }
  $target = $email or $target;
}

/* ensure connect */
$connect = connect();
if (!$connect) { header('Location: ./error.php'); exit; }

/* limpa qualquer saída acidental antes do layout */
if (ob_get_length()) { @ob_clean(); }

/* Header padrão do admin (agora já inclui o sidebar) */
require_once __DIR__ . '/header.php';

/* Conteúdo da página */
require_once __DIR__ . '/../views/2fa.reset.view.php';

/* Footer padrão do admin */
require_once __DIR__ . '/footer.php';

if (ob_get_level() > 0) { @ob_end_flush(); }

