<?php 

declare(strict_types=1);
/*--------------------*/
// Descrição: ND Cupons 
// Autor: ND Tecnologia 
// Autor URI: https://www.ndmidia.com.br 
/*--------------------*/

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../functions.php';

$errors = array();
$clicksByDay = array();

if (check_session() == true) {

if (check_permission('view_sellers')) {

    $id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

    if ($id <= 0) {
        header('Location: ./associates.php');
        exit;
    }

    $associate = get_associate_per_id($id);
    if (!$associate) {
        header('Location: ./associates.php');
        exit;
    }

    // Agrupa cliques por dia (últimos 30 dias)
    try {
        $db   = connect();
        $days = 30;
        $days = (int)$days;
        if ($days <= 0) { $days = 30; }

        $sql = "SELECT DATE(click_time) AS day, COUNT(*) AS total
                FROM associate_clicks
                WHERE associate_id = :id
                  AND click_time >= DATE_SUB(NOW(), INTERVAL " . $days . " DAY)
                GROUP BY DATE(click_time)
                ORDER BY day ASC";
        $stmt = $db->prepare($sql);
        $stmt->execute(array(':id' => $id));
        $clicksByDay = $stmt->fetchAll();
    } catch (Exception $e) {
        $clicksByDay = array();
    }

    require_once __DIR__ . '/../views/associate.details.view.php';

} else {

    header('Location: ./denied.php');
}

} else {

    header('Location:' . SITE_URL);
}

