<?php 

declare(strict_types=1);
/*--------------------*/
// Descrição: ND Cupons 
// Autor: ND Tecnologia 
// Autor URI: https://www.ndmidia.com.br 
/*--------------------*/

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../functions.php';

$ranking = array();
$monthLabel = date('m/Y');

if (check_session() == true) {

if (check_permission('view_sellers')) {

    try {
        $db = connect();
        $sql = "SELECT a.*, 
                       COUNT(c.click_id) AS total_clicks_month
                FROM associates a
                LEFT JOIN associate_clicks c
                  ON c.associate_id = a.associate_id
                 AND c.click_time >= DATE_FORMAT(CURDATE(), '%Y-%m-01')
                GROUP BY a.associate_id
                ORDER BY total_clicks_month DESC, a.associate_name ASC";
        $stmt = $db->prepare($sql);
        $stmt->execute();
        $ranking = $stmt->fetchAll();
    } catch (Exception $e) {
        $ranking = array();
    }

    require_once __DIR__ . '/../views/associates.ranking.view.php';

} else {

    header('Location: ./denied.php');
}

} else {

    header('Location:' . SITE_URL);
}

