<?php
declare(strict_types=1);
require_once __DIR__ . '/header.php';

/* ---------------------------
 * Filtros
 * --------------------------- */
$status  = isset($_GET['status']) ? $_GET['status'] : 'all';
$allowed = ['all','open','in_progress','closed'];
if (!in_array($status, $allowed, true)) $status = 'all';

$dealFilter = isset($_GET['deal']) ? (int)$_GET['deal'] : 0;

$where  = [];
$params = [];

if ($status !== 'all') {
  $where[] = 'r.status = :st';
  $params[':st'] = $status;
}
if ($dealFilter > 0) {
  $where[] = 'r.deal_id = :deal_id';
  $params[':deal_id'] = $dealFilter;
}
$whereSql = $where ? ('WHERE '.implode(' AND ', $where)) : '';

/* ---------------------------
 * Query
 * --------------------------- */
$sql = "SELECT 
          r.id, r.deal_id, r.reason, r.details, r.page_url, r.ip, r.ua, r.status, r.created_at,
          r.handled_by, r.handled_at, r.notes,
          d.deal_title
        FROM deal_reports r
        LEFT JOIN deals d ON d.deal_id = r.deal_id
        $whereSql
        ORDER BY r.created_at DESC
        LIMIT 500";
$stmt = $connect->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* ---------------------------
 * Badge de status
 * --------------------------- */
function badge_status(string $s): string {
  switch (trim($s)) {
    case 'open':        return '<span class="badge bg-warning">ABERTO</span>';
    case 'in_progress': return '<span class="badge bg-info text-white">EM ANDAMENTO</span>';
    case 'closed':      return '<span class="badge bg-success">FECHADO</span>';
    default:            return '<span class="badge bg-secondary">'.htmlspecialchars(strtoupper($s)).'</span>';
  }
}
?>
<style>
  /* descola do header fixo como nas outras telas */
  .content{ padding-top:32px !important; }

  /* linha sob o título – mesma leitura da tela de Comentários */
  .page-sep{
    height:1px;
    background:#e9edf2;   /* cor neutra usada no tema */
    margin:8px 0 16px;
  }

  /* colunas e textos longos */
  .nd-ua { max-width: 260px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
  .nd-col-status  { width: 100px; text-align:center; }
  .nd-col-created { width: 150px; }
  .nd-col-actions { width: 260px; }
  @media (max-width:1199.98px){
    .nd-col-actions .row.g-2{ --bs-gutter-y:.35rem; }
  }

  /* Card com cantos arredondados como Comentários */
  .nd-card{
    border-radius: 5px;
    overflow: hidden;
  }

</style>

<div class="content">
  <div class="container-fluid padding-25 sm-padding-10"><!-- layout similar a Comentários -->

    <!-- Cabeçalho idêntico (título + linha) -->
    <div class="card nd-card mt-5">
      <div class="card-body">

        
        <div class="section-title">
          <h5 class="text-truncate">Reportes</h5>
        </div>
        <div class="page-sep"></div>

        <!-- Filtros -->
        <div class="d-flex align-items-center justify-content-between mb-3 flex-wrap gap-2">
          <div class="btn-group btn-group-sm" role="group">
            <a href="?status=all"         class="btn btn-outline-secondary <?php echo $status==='all'?'active':''; ?>">TODOS</a>
            <a href="?status=open"        class="btn btn-outline-secondary <?php echo $status==='open'?'active':''; ?>">ABERTOS</a>
            <a href="?status=in_progress" class="btn btn-outline-secondary <?php echo $status==='in_progress'?'active':''; ?>">EM ANDAMENTO</a>
            <a href="?status=closed"      class="btn btn-outline-secondary <?php echo $status==='closed'?'active':''; ?>">FECHADOS</a>
          </div>

          <form class="d-flex" method="get" action="">
            <input type="hidden" name="status" value="<?php echo htmlspecialchars($status); ?>">
            <input class="form-control form-control-sm me-2" style="width:220px"
                   type="number" name="deal" placeholder="ID da oferta"
                   value="<?php echo $dealFilter ?: ''; ?>">
            <button class="btn btn-primary btn-sm" type="submit">Filtrar</button>
          </form>
        </div>

        <!-- Tabela -->
        <div class="table-responsive">
          <table class="table table-bordered table-hover table-sm align-middle mb-0">
            <thead class="table-light">
              <tr>
                <th>Oferta</th>
                <th>Motivo / Detalhes</th>
                <th>Origem</th>
                <th class="nd-col-status">Status</th>
                <th class="nd-col-created">Criado</th>
                <th class="nd-col-actions">Ações</th>
              </tr>
            </thead>
            <tbody>
            <?php if (!$rows): ?>
              <tr><td colspan="6" class="text-center text-muted">Nenhum reporte encontrado.</td></tr>
            <?php else: foreach ($rows as $r):
              $st = (string)$r['status'];
              $dealUrl = !empty($r['page_url'])
                ? $r['page_url']
                : ('https://'.$_SERVER['HTTP_HOST'].'/?deal_id='.(int)$r['deal_id']);
            ?>
              <tr>
                <td>
                  <div><strong>#<?php echo (int)$r['deal_id']; ?></strong> — <?php echo htmlspecialchars((string)($r['deal_title'] ?? '')); ?></div>
                  <small><a target="_blank" rel="noopener" href="<?php echo htmlspecialchars($dealUrl); ?>">ABRIR PÁGINA</a></small>
                </td>
                <td>
                  <div><strong><?php echo htmlspecialchars((string)$r['reason']); ?></strong></div>
                  <?php if (!empty($r['details'])): ?>
                    <div class="small text-muted" style="white-space:pre-wrap;"><?php echo htmlspecialchars((string)$r['details']); ?></div>
                  <?php endif; ?>
                </td>
                <td class="small">
                  <div>IP: <?php echo htmlspecialchars((string)$r['ip']); ?></div>
                  <div class="text-muted nd-ua">UA: <?php echo htmlspecialchars((string)$r['ua']); ?></div>
                </td>
                <td class="text-center"><?php echo badge_status($st); ?></td>
                <td><?php echo htmlspecialchars((string)$r['created_at']); ?></td>
                <td>
                  <form method="post" action="/admin/controller/deal_reports_update.php" class="row g-2">
                    <input type="hidden" name="id" value="<?php echo (int)$r['id']; ?>">
                    <div class="col-12 col-md-6">
                      <select class="form-select form-select-sm" name="status">
                        <option value="open"        <?php echo $st==='open'?'selected':''; ?>>Aberto</option>
                        <option value="in_progress" <?php echo $st==='in_progress'?'selected':''; ?>>Em andamento</option>
                        <option value="closed"      <?php echo $st==='closed'?'selected':''; ?>>Fechado</option>
                      </select>
                    </div>
                    <div class="col-12">
                      <textarea class="form-control form-control-sm" name="notes" rows="2" placeholder="Notas"><?php echo htmlspecialchars((string)($r['notes'] ?? '')); ?></textarea>
                    </div>
                    <div class="col-12">
                      <button class="btn btn-primary btn-sm" type="submit">Salvar</button>
                    </div>
                  </form>
                </td>
              </tr>
            <?php endforeach; endif; ?>
            </tbody>
          </table>
        </div>

        <!-- Rodapé -->
        <div class="d-flex justify-content-between align-items-center mt-3">
          <div class="text-muted small">
            Mostrando até 500 registros recentes
            <?php if ($status !== 'all'): ?>
              — filtrando por <strong><?php echo htmlspecialchars($status); ?></strong>
            <?php endif; ?>
            <?php if ($dealFilter): ?>
              — oferta <strong>#<?php echo $dealFilter; ?></strong>
            <?php endif; ?>
          </div>
          <ul class="pagination pagination-sm mb-0">
            <li class="page-item disabled"><span class="page-link">Primeiro</span></li>
            <li class="page-item disabled"><span class="page-link">Anterior</span></li>
            <li class="page-item active"><span class="page-link">1</span></li>
            <li class="page-item disabled"><span class="page-link">Próximo</span></li>
            <li class="page-item disabled"><span class="page-link">Último</span></li>
          </ul>
        </div>

      </div><!-- /.card-body -->
    </div><!-- /.card -->

  </div>
</div>

<?php require_once __DIR__ . '/footer.php'; ?>
