<?php
declare(strict_types=1);
require_once __DIR__ . '/header.php'; // garante sessão e $connect

$id     = isset($_POST['id']) ? (int)$_POST['id'] : 0;
$status = $_POST['status'] ?? 'open';
$notes  = isset($_POST['notes']) ? trim((string)$_POST['notes']) : null;

$allowed = ['open','in_progress','closed'];
if ($id <= 0 || !in_array($status, $allowed, true)) {
  header('Location: /admin/controller/deal_reports.php?status=all'); exit;
}

$handledAt = ($status === 'closed') ? date('Y-m-d H:i:s') : null;
$handledBy = isset($_SESSION['user_id']) ? (int)$_SESSION['user_id'] : (isset($_SESSION['admin_id']) ? (int)$_SESSION['admin_id'] : null);

$sql = "UPDATE deal_reports SET status = :st, notes = :notes, handled_at = :hat, handled_by = :hby WHERE id = :id";
$stmt = $connect->prepare($sql);
$stmt->execute([
  ':st' => $status,
  ':notes' => $notes,
  ':hat' => $handledAt,
  ':hby' => $handledBy,
  ':id' => $id,
]);

header('Location: /admin/controller/deal_reports.php?status=' . urlencode($status));
