<?php 


declare(strict_types=1);
/*--------------------*/
// Descrição: ND Cupons 
// Autor: ND Tecnologia 
// Autor URI: https://www.ndmidia.com.br 
/*--------------------*/
    
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../functions.php';

$errors = array();

if(check_session() == true){
    
$id_ad = cleardata(getId());

if(!$id_ad){

	header('Location: home.php');
}

if(check_permission('view_ads') || check_permission('edit_ads')){

	if($_SERVER['REQUEST_METHOD'] == 'POST'){

	

	if(check_permission('edit_ads')){

		$ad_id = cleardata($_POST['ad_id']);
		$ad_title = cleardata($_POST['ad_title']);
		$ad_html = $_POST['ad_html'];
		$ad_position = cleardata($_POST['ad_position']);
		$ad_status = cleardata($_POST['ad_status']);

		$required_fields = ['ad_title', 'ad_html', 'ad_position'];
		foreach($required_fields as $field) {
			if(!isset($_POST[$field]) || (isset($_POST[$field]) && empty($_POST[$field]))) {
					$errors[] = "<b>".$field."</b> " . _ERRORREQUIREDFIELD;  
			}
		}

		if(empty($errors)){

		$statment = connect()->prepare("UPDATE ads SET ad_id = :ad_id, ad_title = :ad_title, ad_html = :ad_html, ad_position = :ad_position, ad_status = :ad_status WHERE ad_id = :ad_id");

		$statment->execute(array(
		':ad_id' => $ad_id,
		':ad_title' => $ad_title,
		':ad_html' => $ad_html,
		':ad_position' => $ad_position,
		':ad_status' => $ad_status
		));

		header('Location: ' . $_SERVER['HTTP_REFERER']);

	}


	}else{

		header('Location: ./denied.php');		

	}

	}

	$ad = get_ad_per_id($id_ad);

	if(!$ad){
		header('Location: ./home.php');
	}

	require_once __DIR__ . '/../views/edit.ad.view.php';

}else{

header('Location: ./denied.php');		

}

}else {

header('Location:'.SITE_URL);

}


