<?php

declare(strict_types=1);
/*--------------------*/
// Descrição: ND Cupons 
// Autor: ND Tecnologia 
// Autor URI: https://www.ndmidia.com.br 
/*--------------------*/

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../functions.php';

$errors = [];
$success = '';

if(check_session() == true){

  if((check_permission('view_addons')) || (check_permission('view_payments'))){

    $id = (int)cleardata(getId());
    if(!$id){
      header('Location: ./addons.php');
      exit;
    }

    $order = get_addon_order_by_id($id);
    if(!$order){
      header('Location: ./addons.php');
      exit;
    }

    // Carrega lojas para dropdown (opcional)
    $stores = [];
    try {
      $st = connect()->prepare('SELECT store_id, store_title FROM stores ORDER BY store_title ASC');
      $st->execute();
      $stores = $st->fetchAll();
    } catch (Throwable $e) {
      $stores = [];
    }

    if($_SERVER['REQUEST_METHOD'] === 'POST'){

      $store_id = isset($_POST['store_id']) ? (int)cleardata($_POST['store_id']) : 0;
      $status   = isset($_POST['status']) ? strtolower(trim((string)cleardata($_POST['status']))) : '';
      $start_date = isset($_POST['start_date']) ? trim((string)cleardata($_POST['start_date'])) : '';
      $end_date   = isset($_POST['end_date']) ? trim((string)cleardata($_POST['end_date'])) : '';
      $notes      = isset($_POST['notes']) ? trim((string)cleardata($_POST['notes'])) : '';

      $allowed = ['pending_payment','pending_activation','active','expired','canceled'];
      if(!in_array($status, $allowed, true)){
        $errors[] = 'Status inválido.';
      }

      // Helpers de datas: aceita "YYYY-MM-DD" ou "YYYY-MM-DD HH:MM"
      $norm = function(string $v): string {
        $v = trim($v);
        if($v === '') return '';
        if(preg_match('/^\d{4}-\d{2}-\d{2}$/', $v)) return $v . ' 00:00:00';
        if(preg_match('/^\d{4}-\d{2}-\d{2}\s+\d{2}:\d{2}$/', $v)) return $v . ':00';
        if(preg_match('/^\d{4}-\d{2}-\d{2}\s+\d{2}:\d{2}:\d{2}$/', $v)) return $v;
        return $v; // deixa como veio
      };

      $start_date = $norm($start_date);
      $end_date   = $norm($end_date);

      // Ativação rápida: se ficou "active" e não tem datas, calcula.
      if($status === 'active'){
        if($start_date === ''){
          $start_date = getDateByTimeZone();
        }

        if($end_date === ''){
          $billing = strtolower((string)($order['billing_type'] ?? ''));
          $months  = (int)($order['months'] ?? 0);
          $meta = [];
          try {
            $meta = json_decode((string)($order['meta_json'] ?? ''), true);
            if(!is_array($meta)) $meta = [];
          } catch (Throwable $e) { $meta = []; }

          $durationDays = (int)($meta['duration_days'] ?? 0);

          try {
            $tz = new DateTimeZone(get_timezone());
            $dt = new DateTime($start_date, $tz);
            if($billing === 'days' && $durationDays > 0){
              $dt->modify('+' . $durationDays . ' days');
              $end_date = $dt->format('Y-m-d H:i:s');
            } elseif($months > 0) {
              $dt->modify('+' . $months . ' months');
              $end_date = $dt->format('Y-m-d H:i:s');
            }
          } catch (Throwable $e) {
            // ignora
          }
        }
      }

      // Bloqueio de exclusividade por segmento/bairro (segurança comercial)
      if ($order['addon_code'] === 'exclusive' && $status === 'active') {
        $seg = strtolower(trim((string)($meta['segment'] ?? '')));
        $bai = strtolower(trim((string)($meta['neighborhood'] ?? '')));

        if ($seg === '' || $bai === '') {
          $errors[] = 'Para ativar a exclusividade, preencha Segmento e Bairro.';
        } else {
          $newStartTs = strtotime($start_date ?: getDateByTimeZone());
          $newEndTs = $end_date ? strtotime($end_date) : strtotime('2099-12-31 23:59:59');

          $stEx = connect()->prepare("SELECT id, start_date, end_date, meta_json
            FROM nd_addon_orders
            WHERE addon_code = 'exclusive'
              AND status = 'active'
              AND id <> :id
          ");
          $stEx->execute([':id' => $id]);
          $rows = $stEx->fetchAll(PDO::FETCH_ASSOC);

          foreach ($rows as $row) {
            $m2 = [];
            if (!empty($row['meta_json'])) {
              $d2 = json_decode($row['meta_json'], true);
              if (is_array($d2)) { $m2 = $d2; }
            }
            $seg2 = strtolower(trim((string)($m2['segment'] ?? '')));
            $bai2 = strtolower(trim((string)($m2['neighborhood'] ?? '')));

            if ($seg2 === $seg && $bai2 === $bai) {
              $oStartTs = strtotime($row['start_date'] ?: '1970-01-01 00:00:00');
              $oEndTs = $row['end_date'] ? strtotime($row['end_date']) : strtotime('2099-12-31 23:59:59');

              if ($newStartTs <= $oEndTs && $oStartTs <= $newEndTs) {
                $errors[] = 'Já existe uma exclusividade ativa para esse segmento/bairro (pedido #' . $row['id'] . ').';
                break;
              }
            }
          }
        }
      }

      if(empty($errors)){
        $ok = update_addon_order([
          'id' => $id,
          'store_id' => ($store_id > 0 ? $store_id : ''),
          'status' => $status,
          'start_date' => $start_date,
          'end_date' => $end_date,
          'notes' => $notes,
          'meta_json' => json_encode($meta, JSON_UNESCAPED_UNICODE),
        ]);

        if($ok){
          $success = 'Add-on atualizado.';
          $order = get_addon_order_by_id($id);
        } else {
          $errors[] = 'Não foi possível salvar. Tente novamente.';
        }
      }
    }

    require_once __DIR__ . '/../views/edit_addon.view.php';

  } else {
    header('Location: ./denied.php');
    exit;
  }

} else {
  header('Location:' . SITE_URL);
  exit;
}
