<?php 

declare(strict_types=1);
/*--------------------*/
// Descrição: ND Cupons 
// Autor: ND Tecnologia 
// Autor URI: https://www.ndmidia.com.br 
/*--------------------*/

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../functions.php';

$errors = array();

if(check_session() == true){

if(check_permission('edit_users')){

    $id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

    if ($id <= 0) {
        header('Location: ./associates.php');
        exit;
    }

    $associate = get_associate_per_id($id);
    if (!$associate) {
        header('Location: ./associates.php');
        exit;
    }

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $name   = cleardata($_POST['associate_name']  ?? '');
        $email  = cleardata($_POST['associate_email'] ?? '');
        $phone  = cleardata($_POST['associate_phone'] ?? '');
        $city   = cleardata($_POST['associate_city']  ?? '');
        $state  = cleardata($_POST['associate_state'] ?? '');
        $group  = cleardata($_POST['associate_group'] ?? '');
        $code   = cleardata($_POST['associate_code']  ?? '');
        $status = isset($_POST['associate_status']) ? (int)$_POST['associate_status'] : 1;

        if ($name === '') {
            $errors[] = 'Informe o nome do associado.';
        }

        // Se não havia código e continua em branco, gera um automaticamente
        if ($code === '' && (empty($associate['associate_code']) || $associate['associate_code'] === '')) {
            try {
                $db = connect();
                $unique = false;
                $attempts = 0;

                while (!$unique && $attempts < 10) {
                    $attempts++;
                    $generated = 'A' . strtoupper(substr(sha1(uniqid((string)mt_rand(), true)), 0, 7));
                    $check = $db->prepare("SELECT 1 FROM associates WHERE associate_code = :code LIMIT 1");
                    $check->execute(array(':code' => $generated));
                    if (!$check->fetch()) {
                        $unique = true;
                        $code = $generated;
                    }
                }

                if ($code === '') {
                    $code = 'A' . strtoupper(substr(sha1((string)time(), true), 0, 7));
                }
            } catch (Exception $e) {
                $code = 'A' . strtoupper(substr(sha1((string)time(), true), 0, 7));
            }
        }

        if (empty($errors)) {
            try {
                $db = connect();

                // Verifica se a coluna associate_group existe
                $hasGroup = false;
                try {
                    $checkCol = $db->query("SHOW COLUMNS FROM associates LIKE 'associate_group'");
                    if ($checkCol && $checkCol->rowCount() > 0) {
                        $hasGroup = true;
                    }
                } catch (Exception $e) {
                    $hasGroup = false;
                }

                if ($hasGroup) {
                    $stmt = $db->prepare(
                        "UPDATE associates SET
                            associate_name   = :name,
                            associate_email  = :email,
                            associate_phone  = :phone,
                            associate_city   = :city,
                            associate_state  = :state,
                            associate_group  = :grupo,
                            associate_code   = :code,
                            associate_status = :status,
                            associate_updated = NOW()
                         WHERE associate_id = :id
                         LIMIT 1"
                    );
                    $stmt->execute(array(
                        ':name'   => $name,
                        ':email'  => $email,
                        ':phone'  => $phone,
                        ':city'   => $city,
                        ':state'  => $state,
                        ':grupo'  => $group,
                        ':code'   => $code,
                        ':status' => $status,
                        ':id'     => $id,
                    ));
                } else {
                    $stmt = $db->prepare(
                        "UPDATE associates SET
                            associate_name   = :name,
                            associate_email  = :email,
                            associate_phone  = :phone,
                            associate_city   = :city,
                            associate_state  = :state,
                            associate_code   = :code,
                            associate_status = :status,
                            associate_updated = NOW()
                         WHERE associate_id = :id
                         LIMIT 1"
                    );
                    $stmt->execute(array(
                        ':name'   => $name,
                        ':email'  => $email,
                        ':phone'  => $phone,
                        ':city'   => $city,
                        ':state'  => $state,
                        ':code'   => $code,
                        ':status' => $status,
                        ':id'     => $id,
                    ));
                }

                header('Location: ./associates.php');
                exit;

            } catch (Exception $e) {
                $errors[] = 'Erro ao atualizar o associado.';
            }
        } else {
            // mantém os dados digitados na view
            $associate['associate_name']   = $name;
            $associate['associate_email']  = $email;
            $associate['associate_phone']  = $phone;
            $associate['associate_city']   = $city;
            $associate['associate_state']  = $state;
            $associate['associate_group']  = $group;
            $associate['associate_code']   = $code;
            $associate['associate_status'] = $status;
        }
    }

    require_once __DIR__ . '/../views/edit.associate.view.php';

}else{

    header('Location: ./denied.php');
}

}else{

    header('Location:'.SITE_URL);
}

