<?php


declare(strict_types=1);
/*--------------------*/
// Descrição: ND Cupons
// Autor: ND Tecnologia
// Autor URI: https://www.ndmidia.com.br
/*--------------------*/

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../functions.php';

$errors = array();

if(check_session() == true){

$id_store = cleardata(getId());

if(!$id_store){
	header('Location: home.php');
}

if(check_permission('view_stores') || check_permission('edit_stores')){

		if($_SERVER['REQUEST_METHOD'] == 'POST'){



	if(check_permission('edit_stores')){

	$store_id = cleardata($_POST['store_id']);
	$store_title = cleardata($_POST['store_title']);
	$store_seotitle = cleardata($_POST['store_seotitle']);
	$store_description = cleardata($_POST['store_description']);
	$store_seodescription = cleardata($_POST['store_seodescription']);
	$store_featured = cleardata($_POST['store_featured']);
	$store_status = cleardata($_POST['store_status']);
	$store_slug = cleardata($_POST['store_slug']);
    $store_url = cleardata($_POST['store_url']);
    $store_address = isset($_POST['store_address']) ? cleardata($_POST['store_address']) : '';

    // Horário estruturado via inputs type="time"
    $store_hours_open  = isset($_POST['store_hours_open']) ? cleardata($_POST['store_hours_open']) : '';
    $store_hours_close = isset($_POST['store_hours_close']) ? cleardata($_POST['store_hours_close']) : '';

    if ($store_hours_open !== '' && $store_hours_close !== '') {
        $store_hours = sprintf('Das %s às %s', $store_hours_open, $store_hours_close);
    } else {
        // fallback para texto livre (compatibilidade)
        $store_hours = isset($_POST['store_hours']) ? cleardata($_POST['store_hours']) : '';
    }

    $store_whatsapp = isset($_POST['store_whatsapp']) ? cleardata($_POST['store_whatsapp']) : '';


	$required_fields = ['store_title'];
	foreach($required_fields as $field) {
		if(!isset($_POST[$field]) || (isset($_POST[$field]) && empty($_POST[$field]))) {
				$errors[] = "<b>".$field."</b> " . _ERRORREQUIREDFIELD;
		}
	}

	$image = [
		'store_image' => isset($_FILES['store_image']['name']) && !empty($_FILES['store_image']['name'])
	];

	$uploadedImages = [];

	foreach(['store_image'] as $image_key) {

		if($image[$image_key]) {

			$file_name = $_FILES[$image_key]['name'];
			$file_size = $_FILES[$image_key]['size'];
			$file_extension = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
			$file_temp = $_FILES[$image_key]['tmp_name'];

			if (!in_array($file_extension, allowedFileExt())) {

				$errors[] = "<b>".$image_key."</b> " . _ERRORALLOWEDFILEFORMATS;

			} else if ($file_size > allowedFileSize()) {

				$errors[] = "<b>".$image_key."</b> " . _ERRORFILETOOLARGE;

			}

			if(empty($errors)){

				$image_new_name = md5(time() . rand()) . '.' . $file_extension;
				move_uploaded_file($file_temp, $target_dir . $image_new_name);
				$uploadedImages += [$image_key => $image_new_name];

			}

		}

	}

	if(empty($errors)){

		if (empty($store_slug)) {
			$slug = $_POST['store_slug_save'];
		}else{

			$converted_slug = convertSlug($_POST['store_slug']);
			$exists = get_store_slug($converted_slug);

			if ($exists > 0){

				$new_number = $exists + 1;
				$slug = $converted_slug."-".$new_number;

			}else{

				$slug = $converted_slug;
			}
		}

	$statment = connect()->prepare("UPDATE stores 
                SET store_id = :store_id,
                    store_title = :store_title,
                    store_slug = :store_slug,
                    store_description = :store_description,
                    store_seotitle = :store_seotitle,
                    store_seodescription = :store_seodescription,
                    store_featured = :store_featured,
                    store_status = :store_status,
                    store_image = :store_image,
                    store_url = :store_url,
                    store_address = :store_address,
                    store_hours = :store_hours,
                    store_whatsapp = :store_whatsapp
                WHERE store_id = :store_id");

	$statment->execute(array(
		':store_id' => $store_id,
		':store_title' => $store_title,
		':store_slug' => $slug,
		':store_description' => $store_description,
		':store_seotitle' => $store_seotitle,
		':store_seodescription' => $store_seodescription,
		':store_featured' => $store_featured,
		':store_status' => $store_status,
		':store_image' => (isset($uploadedImages['store_image']) ? $uploadedImages['store_image'] : $_POST['store_image_save']),
        ':store_url' => $store_url,
        ':store_address' => $store_address,
        ':store_hours' => $store_hours,
        ':store_whatsapp' => $store_whatsapp
	));

	// Atualiza vínculo com anunciante (multi-loja opcional)
	if (isset($_POST['store_user_id'])) {
		$store_user_id = $_POST['store_user_id'] !== '' ? (int)$_POST['store_user_id'] : null;
		try {
			if ($store_user_id !== null) {
				$st_link = connect()->prepare("UPDATE stores SET store_user_id = :uid WHERE store_id = :store_id");
				$st_link->execute(array(
					':uid' => $store_user_id,
					':store_id' => $store_id
				));
			} else {
				$st_link = connect()->prepare("UPDATE stores SET store_user_id = NULL WHERE store_id = :store_id");
				$st_link->execute(array(
					':store_id' => $store_id
				));
			}
		} catch (PDOException $e) {
			// coluna store_user_id pode não existir; ignora erro
		}
	}


	header('Location: ' . $_SERVER['HTTP_REFERER']);

}


}else{

	header('Location: ./denied.php');

}

}

	$store = get_store_per_id($id_store);

	// Lista de anunciantes para vincular loja (multi-loja)
	$sellers_list = array();
	try {
		$sql_sellers = "SELECT s.seller_user, s.seller_title, u.user_email
			FROM sellers s
			LEFT JOIN users u ON u.user_id = s.seller_user
			ORDER BY s.seller_title ASC";
		$st_sellers = connect()->prepare($sql_sellers);
		$st_sellers->execute();
		$sellers_list = $st_sellers->fetchAll(PDO::FETCH_ASSOC);
	} catch (PDOException $e) {
		$sellers_list = array();
	}


	if(!$store){
		header('Location: ./home.php');
	}

	require_once __DIR__ . '/../views/edit.store.view.php';

}else{

header('Location: ./denied.php');

}

}else{

header('Location:'.SITE_URL);

}

