<?php
declare(strict_types=1);

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../functions.php';
require_once __DIR__ . '/../../functions.php';

// Se o painel tiver controle de sessão/permissão, tente usar
if (function_exists('check_session') && check_session() !== true) {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['error' => 'no-session']);
    exit;
}

if (function_exists('check_permission') && !check_permission('view_statistics')) {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['error' => 'no-permission']);
    exit;
}

$connect = connect();

$sql = "SELECT track_id, INET6_NTOA(track_ip) AS ip_txt
        FROM tracking
        WHERE (track_country_code IS NULL OR track_country_code = ''
           OR track_country_name IS NULL OR track_country_name = ''
           OR track_city IS NULL OR track_city = '' )
          AND track_ip IS NOT NULL
        ORDER BY track_id DESC
        LIMIT 500";

$st = $connect->prepare($sql);
$st->execute();
$rows = $st->fetchAll(PDO::FETCH_ASSOC);

$updated = 0;
foreach ($rows as $r) {
    $ip = $r['ip_txt'] ?? '';
    if (!$ip) continue;
    try {
        $loc = getInfoByIp($ip);
        $country = $loc['country'] ?? ($loc['countryName'] ?? '');
        $cc      = $loc['country_code'] ?? ($loc['countryCode'] ?? '');
        $city    = $loc['city'] ?? '';
        if ($cc || $country || $city) {
            $up = $connect->prepare("UPDATE tracking SET
                    track_country_name = :name,
                    track_country_code = :code,
                    track_city = :city
                WHERE track_id = :id");
            $up->execute([
                ':name' => $country,
                ':code' => $cc,
                ':city' => $city,
                ':id'   => $r['track_id']
            ]);
            $updated++;
        }
    } catch (Throwable $e) {
        // ignora falhas individuais
    }
}

header('Content-Type: application/json; charset=utf-8');
echo json_encode(['processed' => count($rows), 'updated' => $updated], JSON_UNESCAPED_UNICODE);
