<?php
declare(strict_types=1);
require '../core.php';

/**
 * GET /controllers/get-reviews.php?item=ID
 * Retorna JSON com:
 *  - stats: avg, count
 *  - items: [{user,name,date,rating,comment}]
 * Considera apenas status=1 (aprovado) se a coluna existir; caso não exista, cai para todos.
 */
header('Content-Type: application/json; charset=utf-8');

$item = (int)($_GET['item'] ?? 0);
if ($item <= 0) { echo json_encode(['error'=>'missing item']); exit; }

try{
  $connect->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

  // Detecta se há coluna status
  $hasStatus = false;
  try {
    $q = $connect->query("SHOW COLUMNS FROM reviews LIKE 'status'");
    $hasStatus = (bool)$q->fetch(PDO::FETCH_ASSOC);
  } catch (Throwable $e) {}

  $where = "WHERE r.item = :item";
  if ($hasStatus) $where .= " AND r.status = 1";

  $sql = "SELECT r.id, r.rating, r.comment, r.created,
                 COALESCE(u.user_name, 'Cliente') AS name
          FROM reviews r
          LEFT JOIN users u ON u.user_id = r.user
          $where
          ORDER BY r.created DESC
          LIMIT 200";
  $stmt = $connect->prepare($sql);
  $stmt->execute([':item' => $item]);
  $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

  $count = count($rows);
  $avg = 0.0;
  if ($count) {
    $sum = 0;
    foreach($rows as $r){ $sum += (int)$r['rating']; }
    $avg = round($sum / $count, 1);
  }

  echo json_encode([
    'stats' => ['avg'=>$avg, 'count'=>$count],
    'items' => array_map(function($r){
      return [
        'name' => $r['name'],
        'date' => date('d-m-Y', strtotime($r['created'] ?? 'now')),
        'rating' => (int)$r['rating'],
        'comment' => (string)$r['comment'],
      ];
    }, $rows)
  ], JSON_UNESCAPED_UNICODE);
}catch(Throwable $e){
  echo json_encode(['error'=>'db error']);
}
