<?php
declare(strict_types=1);

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../functions.php';
require_once __DIR__ . '/../lang/languages.php'; // ← loader de idioma (PT-BR padrão)

$connect = connect();
if (!$connect) { header('Location: ./error.php'); exit; }

if (check_session() === true) {
    require_once __DIR__ . '/../views/header.view.php';
    // Sidebar padrão do admin (centralizado aqui para todas as páginas)
    require_once __DIR__ . '/sidebar.php';

    // ⬇️ inclui o menu lateral, qualquer que seja o nome do arquivo no tema
    $__menu_candidates = [
        __DIR__ . '/../views/navigation.view.php',
        __DIR__ . '/../views/navigation.php',
        __DIR__ . '/../views/sidebar.view.php',
        __DIR__ . '/../views/sidebar.php',
        __DIR__ . '/../views/left-sidebar.view.php',
        __DIR__ . '/../views/left-sidebar.php',
        __DIR__ . '/../views/menu.view.php',
        __DIR__ . '/../views/menu.php',
    ];
    foreach ($__menu_candidates as $__m) {
        if (is_file($__m)) { require_once $__m; break; }
    }

} else {
    header('Location:' . SITE_URL);
    exit;
}
