<?php
declare(strict_types=1);

// (opcional) evita "headers already sent" se alguma view fizer echo antes do redirect
ob_start();

/*--------------------*/
// Descrição: ND Cupons 
// Autor: ND Tecnologia 
// Autor URI: https://www.ndmidia.com.br 
/*--------------------*/

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../functions.php';
require_once __DIR__ . '/../../init_lang.php'; // i18n (se existir)

// Bloqueia acesso sem sessão
if (!function_exists('check_session') || !check_session()) {
    // Se você tiver login do admin em outra rota, ajuste aqui:
    // header('Location: ' . SITE_URL . '/admin/login.php');
    header('Location: ' . SITE_URL);
    exit;
}

// (opcional) Bloqueia não-admins
if (function_exists('isAdmin') && !isAdmin()) {
    header('Location: ' . SITE_URL);
    exit;
}

// Carrega os números do dashboard
$users_total      = function_exists('users_total')        ? users_total()          : 0;
$deals_total      = function_exists('deals_total')        ? deals_total()          : 0;
$sellers_total    = function_exists('sellers_total')      ? sellers_total()        : 0;
$payments_total   = function_exists('payments_total')     ? payments_total()       : 0;
$latestdeals      = function_exists('get_all_deals')      ? get_all_deals(5)       : [];
$topvisitdeals    = function_exists('get_top_deals')      ? get_top_deals(5)       : [];
$latestusers      = function_exists('get_all_users')      ? get_all_users(5)       : [];
$latestpayments   = function_exists('get_latest_payments')? get_latest_payments(5) : [];

// Render: header -> conteúdo -> footer
require_once __DIR__ . '/../views/header.view.php';

// Se sua view tiver outro nome (ex.: dashboard.view.php), troque abaixo:
require_once __DIR__ . '/../views/home.view.php';

require_once __DIR__ . '/../views/footer.view.php';

// (opcional, se usou ob_start)
ob_end_flush();
