<?php
declare(strict_types=1);

// (opcional, ajuda a evitar "Headers already sent")
ob_start();


/*--------------------*/
// Descrição: ND Cupons 
// Autor: ND Tecnologia 
// Autor URI: https://www.ndmidia.com.br 
/*--------------------*/

if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }

include_once __DIR__ . '/../../classes/csrf.php';
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../functions.php';
require_once __DIR__ . '/../twofa_log.php';

$csrf   = new CSRF();
$errors = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

  $captchaUser = isset($_POST['captcha']) ? cleardata($_POST['captcha']) : '';

  if (isset($_SESSION['CAPTCHA_CODE']) && $_SESSION['CAPTCHA_CODE'] == $captchaUser) {

    if ($csrf->validate('login-token')) {

      $user_email    = filter_var(strtolower($_POST['user_email'] ?? ''), FILTER_SANITIZE_EMAIL);
      $user_password = cleardata($_POST['user_password'] ?? '');
      $password      = hash('sha512', $user_password);

      try {
        $pdo = connect();
      } catch (PDOException $e) {
        // Corrigido: mensagem sem ponto extra
        echo "Error: " . $e->getMessage();
        exit;
      }

      // Busca admin ativo e já traz colunas do usuário (inclui 2FA)
      $statement = $pdo->prepare("
        SELECT u.*, r.*
          FROM users u
          JOIN roles r ON u.user_role = r.role_id
         WHERE r.role_admin   = 1
           AND u.user_email   = :user_email
           AND u.user_password= :user_password
           AND u.user_status  = 1
         LIMIT 1
      ");

      $statement->execute([
        ':user_email'    => $user_email,
        ':user_password' => $password
      ]);

      $u = $statement->fetch(PDO::FETCH_ASSOC);

      if ($u !== false){

        // Sempre gravar dados básicos na sessão
        $_SESSION['user_email'] = $user_email;
        $_SESSION['user_name']  = $u['user_name'] ?? '';

        // ===== 2FA (fail-safe) =====
        $need2fa = false;

        // TWOFA: só tenta pular se DE FATO estiver habilitado e houver segredo
        $u_twofa_enabled = (int)($u['twofa_enabled'] ?? 0);
        $u_twofa_secret  = (string)($u['twofa_secret']  ?? '');

        if ($u_twofa_enabled === 1 && $u_twofa_secret !== '') {
          // por padrão, exigir 2FA
          $need2fa = true;

          // tentar validação de "dispositivo confiável" **apenas** se a lib existir
          $twofa_lib = __DIR__ . '/../twofa_lib.php';
          if (is_file($twofa_lib)) {
            require_once $twofa_lib;

            // tenta descriptografar (se a lib definir), senão usa como está
            $secret_for_cookie = $u_twofa_secret;
            if (function_exists('twofa_decrypt')) {
              try {
                $dec = twofa_decrypt($u_twofa_secret);
                if (!empty($dec)) $secret_for_cookie = $dec;
              } catch (Throwable $e) { /* ignora */ }
            }

            // se houver helper de cookie confiável, testa
            if (function_exists('twofa_cookie_check')) {
              try {
                if (twofa_cookie_check($user_email, $secret_for_cookie)) {
                  $need2fa = false; // dispositivo confiável: pode pular a verificação
                }
              } catch (Throwable $e) { /* ignora */ }
            }
          }
        }

        if ($need2fa) {
          twofa_log('login.require2fa', $user_email, ['ip'=>$_SERVER['REMOTE_ADDR'] ?? '']);

          // NÃO marca como logado ainda; guarda estado pendente de 2FA
          unset($_SESSION['signedin']);
          $_SESSION['2fa_email_pending'] = $user_email;
          header('Location: ./2fa-verify.php');
          exit;
        } else {
          // Sem 2FA habilitada ou dispositivo confiável válido -> login direto
          $_SESSION['signedin'] = true;
          twofa_log('login.ok.no2fa', $user_email, ['ip'=>$_SERVER['REMOTE_ADDR'] ?? '']);
          header('Location: ./home.php');
          exit;
        }
        // ===== /2FA =====

      } else {
        twofa_log('login.fail.password', $user_email ?? '', ['ip'=>$_SERVER['REMOTE_ADDR'] ?? '']);
        $errors .= _LOGINACCESSDENIED;
      }

    } else {
      twofa_log('login.fail.csrf', $user_email ?? '', ['ip'=>$_SERVER['REMOTE_ADDR'] ?? '']);
      $errors .= _LOGININVALIDTOKEN;
    }

  } else {
    twofa_log('login.fail.captcha', $user_email ?? '', ['ip'=>$_SERVER['REMOTE_ADDR'] ?? '']);
    $errors .= _LOGININVALIDCAPTCHA;
  }
}

// Renderiza views do admin
require_once __DIR__ . '/../views/header.view.php';
require_once __DIR__ . '/../views/login.view.php';
require_once __DIR__ . '/../views/footer.view.php';

// (opcional, se tiver usado ob_start() no topo)
ob_end_flush();
