<?php 

declare(strict_types=1);
/*--------------------*/
// Descrição: ND Cupons 
// Autor: ND Tecnologia 
// Autor URI: https://www.ndmidia.com.br 
/*--------------------*/

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../functions.php';

$errors = array();

if(check_session() == true){

if(check_permission('create_users')){

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $name   = cleardata($_POST['associate_name']  ?? '');
        $email  = cleardata($_POST['associate_email'] ?? '');
        $phone  = cleardata($_POST['associate_phone'] ?? '');
        $city   = cleardata($_POST['associate_city']  ?? '');
        $state  = cleardata($_POST['associate_state'] ?? '');
        $group  = cleardata($_POST['associate_group'] ?? '');
        $code   = cleardata($_POST['associate_code']  ?? '');
        $status = isset($_POST['associate_status']) ? (int)$_POST['associate_status'] : 1;

        if ($name === '') {
            $errors[] = 'Informe o nome do associado.';
        }

        // Se o código vier em branco, gera um automaticamente
        if ($code === '') {
            try {
                $db = connect();
                $unique = false;
                $attempts = 0;

                while (!$unique && $attempts < 10) {
                    $attempts++;
                    $generated = 'A' . strtoupper(substr(sha1(uniqid((string)mt_rand(), true)), 0, 7));
                    $check = $db->prepare("SELECT 1 FROM associates WHERE associate_code = :code LIMIT 1");
                    $check->execute(array(':code' => $generated));
                    if (!$check->fetch()) {
                        $unique = true;
                        $code = $generated;
                    }
                }

                if ($code === '') {
                    // fallback simples se algo der errado
                    $code = 'A' . strtoupper(substr(sha1((string)time(), true), 0, 7));
                }
            } catch (Exception $e) {
                // Se der erro na geração/consulta, cria um código básico mesmo assim
                $code = 'A' . strtoupper(substr(sha1((string)time(), true), 0, 7));
            }
        }

        if (empty($errors)) {
            try {
                $db = connect();

                // Verifica se a coluna associate_group existe na tabela
                $hasGroup = false;
                try {
                    $checkCol = $db->query("SHOW COLUMNS FROM associates LIKE 'associate_group'");
                    if ($checkCol && $checkCol->rowCount() > 0) {
                        $hasGroup = true;
                    }
                } catch (Exception $e) {
                    $hasGroup = false;
                }

                if ($hasGroup) {
                    $stmt = $db->prepare(
                        "INSERT INTO associates
                        (associate_name, associate_email, associate_phone, associate_city,
                         associate_state, associate_group, associate_code, associate_status, associate_created)
                         VALUES
                        (:name, :email, :phone, :city, :state, :grupo, :code, :status, NOW())"
                    );
                    $stmt->execute(array(
                        ':name'   => $name,
                        ':email'  => $email,
                        ':phone'  => $phone,
                        ':city'   => $city,
                        ':state'  => $state,
                        ':grupo'  => $group,
                        ':code'   => $code,
                        ':status' => $status,
                    ));
                } else {
                    // fallback sem a coluna group (não quebra se o banco ainda não foi atualizado)
                    $stmt = $db->prepare(
                        "INSERT INTO associates
                        (associate_name, associate_email, associate_phone, associate_city,
                         associate_state, associate_code, associate_status, associate_created)
                         VALUES
                        (:name, :email, :phone, :city, :state, :code, :status, NOW())"
                    );
                    $stmt->execute(array(
                        ':name'   => $name,
                        ':email'  => $email,
                        ':phone'  => $phone,
                        ':city'   => $city,
                        ':state'  => $state,
                        ':code'   => $code,
                        ':status' => $status,
                    ));
                }

                header('Location: ./associates.php');
                exit;

            } catch (Exception $e) {
                $errors[] = 'Erro ao salvar o associado. Verifique se a tabela "associates" existe.';
            }
        }
    }

    require_once __DIR__ . '/../views/new.associate.view.php';

}else{

    header('Location: ./denied.php');
}

}else{

    header('Location:'.SITE_URL);
}

