<?php 


declare(strict_types=1);
/*--------------------*/
// Descrição: ND Cupons 
// Autor: ND Tecnologia 
// Autor URI: https://www.ndmidia.com.br 
/*--------------------*/

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../functions.php';

$errors = array();

if(check_session() == true){   

if(check_permission('create_deals')){

	if($_SERVER['REQUEST_METHOD'] == 'POST'){

	$deal_title = cleardata($_POST['deal_title']);
	$deal_seotitle = cleardata($_POST['deal_seotitle']);
	$deal_description = $_POST['deal_description'];
	$deal_seodescription = cleardata($_POST['deal_seodescription']);
	$deal_tagline = cleardata($_POST['deal_tagline']);
	$deal_category = cleardata($_POST['deal_category']);
	$deal_subcategory = cleardata($_POST['deal_subcategory']);
	$deal_store = cleardata($_POST['deal_store']);
	$deal_location = cleardata($_POST['deal_location']);
	$deal_status = cleardata($_POST['deal_status']);
	$deal_author = cleardata($_POST['deal_author']);
	$deal_price = cleardata($_POST['deal_price']);
	$deal_oldprice = cleardata($_POST['deal_oldprice']);
	$deal_link = cleardata($_POST['deal_link']);
	$deal_video = cleardata($_POST['deal_video']);
	$deal_gif = cleardata($_POST['deal_gif']);
	$deal_start = cleardata($_POST['deal_start']);
	$deal_expire = cleardata($_POST['deal_expire']);
	$deal_exclusive = cleardata($_POST['deal_exclusive']);
	$deal_featured = cleardata($_POST['deal_featured']);
	/* ND: enforce plan quotas (creation) */
	try {
		$authorId = (int)$deal_author;
		if (!nd_user_can_create_deal(connect(), $authorId)) {
			$errors[] = "Limite de ofertas ativas atingido para o plano do usuário.";
		}
		list($deal_featured, $deal_exclusive) = nd_clamp_feature_flags_by_plan(connect(), $authorId, $deal_featured, $deal_exclusive, null);
	} catch (Throwable $e) {
		// fail-open
	}


	$required_fields = ['deal_title', 'deal_category', 'deal_link', 'deal_price'];
	foreach($required_fields as $field) {
		if(!isset($_POST[$field]) || (isset($_POST[$field]) && empty($_POST[$field]))) {
				$errors[] = "<b>".$field."</b> " . _ERRORREQUIREDFIELD;  
		}
	}
	
	$image = [
		'deal_image' => isset($_FILES['deal_image']['name']) && !empty($_FILES['deal_image']['name'])
	];

	$uploadedImages = [];

	foreach(['deal_image'] as $image_key) {

		if($image[$image_key]) {

			$file_name = $_FILES[$image_key]['name'];
			$file_size = $_FILES[$image_key]['size'];
			$file_extension = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
			$file_temp = $_FILES[$image_key]['tmp_name'];

			if (!in_array($file_extension, allowedFileExt())) {

				$errors[] = "<b>".$image_key."</b> " . _ERRORALLOWEDFILEFORMATS;  
	
			} else if ($file_size > allowedFileSize()) {
	
				$errors[] = "<b>".$image_key."</b> " . _ERRORFILETOOLARGE;  
	
			}

			if(empty($errors)){

				$image_new_name = md5(time() . rand()) . '.' . $file_extension;
				move_uploaded_file($file_temp, $target_dir . $image_new_name);
				$uploadedImages += [$image_key => $image_new_name];

			}

		}

	}

	if(empty($errors)){

		$converted_slug = convertSlug(cleardata($_POST['deal_title']));
		$exists = get_deal_slug($converted_slug);
	
		if ($exists > 0){
			$new_number = $exists + 1;
			$slug = $converted_slug."-".$new_number;
	
		}else{
	
			$slug = $converted_slug;
		}

		$statment = connect()->prepare("INSERT INTO deals (deal_id, deal_title, deal_seotitle, deal_slug, deal_description, deal_seodescription, deal_tagline, deal_category, deal_subcategory, deal_store, deal_location, deal_status, deal_author, deal_price, deal_oldprice, deal_link, deal_video, deal_gif, deal_start, deal_expire, deal_exclusive, deal_featured, deal_created, deal_image) VALUES (null, :deal_title, :deal_seotitle, :deal_slug, :deal_description, :deal_seodescription, :deal_tagline, :deal_category, :deal_subcategory, :deal_store, :deal_location, :deal_status, :deal_author, :deal_price, :deal_oldprice, :deal_link, :deal_video, :deal_gif, :deal_start, :deal_expire, :deal_exclusive, :deal_featured, CURRENT_TIMESTAMP, :deal_image)");

		$statment->execute(array(
			':deal_title' => $deal_title,
			':deal_seotitle' => $deal_seotitle,
			':deal_slug' => $slug,
			':deal_description' => $deal_description,
			':deal_seodescription' => $deal_seodescription,
			':deal_tagline' => $deal_tagline,
			':deal_category' => $deal_category,
			':deal_subcategory' => $deal_subcategory,
			':deal_store' => $deal_store,
			':deal_location' => $deal_location,
			':deal_status' => $deal_status,
			':deal_author' => $deal_author,
			':deal_price' => $deal_price,
			':deal_oldprice' => $deal_oldprice,
			':deal_link' => $deal_link,
			':deal_video' => $deal_video,
			':deal_gif' => $deal_gif,
			':deal_start' => $deal_start,
			':deal_expire' => $deal_expire,
			':deal_exclusive' => $deal_exclusive,
			':deal_featured' => $deal_featured,
			':deal_image' => $uploadedImages['deal_image']
		));
	
		$idItem = connect()->lastInsertId();
		unset($temp);
	
		$statment->bindParam(':item', $idItem);
	
		$FileUploader = new FileUploader('files', array(
				'uploadDir' => $target_dir,
				'title' => 'auto',
				'limit' => 8,
				'fileMaxSize' => (allowedFileSize()/1024/1024),
				'extensions' => allowedFileExt(),
				'replace' => true
				));
			
			$data = $FileUploader->upload();
			
			if($data['isSuccess'] && count($data['files']) > 0) {
	
				$uploadedFiles = $data['files'];
	
				$statment = connect()->prepare("INSERT INTO deals_gallery (id,item,picture,created) VALUES (null, :item, :picture, CURRENT_TIMESTAMP)");
	
				foreach ($uploadedFiles as $key => $value){
					$statment->execute(array(
						':item' => $idItem,
						':picture' => $value['name']
					));
				}
			}

		header('Location: ./deals.php');

	}

}

$stores = get_all_stores();
$locations = get_all_locations();
$categories = get_all_categories();
$siteSettings = get_settings();

$userInfo = get_user_information();

require_once __DIR__ . '/../views/new.deal.view.php';

}else{

header('Location: ./denied.php');

}

}else{

header('Location:'.SITE_URL);

}


?>
<!-- ND: início bloco Select2 -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<style>
  .select2-container { width:100% !important; }
  .nd-uf-filter { width:140px; margin:4px 0; }
</style>
<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
(function(){
  function ensureSelect2(){
    var $sel = $('select[name="deal_location"]');
    if (!$sel.length) return;

    // garante um id
    if (!$sel.attr('id')) $sel.attr('id','deal_location');

    // captura valor atual (se já tem cidade salva)
    var selectedId = $sel.val();

    // adiciona um filtro de UF antes do select
    if (!$('#nd-uf-filter').length) {
      var ufs = 'AC,AL,AP,AM,BA,CE,DF,ES,GO,MA,MT,MS,MG,PA,PB,PR,PE,PI,RJ,RN,RS,RO,RR,SC,SP,SE,TO'.split(',');
      var $uf = $('<select id="nd-uf-filter" class="nd-uf-filter"><option value="">UF</option></select>');
      ufs.forEach(function(uf){ $uf.append('<option value="'+uf+'">'+uf+'</option>'); });
      $sel.before($uf);
    }

    // esvazia a lista gigante
    $sel.find('option').remove();

    // liga o Select2 com AJAX
    $sel.select2({
      width: '100%',
      placeholder: 'Selecione a cidade...',
      allowClear: true,
      minimumInputLength: 2,
      ajax: {
        url: '/admin/api/locations_search.php',
        dataType: 'json',
        delay: 250,
        data: function (params) {
          return { q: params.term || '', uf: ($('#nd-uf-filter').val() || '') };
        },
        processResults: function (data) {
          return { results: data };
        },
        cache: true
      }
    });

    // quando mudar a UF, limpa o valor e recarrega a busca
    $('#nd-uf-filter').on('change', function(){
      $sel.val(null).trigger('change');
    });

    // pré-carrega o valor já salvo na oferta (se existir)
    if (selectedId) {
      $.getJSON('/admin/api/location_get.php', {id: selectedId}, function(item){
        if (item && item.id) {
          var opt = new Option(item.text, item.id, true, true);
          $sel.append(opt).trigger('change');
        }
      });
    }
  }

  // roda ao carregar a página
  if (document.readyState !== 'loading') { ensureSelect2(); }
  else document.addEventListener('DOMContentLoaded', ensureSelect2);
})();
</script>
<!-- ND: fim bloco Select2 -->
