<?php


declare(strict_types=1);
/*--------------------*/
// Descrição: ND Cupons
// Autor: ND Tecnologia
// Autor URI: https://www.ndmidia.com.br
/*--------------------*/

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../functions.php';

if(check_session() == true){

if(check_permission('create_stores')){

	if($_SERVER['REQUEST_METHOD'] == 'POST'){



	$store_title = cleardata($_POST['store_title']);
	$store_seotitle = cleardata($_POST['store_seotitle'] ?? '');
	$store_description = cleardata($_POST['store_description'] ?? '');
	$store_seodescription = cleardata($_POST['store_seodescription'] ?? '');
	$store_featured = cleardata($_POST['store_featured'] ?? 0);
	$store_url = isset($_POST['store_url']) ? cleardata($_POST['store_url']) : '';
	$store_user_id = (isset($_POST['store_user_id']) && $_POST['store_user_id'] !== '') ? (int)$_POST['store_user_id'] : null;

	$required_fields = ['store_title'];
	foreach($required_fields as $field) {
		if(!isset($_POST[$field]) || (isset($_POST[$field]) && empty($_POST[$field]))) {
				$errors[] = "<b>".$field."</b> " . _ERRORREQUIREDFIELD;
		}
	}

	$image = [
		'store_image' => isset($_FILES['store_image']['name']) && !empty($_FILES['store_image']['name'])
	];

	$uploadedImages = [];

	foreach(['store_image'] as $image_key) {

		if($image[$image_key]) {

			$file_name = $_FILES[$image_key]['name'];
			$file_size = $_FILES[$image_key]['size'];
			$file_extension = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
			$file_temp = $_FILES[$image_key]['tmp_name'];

			if (!in_array($file_extension, allowedFileExt())) {

				$errors[] = "<b>".$image_key."</b> " . _ERRORALLOWEDFILEFORMATS;

			} else if ($file_size > allowedFileSize()) {

				$errors[] = "<b>".$image_key."</b> " . _ERRORFILETOOLARGE;

			}

			if(empty($errors)){

				$image_new_name = md5(time() . rand()) . '.' . $file_extension;
				move_uploaded_file($file_temp, $target_dir . $image_new_name);
				$uploadedImages += [$image_key => $image_new_name];

			}

		}

	}

	if(empty($errors)){

	$converted_slug = convertSlug(cleardata($_POST['store_title']));
	$exists = get_store_slug($converted_slug);

	if ($exists > 0){

		$new_number = $exists + 1;
		$slug = $converted_slug."-".$new_number;

	}else{

		$slug = $converted_slug;
	}

    // Novo cadastro de loja
    $store_user_id = isset($_POST['store_user_id']) && $_POST['store_user_id'] !== '' ? (int)$_POST['store_user_id'] : null;
    try {
        if ($store_user_id !== null) {
            $statment = connect()->prepare("INSERT INTO stores (store_title, store_seotitle, store_description, store_seodescription, store_slug, store_image, store_url, store_featured, store_status, store_user_id) VALUES (:title, :seotitle, :description, :seodescription, :slug, :image, :url, :featured, :status, :uid)");
        } else {
            $statment = connect()->prepare("INSERT INTO stores (store_title, store_seotitle, store_description, store_seodescription, store_slug, store_image, store_url, store_featured, store_status) VALUES (:title, :seotitle, :description, :seodescription, :slug, :image, :url, :featured, :status)");
        }
        $params = array(
            ':title' => $title,
            ':seotitle' => $seotitle,
            ':description' => $description,
            ':seodescription' => $seodescription,
            ':slug' => $slug,
            ':image' => $fileName,
            ':url' => $url,
            ':featured' => $featured,
            ':status' => $status
        );
        if ($store_user_id !== null) {
            $params[':uid'] = $store_user_id;
        }
        $statment->execute($params);
    } catch (PDOException $e) {
        // se a coluna store_user_id não existir ainda, faz insert sem a coluna
        $statment = connect()->prepare("INSERT INTO stores (store_title, store_seotitle, store_description, store_seodescription, store_slug, store_image, store_url, store_featured, store_status) VALUES (:title, :seotitle, :description, :seodescription, :slug, :image, :url, :featured, :status)");
        $statment->execute(array(
            ':title' => $title,
            ':seotitle' => $seotitle,
            ':description' => $description,
            ':seodescription' => $seodescription,
            ':slug' => $slug,
            ':image' => $fileName,
            ':url' => $url,
            ':featured' => $featured,
            ':status' => $status
        ));
    }


	// Atualiza vínculo com anunciante (multi-loja opcional)
	if ($store_user_id !== null) {
		try {
			$pdo = connect();
			$store_id = $pdo->lastInsertId();
			$st_link = $pdo->prepare("UPDATE stores SET store_user_id = :uid WHERE store_id = :store_id");
			$st_link->execute(array(
				':uid' => $store_user_id,
				':store_id' => $store_id
			));
		} catch (PDOException $e) {
			// coluna store_user_id pode não existir ainda; ignora erro
		}
	}

	header('Location: ./stores.php');

}

}


// Lista de anunciantes para vincular loja (multi-loja)
$sellers_list = array();
try {
    $sql_sellers = "SELECT s.seller_user, s.seller_title, u.user_email
                    FROM sellers s
                    LEFT JOIN users u ON u.user_id = s.seller_user
                    ORDER BY s.seller_title ASC";
    $st_sellers = connect()->prepare($sql_sellers);
    $st_sellers->execute();
    $sellers_list = $st_sellers->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $sellers_list = array();
}

require_once __DIR__ . '/../views/new.store.view.php';

}else{

header('Location: ./denied.php');
}

}else {

header('Location:'.SITE_URL);

}
