<?php

declare(strict_types=1);
/*--------------------*/
// Descrição: ND Cupons - atualizar status de pagamento manual (banktransfer)
/*--------------------*/

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../functions.php';

if (check_session() == true) {

    // Ajuste aqui a permissão se o sistema usar algo mais específico
    if (!check_permission('view_payments')) {
        header('Location: ./denied.php');
        exit;
    }

    $id_payment = cleardata(getId());

    $status = isset($_GET['status']) ? (int) $_GET['status'] : 0;

    // Permitimos apenas os status definidos: 0,1,2,3,4
    $allowed = [0,1,2,3,4];
    if (!in_array($status, $allowed, true)) {
        $status = 0;
    }

    if (!empty($id_payment)) {
        $statement = connect()->prepare(
            "UPDATE payments SET payment_status = :status WHERE payment_id = :id"
        );
        $statement->execute([
            ':status' => $status,
            ':id'     => $id_payment
        ]);

        // Opção A: ao confirmar pagamento manual, move add-ons vinculados para "pendente de ativação"
        // (assim a operação ativa quando quiser, com data final e observações)
        if ($status === 1) {
            try {
                $upd = connect()->prepare(
                    "UPDATE nd_addon_orders
                     SET status = 'pending_activation',
                         updated_at = NOW(),
                         notes = CASE
                           WHEN notes IS NULL OR notes = '' THEN 'Pagamento confirmado (admin)'
                           ELSE CONCAT(notes, '\nPagamento confirmado (admin)')
                         END
                     WHERE payment_id = :pid AND status = 'pending_payment'"
                );
                $upd->execute([':pid' => $id_payment]);
            } catch (Throwable $e) {
                // fail-open
            }
        }
    }

    header('Location: ./payments.php');
    exit;

} else {

    header('Location:'.SITE_URL);
    exit;

}
