<?php

declare(strict_types=1);


// === Session helper (guarded) ===
if (!function_exists('nd_ensure_session')) {
    function nd_ensure_session(): void {
        if (session_status() !== PHP_SESSION_ACTIVE) {
            if (function_exists('session_set_cookie_params')) {
                @session_set_cookie_params([
                    'httponly' => True,
                    'samesite' => 'Lax',
                ]);
            }
            @session_start();
        }
    }
}
// === /Session helper ===

// === ND Helpers Loader (guarded) ===
$___h_candidates = [
    __DIR__ . '/app/Support/helpers.php',
    // if this bootstrap sits in a subfolder:
    dirname(__DIR__) . '/app/Support/helpers.php',
    // fallback if only 'Support/helpers.php' got uploaded to project root
    __DIR__ . '/Support/helpers.php',
];
$___loaded = false;
foreach ($___h_candidates as $___h) {
    if (is_file($___h)) {
        require_once $___h;
        $___loaded = true;
        break;
    }
}
if (!$___loaded) {
    trigger_error('ND Helpers not found (tried: ' . implode(', ', $___h_candidates) . ')', E_USER_WARNING);
}
// === /ND Helpers Loader ===

?>
<?php
// === i18n FORCE GUARD (v5) ===
if (!isset($langStrings) || !is_array($langStrings)) { $langStrings = array(); }
if (!isset($langStrings[0]) || !is_array($langStrings[0])) { $langStrings[0] = array(); }
// ==================================

// bootstrap i18n
if (!defined('APP_BOOTSTRAP_DONE')) { require_once __DIR__ . '/../core.php'; define('APP_BOOTSTRAP_DONE', true);} require_once __DIR__ . '/../i18n-shim.php'; if (isset($translation) && !isset($langStrings)) { $langStrings = $translation; }


/*--------------------*/
// Descrição: ND Cupons 
// Autor: ND Tecnologia 
// Autor URI: https://www.ndmidia.com.br 
/*--------------------*/

if(!isset($_SESSION)) { 

}

error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/../classes/vendor/autoload.php';
require_once __DIR__ . '/../classes/slugify.php';
require_once __DIR__ . '/../classes/fileuploader.php';

// === __ADMIN_PTBR_OVERRIDE__ (não remover) ===
// Força PT-BR no Admin quando APP_LANG=pt-br (ou Accept-Language contém pt-br)
try {
    $forced = getenv('APP_LANG');
    if (!$forced && defined('APP_LANG')) { $forced = APP_LANG; }
    $al = isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? strtolower($_SERVER['HTTP_ACCEPT_LANGUAGE']) : '';
    $forced = strtolower((string)$forced);

    $wantPt = ($forced === 'pt-b' || $forced === 'ptb' || $forced === 'pt_b' || $forced === 'pt' || strpos($al, 'pt-b') !== false);
    if ($wantPt) {
        $pt = __DIR__ . '/../translation-pt-br.php';
        if (file_exists($pt)) {
            // include (não require_once) para sobrescrever $translation carregado antes
            include $pt;
            if (isset($translation) && is_array($translation)) {
                $langStrings = $translation;
                $langStrings[0] = $translation;
                // Algumas views do admin usam $siteTranslation
                $siteTranslation = $translation;
            }
        }
    }
} catch (\Throwable $e) {
    // silencioso
}
// === /__ADMIN_PTBR_OVERRIDE__ ===


/* i18n loader (admin, patched) */
if (!isset($translation) || !is_array($translation)) {
    $forced = getenv('APP_LANG');
    if (!$forced && defined('APP_LANG')) { $forced = APP_LANG; }
    $langFile = __DIR__ . '/../translation.php';
    $forced = strtolower((string)$forced);

    if (in_array($forced, ['pt-b','pt_b','ptb','pt'])) {
        $try = __DIR__ . '/../translation-pt-br.php';
        if (file_exists($try)) { $langFile = $try; }
    } else {
        $al = isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? strtolower($_SERVER['HTTP_ACCEPT_LANGUAGE']) : '';
        if (strpos($al, 'pt-b') !== false && file_exists(__DIR__ . '/../translation-pt-br.php')) {
            $langFile = __DIR__ . '/../translation-pt-br.php';
        }
    }
    require_once $langFile;
}
if (!isset($langStrings) || !is_array($langStrings)) {
    if (isset($translation) && is_array($translation)) { $langStrings = $translation; $langStrings[0] = $translation; }
    else { $langStrings = array(); $langStrings[0] = array(); }
}
/* end i18n loader (admin, patched) */
require_once __DIR__ . '/lang/languages.php';
require_once __DIR__ . '/permissions.php';
require_once __DIR__ . '/languages.php';
require_once __DIR__ . '/countries.php';
require_once __DIR__ . '/timezones.php';
require_once __DIR__ . '/currencies.php';
require_once __DIR__ . '/email_fields.php';

$target_dir = "../../images/";
$siteTranslation = isset($translation) && is_array($translation) ? $translation : (isset($langStrings[0]) ? $langStrings[0] : (is_array($langStrings) ? $langStrings : array()));

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;
use voku\helper\AntiXSS;

if (!function_exists('connect')) {
function connect(){

global $database;

try{
    // Compat: aceita tanto 'user' quanto a chave antiga 'use'
    $dbUser = $database['user'] ?? ($database['use'] ?? null);
    $dbPass = $database['pass'] ?? '';
    $dbHost = $database['host'] ?? 'localhost';
    $dbName = $database['db']   ?? '';

    $dsn = 'mysql:host=' . $dbHost . ';dbname=' . $dbName;

    $connect = new PDO($dsn, $dbUser, $dbPass, array(
        PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES  \'UTF8\''));
    // Força modo de erro por exceção (melhor para depurar)
    $connect->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    return $connect;

}catch (PDOException $e){
    return false;
}
}
}

if (!function_exists('check_permission')) {
function check_permission(string $permission): bool
{
    if ($permission === '') {
        return false;
    }

    if (!isset($_SESSION['user_email'])) {
        return false;
    }

    $email = filter_var(strtolower($_SESSION['user_email']), FILTER_SANITIZE_EMAIL);

    $pdo = connect();
    if (!$pdo) {
        return false;
    }

    // Busca papel + permissões do usuário logado
    $sql = "SELECT r.role_admin, r.role_permissions
              FROM users u
              JOIN roles r ON u.user_role = r.role_id
             WHERE u.user_email = :email AND u.user_status = 1
             LIMIT 1";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':email' => $email]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$row) {
        return false;
    }

    // Admin sempre pode tudo
    if ((int)$row['role_admin'] === 1) {
        return true;
    }

    // Decodifica lista e trata corrompido/nulo
    $perms = json_decode($row['role_permissions'], true);
    if (!is_array($perms)) {
        $perms = [];
    }

    // Curiga 1: wildcard
    if (in_array('*', $perms, true)) {
        return true;
    }

    // Curiga 2: comparação exata e case-sensitive
    return in_array($permission, $perms, true);
}}



if (!function_exists('countFormat')) {
function countFormat($num) {

    if($num>1000) {

      $x = round($num);
      $x_number_format = number_format($x);
      $x_array = explode(',', $x_number_format);
      $x_parts = array('k', 'm', 'b', 't');
      $x_count_parts = count($x_array) - 1;
      $x_display = $x;
      $x_display = $x_array[0] . ((int) $x_array[1][0] !== 0 ? '.' . $x_array[1][0] : '');
      $x_display .= $x_parts[$x_count_parts - 1];

      return $x_display;
  }

return $num;
}
}


if (!function_exists('check_session')) {
function check_session(){

    if (isset($_SESSION['user_email'])) {

        $userEmail = filter_var(strtolower($_SESSION['user_email']), FILTER_SANITIZE_EMAIL);

        $sentence = connect()->prepare("SELECT users.user_email, users.user_role, roles.role_admin FROM users LEFT JOIN roles ON users.user_role = roles.role_id AND users.user_email = :email"); 
        $sentence->execute(array(
            ":email" => $userEmail
        ));

        $row = $sentence->fetch();

        if($row['role_admin'] == 1){
            return true;
        }else{
            return false;
        }

    }else{
        return false;
    }
}
}


if (!function_exists('isAdmin')) {
function isAdmin(){

    if (isset($_SESSION['user_email'])) {

        $emailSession = filter_var(strtolower($_SESSION['user_email']), FILTER_SANITIZE_EMAIL);

        $sentence = connect()->prepare("SELECT * FROM users WHERE user_email = :user_email AND user_status = 1 AND user_role = 1 LIMIT 1"); 
        $sentence->execute(array(
            ":user_email" => $emailSession
        ));
        $row = $sentence->fetch();

        if ($row) {
            return true;
        }else{
            return false;
        }
    }else{
        return false;
    }

}
}


if (!function_exists('echoOutput')) {
function echoOutput($data){
    $data = htmlspecialchars($data, ENT_COMPAT, 'UTF-8');

    if (empty($data)) {
        return "-";
    }else{
        return $data;
    }
}
}


if (!function_exists('cleardata')) {
function cleardata($data){
    $antiXss = new AntiXSS();
    $data = $antiXss->xss_clean($data);
    return $data;
}
}


if (!function_exists('getId')) {
function getId(){
    
    return isset($_GET['id']) && is_numeric($_GET['id']) ? $_GET['id'] : NULL;
}
}


if (!function_exists('get_user_information')) {
function get_user_information(){

    if (isset($_SESSION['user_email'])) {

    $emailSession = filter_var(strtolower($_SESSION['user_email']), FILTER_SANITIZE_EMAIL);

    $sentence = connect()->prepare("SELECT * FROM users WHERE user_email = :user_email LIMIT 1");
    $sentence->execute(array(
        ":user_email" => $emailSession
    ));
    $row = $sentence->fetch();
    return ($row) ? $row : false;

    }else{
        return false;
    }

}
}


if (!function_exists('currentPage')) {
function currentPage(){

    return isset($_GET['p']) ? (int)$_GET['p'] : 1;
}
}


if (!function_exists('goToPage')) {
function goToPage($parameter, $value) { 
    $params = array(); 
    $output = "?"; 
    $firstRun = true; 
    foreach($_GET as $key=>$val) { 
        if($key != $parameter) { 
            if(!$firstRun) { 
                $output .= "&"; 
            } else { 
                $firstRun = false; 
            } 
            $output .= $key."=".urlencode($val); 
        } 
    } 

    if(!$firstRun) 
        $output .= "&"; 
    $output .= $parameter."=".urlencode($value); 
    return htmlentities($output); 
}
}
 

// MENUS ---------------------------------------

if (!function_exists('get_all_menus')) {
function get_all_menus(){

    $sentence = connect()->prepare("SELECT * FROM menus"); 
    $sentence->execute();
    return $sentence->fetchAll();
}
}


if (!function_exists('get_menu_per_id')) {
function get_menu_per_id($id_menu){
    $sentence = connect()->prepare("SELECT * FROM menus WHERE menu_id = :menu_id LIMIT 1");
    $sentence->execute(array(
        ":menu_id" => $id_menu
    ));
    $row = $sentence->fetch();
    return ($row) ? $row : false;

}
}


if (!function_exists('get_navigations')) {
function get_navigations(){

    $sentence = connect()->prepare("SELECT * FROM navigations ORDER BY navigation_order ASC"); 
    $sentence->execute();
    return $sentence->fetchAll();
}
}


if (!function_exists('get_navigations_by_menu')) {
function get_navigations_by_menu($id_menu){

    $sentence = connect()->prepare("SELECT navigations.navigation_id, COALESCE(pages.page_slug, navigations.navigation_url) AS navigation_url, COALESCE(pages.page_title, navigations.navigation_label) AS navigation_label, navigations.navigation_type FROM navigations LEFT JOIN pages ON page_id = navigations.navigation_page WHERE navigation_menu = :menu_id ORDER BY navigation_order ASC"); 
    $sentence->execute(array(
        ":menu_id" => $id_menu
    ));
    return $sentence->fetchAll();
}
}


// PAGES ---------------------------------------

if (!function_exists('is_default_page')) {
function is_default_page($page_id){

    $sentence = connect()->prepare("SELECT * FROM settings WHERE
    '".$page_id."' IN (SELECT st_defaultsearchpage FROM settings)
    OR '".$page_id."' IN (SELECT st_defaultprivacypage FROM settings)
    OR '".$page_id."' IN (SELECT st_defaulttermspage FROM settings)
    OR '".$page_id."' IN (SELECT st_defaultcategoriespage FROM settings)
    OR '".$page_id."' IN (SELECT st_defaultstorespage FROM settings)
    OR '".$page_id."' IN (SELECT st_defaultlocationspage FROM settings)
    OR '".$page_id."' IN (SELECT st_defaultpricingpage FROM settings)
    "); 
    $sentence->execute();
    $sentence->fetchAll();
    $exist = $sentence->rowCount();

    if ($exist > 0) {
        return true;
    }else{
        return false;
    }
}
}


if (!function_exists('get_default_page')) {
function get_default_page($page){

    if($page){
        $sentence = connect()->prepare("SELECT * FROM pages WHERE page_status = 1 AND page_id = :page_id LIMIT 1");
        $sentence->execute(array(
            ":page_id" => $page
        ));
        $row = $sentence->fetch();
        return $row;

    }else{
        return NULL;
    }
}
}


if (!function_exists('get_default_page_slug')) {
function get_default_page_slug($page){

        $sentence = connect()->prepare("SELECT * FROM pages WHERE page_status = 1 AND page_id = :page_id LIMIT 1");
        $sentence->execute(array(
            ":page_id" => $page
        ));
        $row = $sentence->fetch();
        return $row['page_slug'];

}
}


if (!function_exists('getSocialMedia')) {
function getSocialMedia(){
    
    $sentence = connect()->prepare("SELECT st_facebook,st_twitter,st_youtube,st_instagram,st_linkedin,st_whatsapp FROM settings"); 
    $sentence->execute();
    return $sentence->fetchAll();
}
}


if (!function_exists('get_page_slug')) {
function get_page_slug($slug){

    $sentence = connect()->prepare("SELECT COUNT(*) AS total FROM pages WHERE page_slug LIKE '$slug%'");
    $sentence->execute();
    $row = $sentence->fetch(PDO::FETCH_ASSOC);
    return $row['total'];
}
}


if (!function_exists('get_pages_by_template')) {
function get_pages_by_template($type){
    $sentence = connect()->prepare("SELECT * FROM pages WHERE page_template = '".$type."'"); 
    $sentence->execute();
    $row = $sentence->fetchAll(PDO::FETCH_ASSOC);
    return $row;
}
}


if (!function_exists('totalPages')) {
function totalPages($items_per_page){

    $total_items = connect()->prepare("SELECT COUNT(*) AS total FROM pages");
    $total_items->execute();
    $total_items = $total_items->fetch()['total'];

    $number_pages = ceil($total_items / $items_per_page);
    return $number_pages;
}
}


if (!function_exists('get_all_pages')) {
function get_all_pages(){

    $sql = "SELECT * FROM pages"; 
    $sentence = connect()->prepare($sql); 
    $sentence->execute();
    return $sentence->fetchAll(PDO::FETCH_ASSOC);
}
}


if (!function_exists('get_page_per_id')) {
function get_page_per_id($id_page){
    $sentence = connect()->query("SELECT pages.* FROM pages WHERE page_id = $id_page LIMIT 1");
    $sentence = $sentence->fetch();
    return ($sentence) ? $sentence : false;
}
}


if (!function_exists('pages_total')) {
function pages_total(){

    $total_numbers = connect()->prepare("SELECT * FROM pages");
    $total_numbers->execute(array());
    $total_numbers->fetchAll();
    $total = $total_numbers->rowCount();
    return $total;
}
}


// SUBCATEGORIES  ---------------------------------------

if (!function_exists('subcategories_total')) {
function subcategories_total(){

    $total_numbers = connect()->prepare("SELECT * FROM subcategories");
    $total_numbers->execute(array());
    $total_numbers->fetchAll();
    $total = $total_numbers->rowCount();
    return $total;
}
}


if (!function_exists('get_all_subcategories')) {
function get_all_subcategories(){

    $sql = "SELECT subcategories.*, categories.category_title AS category_title FROM subcategories LEFT JOIN categories ON categories.category_id = subcategories.subcategory_parent ORDER BY subcategory_id DESC";
    $sentence = connect()->prepare($sql); 
    $sentence->execute();
    return $sentence->fetchAll();
}
}


if (!function_exists('get_subcategory_slug')) {
function get_subcategory_slug($slug){

    $sentence = connect()->prepare("SELECT COUNT(*) AS total FROM subcategories WHERE subcategory_slug LIKE '$slug%'");
    $sentence->execute();
    $row = $sentence->fetch(PDO::FETCH_ASSOC);
    return $row['total'];
}
}


if (!function_exists('get_subcategories_per_parent')) {
function get_subcategories_per_parent($category){
    $sentence = connect()->query("SELECT * FROM subcategories WHERE subcategory_parent = $category");
    $sentence = $sentence->fetchAll();
    return ($sentence) ? $sentence : false;
}
}


if (!function_exists('get_subcategory_per_id')) {
function get_subcategory_per_id($id_subcategory){
    $sentence = connect()->query("SELECT * FROM subcategories WHERE subcategory_id = $id_subcategory LIMIT 1");
    $sentence = $sentence->fetch();
    return ($sentence) ? $sentence : false;
}
}


// ROLES  ---------------------------------------

if (!function_exists('get_role_per_id')) {
function get_role_per_id($id_role){
    $sentence = connect()->query("SELECT * FROM roles WHERE role_id = $id_role LIMIT 1");
    $sentence = $sentence->fetch();
    return ($sentence) ? $sentence : false;
}
}


if (!function_exists('get_all_roles')) {
function get_all_roles(){

    $sql = "SELECT * FROM roles ORDER BY role_id DESC";
    $sentence = connect()->prepare($sql); 
    $sentence->execute();
    return $sentence->fetchAll();
}
}


// CATEGORIES  ---------------------------------------

if (!function_exists('categories_total')) {
function categories_total(){

    $total_numbers = connect()->prepare("SELECT * FROM categories");
    $total_numbers->execute(array());
    $total_numbers->fetchAll();
    $total = $total_numbers->rowCount();
    return $total;
}
}


if (!function_exists('get_all_categories')) {
function get_all_categories(){

    $sql = "SELECT * FROM categories ORDER BY category_id DESC";
    $sentence = connect()->prepare($sql); 
    $sentence->execute();
    return $sentence->fetchAll();
}
}


if (!function_exists('get_category_slug')) {
function get_category_slug($slug){

    $sentence = connect()->prepare("SELECT COUNT(*) AS total FROM categories WHERE category_slug LIKE '$slug%'");
    $sentence->execute();
    $row = $sentence->fetch(PDO::FETCH_ASSOC);
    return $row['total'];
}
}


if (!function_exists('get_category_per_id')) {
function get_category_per_id($id_category){
    $sentence = connect()->query("SELECT * FROM categories WHERE category_id = $id_category LIMIT 1");
    $sentence = $sentence->fetch();
    return ($sentence) ? $sentence : false;
}
}


// SLIDERS  ---------------------------------------

if (!function_exists('sliders_total')) {
function sliders_total(){

    $total_numbers = connect()->prepare("SELECT * FROM sliders");
    $total_numbers->execute(array());
    $total_numbers->fetchAll();
    $total = $total_numbers->rowCount();
    return $total;
}
}


if (!function_exists('get_all_sliders')) {
function get_all_sliders(){

    $sql = "SELECT * FROM sliders ORDER BY slider_id DESC";
    $sentence = connect()->prepare($sql); 
    $sentence->execute();
    return $sentence->fetchAll();
    }
}


    
    if (!function_exists('get_slider_per_id')) {
function get_slider_per_id($id_slider){
    $sentence = connect()->query("SELECT * FROM sliders WHERE slider_id = $id_slider LIMIT 1");
    $sentence = $sentence->fetch();
    return ($sentence) ? $sentence : false;
    }
}



// STORES  ---------------------------------------

if (!function_exists('stores_total')) {
function stores_total(){

    $total_numbers = connect()->prepare("SELECT * FROM stores");
    $total_numbers->execute(array());
    $total_numbers->fetchAll();
    $total = $total_numbers->rowCount();
    return $total;
}
}


if (!function_exists('get_all_stores')) {
function get_all_stores(){

    $sql = "SELECT * FROM stores ORDER BY store_id DESC";
    $sentence = connect()->prepare($sql); 
    $sentence->execute();
    return $sentence->fetchAll();
}
}


if (!function_exists('get_store_slug')) {
function get_store_slug($slug){

    $sentence = connect()->prepare("SELECT COUNT(*) AS total FROM stores WHERE store_slug LIKE '$slug%'");
    $sentence->execute();
    $row = $sentence->fetch(PDO::FETCH_ASSOC);
    return $row['total'];
}
}


if (!function_exists('get_store_per_id')) {
function get_store_per_id($id_store){
    $sentence = connect()->query("SELECT * FROM stores WHERE store_id = $id_store LIMIT 1");
    $sentence = $sentence->fetch();
    return ($sentence) ? $sentence : false;
}
}


// LOCATIONS  ---------------------------------------

if (!function_exists('locations_total')) {
function locations_total(){

    $total_numbers = connect()->prepare("SELECT * FROM locations");
    $total_numbers->execute(array());
    $total_numbers->fetchAll();
    $total = $total_numbers->rowCount();
    return $total;
}
}


if (!function_exists('get_all_locations')) {
function get_all_locations(){

    $sql = "SELECT * FROM locations ORDER BY location_id DESC";
    $sentence = connect()->prepare($sql); 
    $sentence->execute();
    return $sentence->fetchAll();
}
}


if (!function_exists('get_location_slug')) {
function get_location_slug($slug){

    $sentence = connect()->prepare("SELECT COUNT(*) AS total FROM locations WHERE location_slug LIKE '$slug%'");
    $sentence->execute();
    $row = $sentence->fetch(PDO::FETCH_ASSOC);
    return $row['total'];
}
}


if (!function_exists('get_location_per_id')) {
function get_location_per_id($id_location){
    $sentence = connect()->query("SELECT * FROM locations WHERE location_id = $id_location LIMIT 1");
    $sentence = $sentence->fetch();
    return ($sentence) ? $sentence : false;
}
}


// COMMENTS/RATINGS/REVIEWS  ---------------------------------------

if (!function_exists('comments_total')) {
function comments_total(){

    $total_numbers = connect()->prepare("SELECT * FROM reviews");
    $total_numbers->execute(array());
    $total_numbers->fetchAll();
    $total = $total_numbers->rowCount();
    return $total;
}
}


if (!function_exists('get_all_comments')) {
function get_all_comments(){

    $sentence = connect()->prepare("SELECT reviews.*, users.user_name AS user_name, users.user_id AS user_id FROM reviews LEFT JOIN users ON users.user_id = reviews.user"); 
    $sentence->execute();
    return $sentence->fetchAll();
}
}


// PLANS  ---------------------------------------

if (!function_exists('get_plan_per_id')) {
function get_plan_per_id($id_plan){
    $sql = "SELECT * FROM plans WHERE plans.plan_id = :id LIMIT 1";
    $sentence = connect()->prepare($sql);
    $sentence->execute([':id' => (int)$id_plan]);
    $sentence = $sentence->fetch();
    return ($sentence) ? $sentence : false;
}
}


if (!function_exists('get_all_plans')) {
function get_all_plans(){

    $sql = "SELECT * FROM plans";
    $sentence = connect()->prepare($sql); 
    $sentence->execute();
    return $sentence->fetchAll();
}
}


// PAYMENTS  ---------------------------------------

if (!function_exists('get_payment_per_id')) {
function get_payment_per_id($id_payment){
    $sentence = connect()->query("SELECT payments.*, users.*, plans.*, codes.* FROM payments LEFT JOIN users ON users.user_id = payments.payment_user_id LEFT JOIN plans ON plans.plan_id = payments.payment_plan_id LEFT JOIN codes ON payments.payment_code = codes.code_coupon WHERE payments.payment_id = $id_payment LIMIT 1");
    $sentence = $sentence->fetch();
    return ($sentence) ? $sentence : false;
}
}


if (!function_exists('get_latest_payments')) {
function get_latest_payments($limit = 5, $interval = null){

    $start_date = new DateTime("now", new DateTimeZone(get_timezone()));
    $end_date = get_date_by_interval(getInterval());

    $sqlQuery = "SELECT payments.*, users.*, plans.* FROM payments LEFT JOIN users ON users.user_id = payments.payment_user_id LEFT JOIN plans ON plans.plan_id = payments.payment_plan_id";
    
    if($interval){

        if(getInterval() && getInterval() != "today"){

            $sqlQuery .= " WHERE (payment_date BETWEEN '".$end_date->format('Y-m-d 23:59:59')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";

        }elseif(getInterval() && getInterval() == "today"){

            $sqlQuery .= " WHERE (payment_date BETWEEN '".$start_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";

        }

    }

    $sqlQuery .= " ORDER BY payments.payment_date DESC";

    if($limit && is_int($limit)){
        $sqlQuery .= " LIMIT $limit";
    }
    
    $sentence = connect()->prepare($sqlQuery);
    $sentence->execute();
    return $sentence->fetchAll();

}
}


if (!function_exists('get_frequency_text')) {
function get_frequency_text($frequency){
    if($frequency == 'monthly'){
        return 'Monthly';
    }else if($frequency == 'halfyea' || $frequency == 'biannually'){
        return '6 Months';
    }else if($frequency == 'annual'){
        return 'Annual';
    }
}
}


if (!function_exists('get_all_payments')) {
function get_all_payments(){

    $start_date = new DateTime("now", new DateTimeZone(get_timezone()));
    $end_date = get_date_by_interval(getInterval());

    $sqlQuery = "SELECT payments.*, users.*, plans.* FROM payments LEFT JOIN users ON users.user_id = payments.payment_user_id LEFT JOIN plans ON plans.plan_id = payments.payment_plan_id";
    
    if(getInterval() && getInterval() != "today"){

        $sqlQuery .= " WHERE (payment_date BETWEEN '".$end_date->format('Y-m-d 23:59:59')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";

    }elseif(getInterval() && getInterval() == "today"){

        $sqlQuery .= " WHERE (payment_date BETWEEN '".$start_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";

    }

    $sqlQuery .= " ORDER BY payments.payment_date DESC";

    $sentence = connect()->prepare($sqlQuery);
    $sentence->execute();
    return $sentence->fetchAll();

}
}



if (!function_exists('get_all_addon_orders')) {
function get_all_addon_orders(){

    $sqlQuery = "SELECT ao.*, users.user_email, users.user_name, stores.store_title
                 FROM nd_addon_orders ao
                 LEFT JOIN users  ON users.user_id = ao.user_id
                 LEFT JOIN stores ON stores.store_id = ao.store_id
                 ORDER BY ao.created_at DESC";

    try {
        $sentence = connect()->prepare($sqlQuery);
        $sentence->execute();
        return $sentence->fetchAll();
    } catch (Throwable $e) {
        return [];
    }
}
}

if (!function_exists('get_addon_order_by_id')) {
function get_addon_order_by_id(int $id){
    try {
        $st = connect()->prepare("SELECT ao.*, users.user_email, users.user_name, stores.store_title
                                  FROM nd_addon_orders ao
                                  LEFT JOIN users  ON users.user_id = ao.user_id
                                  LEFT JOIN stores ON stores.store_id = ao.store_id
                                  WHERE ao.id = :id LIMIT 1");
        $st->execute([':id' => $id]);
        return $st->fetch();
    } catch (Throwable $e) {
        return false;
    }
}
}

if (!function_exists('update_addon_order')) {
function update_addon_order(array $data): bool {
    try {
        $st = connect()->prepare("UPDATE nd_addon_orders SET
            store_id = :store_id,
            status = :status,
            start_date = :start_date,
            end_date = :end_date,
            notes = :notes,
            meta_json = :meta_json,
            updated_at = :updated_at
            WHERE id = :id
        ");
        return $st->execute([
            ':id' => (int)$data['id'],
            ':store_id' => ($data['store_id'] ?? '') !== '' ? ($data['store_id'] ?? null) : null,
            ':status' => $data['status'],
            ':start_date' => $data['start_date'] ?: null,
            ':end_date' => $data['end_date'] ?: null,
            ':notes' => $data['notes'] ?: null,
            ':meta_json' => isset($data['meta_json']) && $data['meta_json'] !== '' ? $data['meta_json'] : null,
            ':updated_at' => getDateByTimeZone()
        ]);
    } catch (Throwable $e) {
        return false;
    }
}
}



if (!function_exists('payments_total')) {
function payments_total(){

    $total_numbers = connect()->prepare('SELECT * FROM payments');
    $total_numbers->execute(array());
    $total_numbers->fetchAll();
    $total = $total_numbers->rowCount();
    return $total;
}
}


if (!function_exists('get_earnings_by_interval')) {
function get_earnings_by_interval(){

    $start_date = new DateTime("now", new DateTimeZone(get_timezone()));
    $end_date = get_date_by_interval(getInterval());

    $sqlQuery = "SELECT SUM(payment_total_amount) AS total_earnings, COUNT(payment_id) AS total_payments FROM payments WHERE payment_status = 1";
    
    if(getInterval() && getInterval() != "today"){

        $sqlQuery .= " AND (payment_date BETWEEN '".$end_date->format('Y-m-d 23:59:59')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";

    }elseif(getInterval() && getInterval() == "today"){

        $sqlQuery .= " AND (payment_date BETWEEN '".$start_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";

    }

    $sqlQuery .= " ORDER BY payments.payment_date DESC";

    $sentence = connect()->prepare($sqlQuery);
    $sentence->execute();
    return $sentence->fetch();

}
}


if (!function_exists('get_taxes_by_ids')) {
function get_taxes_by_ids($plan_taxes){

    // Aceita tanto JSON array ("[1,2]") quanto objeto ("{\"taxes_ids\":[1,2], ...}")
    $decoded = json_decode($plan_taxes);

    if (empty($decoded)) {
        return [];
    }

    $ids = [];

    if (is_array($decoded)) {
        // Formato padrão: [1,2,3]
        $ids = $decoded;
    } elseif (is_object($decoded)) {
        // Formato alternativo: {"taxes_ids":[1,2], ...}
        if (isset($decoded->taxes_ids) && is_array($decoded->taxes_ids)) {
            $ids = $decoded->taxes_ids;
        } else {
            // Último recurso: converte as propriedades em array
            $ids = array_values((array) $decoded);
        }
    } else {
        // Caso de fallback: trata como lista separada por vírgula
        $ids = explode(',', (string) $plan_taxes);
    }

    // Normaliza e filtra apenas inteiros positivos
    $ids = array_filter(array_map('intval', (array) $ids), function($v){ return $v > 0; });

    if (empty($ids)) {
        return [];
    }

    $ids_list = implode(',', $ids);

    $sentence = connect()->prepare("SELECT * FROM taxes WHERE tax_id IN ({$ids_list})");
    $sentence->execute();
    return $sentence->fetchAll();
}
}



if (!function_exists('calc_taxes_by_price')) {
function calc_taxes_by_price($price, $percentage){

$percentage = $percentage;
$price = $price;

$new_width = ($percentage / 100) * $price;

return $new_width;

}
}


// DEALS  ---------------------------------------

if (!function_exists('get_total_drafts')) {
function get_total_drafts(){

    $sentence = connect()->prepare("SELECT COUNT(*) AS total FROM drafts");
    $sentence->execute();
    $row = $sentence->fetch(PDO::FETCH_ASSOC);
    return $row['total'];
}
}


if (!function_exists('get_total_pending_deals')) {
function get_total_pending_deals(){

    $sentence = connect()->prepare("SELECT COUNT(*) AS total FROM deals WHERE deal_status = 3");
    $sentence->execute();
    $row = $sentence->fetch(PDO::FETCH_ASSOC);
    return $row['total'];
}
}


if (!function_exists('get_submissions_log')) {
function get_submissions_log(){
    $sentence = connect()->query("SELECT submissions_log.*, deals.deal_title AS deal_title, (SELECT user_name FROM users WHERE user_id = submissions_log.author_id) AS author_name, (SELECT user_name FROM users WHERE user_id = submissions_log.reviewer_id) AS reviewer_name FROM submissions_log LEFT JOIN deals ON deals.deal_id = submissions_log.item ORDER BY submissions_log.created DESC");
    $sentence->execute();
    return $sentence->fetchAll();
}
}


if (!function_exists('get_all_drafts')) {
function get_all_drafts(){

    $sql = "SELECT drafts.*, users.user_name AS author_name FROM drafts LEFT JOIN users ON drafts.deal_author = users.user_id ORDER BY drafts.deal_updated DESC";

    $sentence = connect()->prepare($sql); 
    $sentence->execute();
    return $sentence->fetchAll();
}
}


if (!function_exists('get_draft_per_id')) {
function get_draft_per_id($id_deal){
    $sentence = connect()->query("SELECT drafts.*, submissions_log.*, categories.category_title AS category_title, stores.store_title AS store_title, subcategories.subcategory_title AS subcategory_title, locations.location_title AS location_title, users.user_name AS author_name FROM drafts LEFT JOIN submissions_log ON drafts.deal_id = submissions_log.item LEFT JOIN subcategories ON deal_subcategory = subcategories.subcategory_id LEFT JOIN categories ON deal_category = categories.category_id LEFT JOIN stores ON deal_store = stores.store_id LEFT JOIN locations ON deal_location = locations.location_id LEFT JOIN users ON deal_author = users.user_id WHERE drafts.deal_id = $id_deal ORDER BY submissions_log.created DESC LIMIT 1");
    $sentence = $sentence->fetch();
    return ($sentence) ? $sentence : false;
}
}


if (!function_exists('get_drafts_gallery')) {
function get_drafts_gallery($item){

    $sentence = connect()->prepare("SELECT * FROM deals_gallery WHERE item = $item AND status = 0");
    $sentence->execute();
    return $sentence->fetchAll();
}
}


if (!function_exists('get_all_deals')) {
function get_all_deals($limit = null, $status = null, $user = null){

    $sql = "SELECT deals.*, categories.category_title AS category_title, stores.store_title AS store_title, locations.location_title AS location_title, users.user_name AS author_name FROM deals LEFT JOIN categories ON deal_category = categories.category_id LEFT JOIN stores ON deal_store = stores.store_id LEFT JOIN locations ON deal_location = locations.location_id LEFT JOIN users ON deal_author = users.user_id";
   
    if($status && is_int($status)){
        $sql .= " WHERE deals.deal_status = $status";
    }

    $sql .= " ORDER BY deals.deal_created DESC";

    if($limit && is_int($limit)){
        $sql .= " LIMIT $limit";
    }

    $sentence = connect()->prepare($sql); 
    $sentence->execute();
    return $sentence->fetchAll();
}
}


if (!function_exists('get_top_deals')) {
function get_top_deals($limit = null){

    $sql = "SELECT deals.*, categories.category_title AS category_title, stores.store_title AS store_title, locations.location_title AS location_title, users.user_name AS author_name FROM deals LEFT JOIN categories ON deal_category = categories.category_id LEFT JOIN stores ON deal_store = stores.store_id LEFT JOIN locations ON deal_location = locations.location_id LEFT JOIN users ON deal_author = users.user_id ORDER BY deals.deal_clicks DESC";
    
    if($limit && is_int($limit)){
        $sql .= " LIMIT $limit";
    }

    $sentence = connect()->prepare($sql); 
    $sentence->execute();
    return $sentence->fetchAll();
}
}


if (!function_exists('get_all_deals_by_use')) {
function get_all_deals_by_user($user){

    $sql = "SELECT deals.*, categories.category_title AS category_title, stores.store_title AS store_title, locations.location_title AS location_title, users.user_name AS author_name FROM deals LEFT JOIN categories ON deal_category = categories.category_id LEFT JOIN stores ON deal_store = stores.store_id LEFT JOIN locations ON deal_location = locations.location_id LEFT JOIN users ON deal_author = users.user_id WHERE deals.deal_author = :deal_author ORDER BY deals.deal_created DESC";
    $sentence = connect()->prepare($sql); 
    $sentence->execute(array(
        ':deal_author' => $user
    ));
    return $sentence->fetchAll();
}
}


if (!function_exists('get_deal_slug')) {
function get_deal_slug($slug){

    $sentence = connect()->prepare("SELECT COUNT(*) AS total FROM deals WHERE deal_slug LIKE '$slug%'");
    $sentence->execute();
    $row = $sentence->fetch(PDO::FETCH_ASSOC);
    return $row['total'];
}
}


if (!function_exists('get_deals_gallery')) {
function get_deals_gallery($item){

    $sentence = connect()->prepare("SELECT * FROM deals_gallery WHERE item = $item");
    $sentence->execute();
    return $sentence->fetchAll();
}
}


if (!function_exists('get_top_deals_by_interval')) {
function get_top_deals_by_interval($limit = null){

    $start_date = new DateTime("now", new DateTimeZone(get_timezone()));
    $end_date = get_date_by_interval(getInterval());

    // Compatível com ONLY_FULL_GROUP_BY: não selecionar tracking.*
    $sql = "SELECT deals.deal_id, deals.deal_title, COUNT(*) AS num
            FROM tracking
            JOIN deals ON deals.deal_id = track_item WHERE 1=1";

    if(getInterval() && getInterval() != "today"){
        $sql .= " AND (track_datetime BETWEEN '".$end_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";
    }elseif(getInterval() && getInterval() == "today"){
        $sql .= " AND (track_datetime BETWEEN '".$start_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";
    }

    $sql .= " GROUP BY deals.deal_id, deals.deal_title ORDER BY num DESC, deals.deal_id DESC";

    if($limit && is_int($limit)){
        $sql .= " LIMIT $limit";
    }

    $sentence = connect()->prepare($sql);
    $sentence->execute();
    return $sentence->fetchAll();
}
}


if (!function_exists('get_deal_clicks_by_country')) {
function get_deal_clicks_by_country($id_deal, $limit = Null){

    $start_date = new DateTime("now", new DateTimeZone(get_timezone()));
    $end_date = get_date_by_interval(getInterval());

    // Compatível com ONLY_FULL_GROUP_BY: selecionar só colunas agrupadas/agrupáveis
    $sqlQuery = "SELECT track_country_code, track_country_name, COUNT(*) AS total FROM tracking WHERE track_item = :deal_id";

    if(getInterval() && getInterval() != "today"){
        $sqlQuery .= " AND (track_datetime BETWEEN '".$end_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";
    }elseif(getInterval() && getInterval() == "today"){
        $sqlQuery .= " AND (track_datetime BETWEEN '".$start_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";
    }

    $sqlQuery .= " GROUP BY track_country_code, track_country_name ORDER BY total DESC";

    if($limit && is_int($limit)){
        $sqlQuery .= " LIMIT $limit";
    }

    $sentence = connect()->prepare($sqlQuery);
    $sentence->execute(array(':deal_id' => $id_deal));
    return $sentence->fetchAll();
}
}




function get_deal_clicks_by_city($id_deal, $limit = null){
    $start_date = new DateTime("now", new DateTimeZone(get_timezone()));
    $end_date   = get_date_by_interval(getInterval());

    $sql = "SELECT
                track_city AS track_city,
                COUNT(*) AS total,
                SUM(CASE WHEN track_is_unique = '1' THEN 1 ELSE 0 END) AS totalunique
            FROM tracking
            WHERE track_item IN (SELECT deal_id FROM deals WHERE deal_id = :track_item)";

    if(getInterval() && getInterval() != "today"){
        $sql .= " AND (track_datetime BETWEEN '".$end_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";
    } elseif(getInterval() && getInterval() == "today"){
        $sql .= " AND (track_datetime BETWEEN '".$start_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";
    }

    $sql .= " GROUP BY track_city ORDER BY total DESC";

    if($limit && is_int($limit)){
        $sql .= " LIMIT $limit";
    }

    $st = connect()->prepare($sql);
    $st->execute([':track_item' => $id_deal]);
    return $st->fetchAll();
}


function get_deal_clicks_by_referrers($id_deal, $limit = null){
    $start_date = new DateTime("now", new DateTimeZone(get_timezone()));
    $end_date   = get_date_by_interval(getInterval());

    $sql = "SELECT
                track_host AS track_host,
                COUNT(*) AS total,
                SUM(CASE WHEN track_is_unique = '1' THEN 1 ELSE 0 END) AS totalunique
            FROM tracking
            WHERE track_item IN (SELECT deal_id FROM deals WHERE deal_id = :track_item)";

    if(getInterval() && getInterval() != "today"){
        $sql .= " AND (track_datetime BETWEEN '".$end_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";
    } elseif(getInterval() && getInterval() == "today"){
        $sql .= " AND (track_datetime BETWEEN '".$start_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";
    }

    $sql .= " GROUP BY track_host ORDER BY total DESC";

    if($limit && is_int($limit)){
        $sql .= " LIMIT $limit";
    }

    $st = connect()->prepare($sql);
    $st->execute([':track_item' => $id_deal]);
    return $st->fetchAll();
}


function get_deal_clicks_by_browsers($id_deal, $limit = null){
    $start_date = new DateTime("now", new DateTimeZone(get_timezone()));
    $end_date   = get_date_by_interval(getInterval());

    $sql = "SELECT
                track_browser AS track_browser,
                COUNT(*) AS total,
                SUM(CASE WHEN track_is_unique = '1' THEN 1 ELSE 0 END) AS totalunique
            FROM tracking
            WHERE track_item IN (SELECT deal_id FROM deals WHERE deal_id = :track_item)";

    if(getInterval() && getInterval() != "today"){
        $sql .= " AND (track_datetime BETWEEN '".$end_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";
    } elseif(getInterval() && getInterval() == "today"){
        $sql .= " AND (track_datetime BETWEEN '".$start_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";
    }

    $sql .= " GROUP BY track_browser ORDER BY total DESC";

    if($limit && is_int($limit)){
        $sql .= " LIMIT $limit";
    }

    $st = connect()->prepare($sql);
    $st->execute([':track_item' => $id_deal]);
    return $st->fetchAll();
}


function get_deal_clicks_by_devices($id_deal, $limit = null){
    $start_date = new DateTime("now", new DateTimeZone(get_timezone()));
    $end_date   = get_date_by_interval(getInterval());

    $sql = "SELECT
                track_device AS track_device,
                COUNT(*) AS total,
                SUM(CASE WHEN track_is_unique = '1' THEN 1 ELSE 0 END) AS totalunique
            FROM tracking
            WHERE track_item IN (SELECT deal_id FROM deals WHERE deal_id = :track_item)";

    if(getInterval() && getInterval() != "today"){
        $sql .= " AND (track_datetime BETWEEN '".$end_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";
    } elseif(getInterval() && getInterval() == "today"){
        $sql .= " AND (track_datetime BETWEEN '".$start_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";
    }

    $sql .= " GROUP BY track_device ORDER BY total DESC";

    if($limit && is_int($limit)){
        $sql .= " LIMIT $limit";
    }

    $st = connect()->prepare($sql);
    $st->execute([':track_item' => $id_deal]);
    return $st->fetchAll();
}


function get_deal_clicks_by_os($id_deal, $limit = null){
    $start_date = new DateTime("now", new DateTimeZone(get_timezone()));
    $end_date   = get_date_by_interval(getInterval());

    $sql = "SELECT
                track_os AS track_os,
                COUNT(*) AS total,
                SUM(CASE WHEN track_is_unique = '1' THEN 1 ELSE 0 END) AS totalunique
            FROM tracking
            WHERE track_item IN (SELECT deal_id FROM deals WHERE deal_id = :track_item)";

    if(getInterval() && getInterval() != "today"){
        $sql .= " AND (track_datetime BETWEEN '".$end_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";
    } elseif(getInterval() && getInterval() == "today"){
        $sql .= " AND (track_datetime BETWEEN '".$start_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";
    }

    $sql .= " GROUP BY track_os ORDER BY total DESC";

    if($limit && is_int($limit)){
        $sql .= " LIMIT $limit";
    }

    $st = connect()->prepare($sql);
    $st->execute([':track_item' => $id_deal]);
    return $st->fetchAll();
}


function get_deal_clicks_by_languages($id_deal, $limit = null){
    $start_date = new DateTime("now", new DateTimeZone(get_timezone()));
    $end_date   = get_date_by_interval(getInterval());

    $sql = "SELECT
                track_browser_language AS track_browser_language,
                COUNT(*) AS total,
                SUM(CASE WHEN track_is_unique = '1' THEN 1 ELSE 0 END) AS totalunique
            FROM tracking
            WHERE track_item IN (SELECT deal_id FROM deals WHERE deal_id = :track_item)";

    if(getInterval() && getInterval() != "today"){
        $sql .= " AND (track_datetime BETWEEN '".$end_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";
    } elseif(getInterval() && getInterval() == "today"){
        $sql .= " AND (track_datetime BETWEEN '".$start_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";
    }

    $sql .= " GROUP BY track_browser_language ORDER BY total DESC";

    if($limit && is_int($limit)){
        $sql .= " LIMIT $limit";
    }

    $st = connect()->prepare($sql);
    $st->execute([':track_item' => $id_deal]);
    return $st->fetchAll();
}

if (!function_exists('get_deals_count_by_status')) {
function get_deals_count_by_status($status = 1, $exclusive = null, $featured = null){

    $start_date = new DateTime("now", new DateTimeZone(get_timezone()));
    $end_date = get_date_by_interval(getInterval());

    $sqlQuery = "SELECT count(*) AS total FROM deals";

    if(getInterval() && getInterval() != "today"){

        $sqlQuery .= " WHERE (deal_created BETWEEN '".$end_date->format('Y-m-d 23:59:59')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";

    }elseif(getInterval() && getInterval() == "today"){

        $sqlQuery .= " WHERE (deal_created BETWEEN '".$start_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";


    }

    if($status && is_int($status)){
        $sqlQuery .= " AND deal_status = $status";
    }

    if($exclusive && is_int($exclusive)){
        $sqlQuery .= " AND deal_exclusive = $exclusive";
    }

    if($featured && is_int($featured)){
        $sqlQuery .= " AND deal_featured = $featured";
    }

    $sentence = connect()->prepare($sqlQuery);
    $sentence->execute();
    $total_items = $sentence->fetch()['total'];
    return $total_items;
}
}


if (!function_exists('get_total_clicks')) {
function get_total_clicks($unique = null){

    $start_date = new DateTime("now", new DateTimeZone(get_timezone()));
    $end_date = get_date_by_interval(getInterval());

    $sqlQuery = "SELECT COUNT(*) AS num, sum(CASE WHEN track_is_unique = '1' then 1 else 0 end) AS uniquenum FROM tracking";

    if(getInterval() && getInterval() != "today"){

        $sqlQuery .= " WHERE (track_datetime BETWEEN '".$end_date->format('Y-m-d 23:59:59')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";

    }elseif(getInterval() && getInterval() == "today"){

        $sqlQuery .= " WHERE (track_datetime BETWEEN '".$start_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";


    }

    $sentence = connect()->prepare($sqlQuery);
    $sentence->execute();
    $total_items = $sentence->fetch();

    if($unique){
        return ($total_items['uniquenum'] ? $total_items['uniquenum'] : 0);
    }else{
        return $total_items['num'];
    }
}
}


if (!function_exists('get_total_clicks_by_interval')) {
function get_total_clicks_by_interval(){

    $start_date = new DateTime("now", new DateTimeZone(get_timezone()));
    $end_date   = get_date_by_interval(getInterval());

    // Define bucket de agrupamento conforme o intervalo
    $interval = getInterval();
    $groupExpr = "DATE(track_datetime)";   // padrão: por dia
    $labelPHP  = 'd-m-Y';

    if ($interval && $interval == "today") {
        // Agrupar por hora (YYYY-mm-dd HH:00:00)
        $groupExpr = "DATE_FORMAT(track_datetime, '%Y-%m-%d %H:00:00')";
        $labelPHP  = 'H:00';
    } elseif ($interval && ($interval == "last7days" || $interval == "last30days")) {
        $groupExpr = "DATE(track_datetime)";
        $labelPHP  = 'd-m';
    }

    $sql = "SELECT {$groupExpr} AS bucket,
                   COUNT(*) AS num,
                   SUM(CASE WHEN track_is_unique = '1' THEN 1 ELSE 0 END) AS uniquenum
            FROM tracking";

    if ($interval && $interval != "today") {
        $sql .= " WHERE (track_datetime BETWEEN '".$end_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";
    } elseif ($interval && $interval == "today") {
        $sql .= " WHERE (track_datetime BETWEEN '".$start_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";
    }

    $sql .= " GROUP BY bucket ORDER BY bucket ASC";

    $st = connect()->prepare($sql);
    $st->execute();
    $rows = $st->fetchAll();

    $data = array();
    foreach ($rows as $row) {
        // Quando agrupado por hora, bucket já vem com data+hora; por dia, vem 'YYYY-mm-dd'
        $dt = new DateTime($row['bucket'], new DateTimeZone(get_timezone()));
        $data[] = array(
            'label'        => $dt->format($labelPHP),
            'clicks'       => (int)$row['num'],
            'uniqueclicks' => (int)$row['uniquenum']
        );
    }

    return json_encode($data);
}
}


// Substitua a função atual por esta

# Substituído: agrega cliques por dia (compatível com ONLY_FULL_GROUP_BY)
function get_deal_clicks_by_interval($deal_id, int $days = 30): array
{
    $pdo = connect();
    if (!$pdo) return [];

    $sql = "
        SELECT
            DATE(track_datetime) AS day,
            COUNT(*) AS clicks,
            SUM(CASE WHEN track_is_unique = '1' THEN 1 ELSE 0 END) AS unique_clicks
        FROM tracking
        WHERE track_item = :deal_id
          AND track_datetime >= (CURRENT_DATE - INTERVAL :days DAY)
        GROUP BY DATE(track_datetime)
        ORDER BY day DESC
    ";

    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':deal_id', (int)$deal_id, PDO::PARAM_INT);
    $stmt->bindValue(':days',   (int)$days,    PDO::PARAM_INT);
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $map = [];
    foreach ($rows as $r) {
        $map[$r['day']] = [
            'clicks'        => (int)$r['clicks'],
            'unique_clicks' => (int)$r['unique_clicks'],
        ];
    }

    $out = [];
    for ($i = 0; $i < $days; $i++) {
        $d = (new DateTime('today'))->sub(new DateInterval('P' . $i . 'D'))->format('Y-m-d');
        $out[] = [
            'day'           => $d,
            'clicks'        => $map[$d]['clicks']        ?? 0,
            'unique_clicks' => $map[$d]['unique_clicks'] ?? 0,
        ];
    }
    return $out;
}



if (!function_exists('get_deal_per_id')) {
function get_deal_per_id($id_deal){
    $sentence = connect()->query("SELECT deals.*, categories.category_title AS category_title, stores.store_title AS store_title, subcategories.subcategory_title AS subcategory_title, locations.location_title AS location_title, users.user_name AS author_name FROM deals LEFT JOIN subcategories ON deal_subcategory = subcategories.subcategory_id LEFT JOIN categories ON deal_category = categories.category_id LEFT JOIN stores ON deal_store = stores.store_id LEFT JOIN locations ON deal_location = locations.location_id LEFT JOIN users ON deal_author = users.user_id WHERE deals.deal_id = $id_deal LIMIT 1");
    $sentence = $sentence->fetch();
    return ($sentence) ? $sentence : false;
}
}


if (!function_exists('get_pending_deal_per_id')) {
function get_pending_deal_per_id($id_deal){
    $sentence = connect()->query("SELECT deals.*, categories.category_title AS category_title, stores.store_title AS store_title, subcategories.subcategory_title AS subcategory_title, locations.location_title AS location_title, users.user_name AS author_name FROM deals LEFT JOIN subcategories ON deal_subcategory = subcategories.subcategory_id LEFT JOIN categories ON deal_category = categories.category_id LEFT JOIN stores ON deal_store = stores.store_id LEFT JOIN locations ON deal_location = locations.location_id LEFT JOIN users ON deal_author = users.user_id WHERE deals.deal_id = $id_deal AND deals.deal_status = 3 OR deals.deal_status = 5 LIMIT 1");
    $sentence = $sentence->fetch();
    return ($sentence) ? $sentence : false;
}
}


if (!function_exists('deals_total')) {
function deals_total(){

    $total_numbers = connect()->prepare('SELECT * FROM deals');
    $total_numbers->execute(array());
    $total_numbers->fetchAll();
    $total = $total_numbers->rowCount();
    return $total;
}
}


if (!function_exists('total_deals_by_use')) {
function total_deals_by_user($user){

    $total_numbers = connect()->prepare("SELECT * FROM deals WHERE deal_author = $user");
    $total_numbers->execute(array());
    $total_numbers->fetchAll();
    $total = $total_numbers->rowCount();
    return $total;
}
}


// ADS ---------------------------------------

if (!function_exists('get_all_ads')) {
function get_all_ads(){

    $sentence = connect()->prepare("SELECT * FROM ads"); 
    $sentence->execute();
    return $sentence->fetchAll();
}
}


if (!function_exists('get_ad_per_id')) {
function get_ad_per_id($id_ad){
    $sentence = connect()->query("SELECT * FROM ads WHERE ad_id = $id_ad LIMIT 1");
    $sentence = $sentence->fetch();
    return ($sentence) ? $sentence : false;
}
}


// TAXES ---------------------------------------

if (!function_exists('get_all_taxes')) {
function get_all_taxes(){

    $sentence = connect()->prepare("SELECT * FROM taxes ORDER BY tax_created DESC"); 
    $sentence->execute();
    return $sentence->fetchAll();
}
}



if (!function_exists('get_tax_per_id')) {
function get_tax_per_id($id_tax){
    $sentence = connect()->query("SELECT * FROM taxes WHERE tax_id = $id_tax LIMIT 1");
    $sentence = $sentence->fetch();
    return ($sentence) ? $sentence : false;
}
}


// SELLERS ---------------------------------------

if (!function_exists('get_all_sellers')) {
function get_all_sellers(){

    $sentence = connect()->prepare("SELECT sellers.*, users.* FROM sellers LEFT JOIN users ON sellers.seller_user = users.user_id ORDER BY sellers.seller_created DESC"); 
    $sentence->execute();
    return $sentence->fetchAll();
}
}



if (!function_exists('get_seller_per_id')) {
function get_seller_per_id($id_seller){
    $sentence = connect()->query("SELECT * FROM sellers WHERE seller_id = $id_seller LIMIT 1");
    $sentence = $sentence->fetch();
    return ($sentence) ? $sentence : false;
}
}


if (!function_exists('sellers_total')) {
function sellers_total(){

    $total_numbers = connect()->prepare('SELECT * FROM sellers');
    $total_numbers->execute(array());
    $total_numbers->fetchAll();
    $total = $total_numbers->rowCount();
    return $total;
}
}

// ASSOCIATES ---------------------------------------

if (!function_exists('get_all_associates')) {
function get_all_associates(){

    $sentence = connect()->prepare("SELECT * FROM associates ORDER BY associate_created DESC");
    $sentence->execute();
    return $sentence->fetchAll();
}
}

if (!function_exists('get_associate_per_id')) {
function get_associate_per_id($id_associate){
    $id_associate = (int)$id_associate;
    $sentence = connect()->query("SELECT * FROM associates WHERE associate_id = $id_associate LIMIT 1");
    $sentence = $sentence->fetch();
    return ($sentence) ? $sentence : false;
}
}

if (!function_exists('associates_total')) {
function associates_total(){

    $total_numbers = connect()->prepare('SELECT * FROM associates');
    $total_numbers->execute(array());
    $total_numbers->fetchAll();
    $total = $total_numbers->rowCount();
    return $total;
}
}



if (!function_exists('associate_clicks_total')) {
function associate_clicks_total($associate_id){
    try {
        $associate_id = (int)$associate_id;
        $sentence = connect()->prepare("SELECT COUNT(*) AS total FROM associate_clicks WHERE associate_id = :id");
        $sentence->execute(array(':id' => $associate_id));
        $row = $sentence->fetch();
        if ($row && isset($row['total'])) {
            return (int)$row['total'];
        }
    } catch (Exception $e) {
        // se a tabela associate_clicks não existir, retornamos 0
    }
    return 0;
}
}

if (!function_exists('associate_last_click')) {
function associate_last_click($associate_id){
    try {
        $associate_id = (int)$associate_id;
        $sentence = connect()->prepare("SELECT click_time FROM associate_clicks WHERE associate_id = :id ORDER BY click_time DESC LIMIT 1");
        $sentence->execute(array(':id' => $associate_id));
        $row = $sentence->fetch();
        if ($row && isset($row['click_time'])) {
            return $row['click_time'];
        }
    } catch (Exception $e) {
        // tabela não existe ou erro -> retornamos null
    }
    return null;
}
}




// CODES ---------------------------------------

if (!function_exists('get_active_codes')) {
function get_active_codes(){

    $sentence = connect()->prepare("SELECT * FROM codes WHERE code_status = 1 ORDER BY code_id ASC"); 
    $sentence->execute();
    return $sentence->fetchAll();
}
}


if (!function_exists('totalCodes')) {
function totalCodes($items_per_page){

    $total_items = connect()->prepare("SELECT COUNT(*) AS total FROM codes");
    $total_items->execute();
    $total_items = $total_items->fetch()['total'];

    $number_pages = ceil($total_items / $items_per_page);
    return $number_pages;
}
}


if (!function_exists('get_all_codes')) {

function get_all_codes(){

    $db = connect();

    // Cupons de plano (tabela original `codes`)
    $sqlPlan = "
        SELECT
            c.code_id,
            c.code_title,
            c.code_coupon,
            c.code_discount,
            c.code_quantity,
            (SELECT COUNT(*) FROM payments p WHERE p.payment_code = c.code_coupon AND p.payment_status = 1) AS totalused,
            c.code_status,
            NULL AS deal_title,
            NULL AS store_title,
            NULL AS advertiser_name
        FROM codes c
    ";

    // Cupons de ofertas (tabela `deal_coupons`)
    $sqlDeals = "
        SELECT
            dc.coupon_id      AS code_id,
            dc.coupon_title   AS code_title,
            dc.coupon_code    AS code_coupon,
            dc.discount_percent AS code_discount,
            COALESCE(dc.quantity, 0) AS code_quantity,
            0 AS totalused,
            dc.status         AS code_status,
            d.deal_title      AS deal_title,
            s.store_title     AS store_title,
            u.user_name       AS advertiser_name
        FROM deal_coupons dc
        LEFT JOIN deals d
               ON dc.deal_id = d.deal_id
        LEFT JOIN stores s
               ON (CAST(d.deal_store AS CHAR) = CAST(s.store_id AS CHAR) OR d.deal_store = s.store_slug)
        LEFT JOIN users u
               ON dc.user_id = u.user_id
    ";

    $sql = $sqlPlan . " UNION ALL " . $sqlDeals;

    $stmt = $db->prepare($sql);
    $stmt->execute();
    $rows = $stmt->fetchAll();
    return $rows;
}
}


if (!function_exists('get_code_per_id')) {
function get_code_per_id($id_code){
    $sentence = connect()->query("SELECT * FROM codes WHERE codes.code_id = $id_code LIMIT 1");
    $sentence = $sentence->fetch();
    return ($sentence) ? $sentence : false;
}
}


if (!function_exists('codes_total')) {
function codes_total(){

    $total_numbers = connect()->prepare('SELECT * FROM codes');
    $total_numbers->execute(array());
    $total_numbers->fetchAll();
    $total = $total_numbers->rowCount();
    return $total;
}
}


// USERS ---------------------------------------

if (!function_exists('get_active_users')) {
function get_active_users(){

    $sentence = connect()->prepare("SELECT * FROM users WHERE user_status = 1 ORDER BY user_id ASC"); 
    $sentence->execute();
    return $sentence->fetchAll();
}
}


if (!function_exists('get_active_paid_users')) {
function get_active_paid_users(){
    $sentence = connect()->query("SELECT COUNT(user_id) AS total FROM users WHERE user_plan_expiration_date >= CURDATE()");
    $sentence = $sentence->fetch();
    return ($sentence) ? $sentence : false;
}
}


if (!function_exists('totalUsers')) {
function totalUsers($items_per_page){

    $total_items = connect()->prepare("SELECT COUNT(*) AS total FROM users");
    $total_items->execute();
    $total_items = $total_items->fetch()['total'];

    $number_pages = ceil($total_items / $items_per_page);
    return $number_pages;
}
}


if (!function_exists('total_properties_by_use')) {
function total_properties_by_user($id_user){

    $total_items = connect()->prepare("SELECT COUNT(*) AS total FROM properties WHERE pt_agent = $id_user");
    $total_items->execute();
    $total_items = $total_items->fetch()['total'];
    return $total_items;    

}
}


if (!function_exists('get_all_users')) {
function get_all_users($limit = null){

    $sql = "SELECT users.*, roles.role_permissions AS role_permissions FROM users LEFT JOIN roles ON users.user_role = roles.role_id ORDER BY users.user_created DESC";

    if($limit && is_int($limit)){
        $sql .= " LIMIT $limit";
    }

    $sentence = connect()->prepare($sql); 
    $sentence->execute();
    return $sentence->fetchAll();
}
}


if (!function_exists('get_user_per_id')) {
function get_user_per_id($id_user){
    $sentence = connect()->query("SELECT users.*,roles.role_permissions AS role_permissions, roles.role_title AS role_title FROM users LEFT JOIN roles ON users.user_role = roles.role_id WHERE users.user_id = $id_user LIMIT 1");
    $sentence = $sentence->fetch();
    return ($sentence) ? $sentence : false;
}
}


if (!function_exists('users_total')) {
function users_total(){

    $total_numbers = connect()->prepare('SELECT * FROM users');
    $total_numbers->execute(array());
    $total_numbers->fetchAll();
    $total = $total_numbers->rowCount();
    return $total;
}
}


if (!function_exists('get_total_users')) {
function get_total_users($verified = null){

    $start_date = new DateTime("now", new DateTimeZone(get_timezone()));
    $end_date = get_date_by_interval(getInterval());

    $sqlQuery = "SELECT COUNT(*) AS num, sum(CASE WHEN user_verified = '1' then 1 else 0 end) AS verified FROM users";

    if(getInterval() && getInterval() != "today"){

        $sqlQuery .= " WHERE (user_created BETWEEN '".$end_date->format('Y-m-d 23:59:59')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";

    }elseif(getInterval() && getInterval() == "today"){

        $sqlQuery .= " WHERE (user_created BETWEEN '".$start_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";


    }

    $sentence = connect()->prepare($sqlQuery);
    $sentence->execute();
    $total_items = $sentence->fetch();

    if($verified){
        return ($total_items['verified'] ? $total_items['verified'] : 0);
    }else{
        return $total_items['num'];
    }
}
}


if (!function_exists('get_total_sellers')) {
function get_total_sellers(){

    $start_date = new DateTime("now", new DateTimeZone(get_timezone()));
    $end_date = get_date_by_interval(getInterval());

    $sqlQuery = "SELECT COUNT(*) AS num FROM sellers";

    if(getInterval() && getInterval() != "today"){

        $sqlQuery .= " WHERE (seller_created BETWEEN '".$end_date->format('Y-m-d 23:59:59')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";

    }elseif(getInterval() && getInterval() == "today"){

        $sqlQuery .= " WHERE (seller_created BETWEEN '".$start_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";


    }

    $sentence = connect()->prepare($sqlQuery);
    $sentence->execute();
    $total_items = $sentence->fetch();
    return $total_items['num'];
}
}


// SUBSCRIBERS ---------------------------------------

if (!function_exists('totalSubscribers')) {
function totalSubscribers(){

    $total_items = connect()->prepare("SELECT COUNT(*) AS total FROM subscribers");
    $total_items->execute();
    return $total_items = $total_items->fetch()['total'];

}
}


if (!function_exists('get_all_subscribers')) {
function get_all_subscribers(){

    $sentence = connect()->prepare("SELECT * FROM subscribers"); 
    $sentence->execute();
    return $sentence->fetchAll();
}
}


// EMAILS ---------------------------------------

if (!function_exists('get_etemplate_by_id')) {
function get_etemplate_by_id($id){

    $sentence = connect()->prepare("SELECT * FROM emailtemplates WHERE email_id = '".$id."'");
    $sentence->execute();
    $row = $sentence->fetch(PDO::FETCH_ASSOC);
    return $row;
}
}


if (!function_exists('get_all_email_templates')) {
function get_all_email_templates(){

    $sentence = connect()->prepare("SELECT * FROM emailtemplates"); 
    $sentence->execute();
    return $sentence->fetchAll();
}
}


if (!function_exists('getEmailTemplate')) {
function getEmailTemplate($id){

    if (!empty($id) && (int)($id)) {

        $q = connect()->query("SELECT * FROM emailtemplates WHERE email_id = ".$id." LIMIT 1");
        $f = $q->fetch();
        $result = $f;

        return $result;

    }else{

        return null;
    }  
}
}


if (!function_exists('checkMail')) {
function checkMail($settings){

    $smtp = new SMTP;

//Enable connection-level debug output
//$smtp->do_debug = SMTP::DEBUG_CONNECTION;

    $result = "";

    try {
    //Connect to an SMTP server
        if (!$smtp->connect($settings['st_smtphost'], $settings['st_smtpport'])) {
         $result = "Connect failed";
     }
    //Say hello
     if (!$smtp->hello(gethostname())) {
        $result = "EHLO failed";
    }
    //Get the list of ESMTP services the server offers
    $e = $smtp->getServerExtList();
    //If server can do TLS encryption, use it
    if (is_array($e) && array_key_exists($settings['st_smtpencrypt'], $e)) {
        $tlsok = $smtp->startTLS();
        if (!$tlsok) {
            $result = 'Failed to start encryption: ' . $smtp->getError()['erro'];
        }
        //Repeat EHLO after STARTTLS
        if (!$smtp->hello(gethostname())) {
            $result = 'EHLO (2) failed: ' . $smtp->getError()['erro'];
        }
        //Get new capabilities list, which will usually now include AUTH if it didn't before
        $e = $smtp->getServerExtList();
    }
    //If server supports authentication, do it (even if no encryption)
    if (is_array($e) && array_key_exists('AUTH', $e)) {
        if ($smtp->authenticate($settings['st_smtpemail'], $settings['st_smtppassword'])) {
        } else{
            $result = 'Authentication failed: ' . $smtp->getError()['erro'];
        }
    }

} catch (Exception $e) {
    $result = 'SMTP error: ' . $e->getMessage();
}

return $result;

}
}


if (!function_exists('sendMail')) {
function sendMail($array_content, $email_content, $destinationmail, $fromName, $subject, $isHtml, $settings) {

    $mail = new PHPMailer(true);

    try {

        $mail->isSMTP();                                          
        $mail->Host       = $settings['st_smtphost'];                
        $mail->SMTPAuth   = true;                                   
        $mail->Username   = $settings['st_smtpemail'];              
        $mail->Password   = $settings['st_smtppassword'];                             
        $mail->SMTPSecure = $settings['st_smtpencrypt'];
        $mail->Port       = $settings['st_smtpport'];

        $mail->setFrom($settings['st_smtpemail'], $fromName);
        $mail->CharSet = "UTF-8";
        $mail->AddAddress($destinationmail); 
        $mail->isHTML($isHtml);
        
        $find = array_keys($array_content);
        $replace = array_values($array_content);

        $mailcontent = str_replace($find, $replace, $email_content);
        $mailsubject = str_replace($find, $replace, $subject);

        $mail->Subject = $mailsubject;

        $mail->Body = $mailcontent;
        if (!$mail->send())
        {
            $result = $mail->ErrorInfo;
        }
        else 
        {
            $result = TRUE;
        }

        return $result;

    } catch (Exception $e) {
       return null;
   }

}
}
 

// OTHERS ---------------------------------------

if (!function_exists('get_settings')) {
function get_settings(){

    $sentence = connect()->prepare("SELECT * FROM settings"); 
    $sentence->execute();
    $row = $sentence->fetch();
    return $row;
}
}


if (!function_exists('get_theme')) {
function get_theme(){

    $sentence = connect()->prepare("SELECT * FROM theme"); 
    $sentence->execute();
    return $sentence->fetch();
}
}


if (!function_exists('FormatDate')) {
function FormatDate($date){

    $sentence = connect()->prepare("SELECT st_dateformat FROM settings");
    $sentence->execute();
    $row = $sentence->fetch();

    $newDate = date($row['st_dateformat'], strtotime($date));
    return $newDate;
}
}


if (!function_exists('hexToRgb')) {
function hexToRgb($hex, $alpha = false) {
 $hex = str_replace('#', '', $hex);
 $length = strlen($hex);
 $rgb['r'] = hexdec($length == 6 ? substr($hex, 0, 2) : ($length == 3 ? str_repeat(substr($hex, 0, 1), 2) : 0));
 $rgb['g'] = hexdec($length == 6 ? substr($hex, 2, 2) : ($length == 3 ? str_repeat(substr($hex, 1, 1), 2) : 0));
 $rgb['b'] = hexdec($length == 6 ? substr($hex, 4, 2) : ($length == 3 ? str_repeat(substr($hex, 2, 1), 2) : 0));
 if ( $alpha ) {
  $rgb['a'] = $alpha;
}

return implode(array_keys($rgb)) . '(' . implode(', ', $rgb) . ')';
}
}


if (!function_exists('getPrice')) {
function getPrice($price){

    $sentence = connect()->prepare("SELECT * FROM settings");
    $sentence->execute();
    $row = $sentence->fetch();

    $output = "";

    if ($row['st_currencyposition'] == 'left') {
        $output = $row['st_currency'] . number_format($price, 0, '', $row['st_decimalseparato']);
    }elseif ($row['st_currencyposition'] == 'left-space') {
        $output = $row['st_currency'] .' '. number_format($price, 0, '', $row['st_decimalseparato']);
    }elseif ($row['st_currencyposition'] == 'right') {
        $output = number_format($price, 0, '', $row['st_decimalseparato']) . $row['st_currency'];
    }elseif ($row['st_currencyposition'] == 'right-space') {
        $output = number_format($price, 0, '', $row['st_decimalseparato']) .' '. $row['st_currency'];
    }else{

    }

    return $output;
}
}

if (!function_exists('getPricePayment')) {
function getPricePayment($price, $currency){

    $sentence = connect()->prepare("SELECT * FROM settings");
    $sentence->execute();
    $row = $sentence->fetch();

    // Garante que sempre tenhamos um separador decimal válido
    $decimal = null;
    if (isset($row['st_decimalseparator']) && $row['st_decimalseparator'] !== '') {
        $decimal = $row['st_decimalseparator'];
    } elseif (isset($row['st_decimalseparato']) && $row['st_decimalseparato'] !== '') {
        // compatibilidade com configs antigas/coluna com nome errado
        $decimal = $row['st_decimalseparato'];
    } else {
        $decimal = '.';
    }

    $price = (float) $price;

    return number_format($price, 2, $decimal, '') .' '. $currency;

}
}


if (!function_exists('allowedFileExt')) {
function allowedFileExt(){
    return array("jpg", "jpeg", "png", "gif");
}
}


if (!function_exists('allowedFileSize')) {
function allowedFileSize(){

    /*
    
    1Mb = 1048576;
    2Mb = 2097152;
    3Mb = 3145728;
    4Mb = 4194304;

    */

    return 1048576;
}
}


if (!function_exists('getInterval')) {
function getInterval(){

    $interval = isset($_GET['interval']) && !empty($_GET['interval']) && $_GET['interval'] ? cleardata($_GET['interval']) : "last7days";

    $intervals = array("today", "yesterday", "last7days", "last30days", "last6months", "lastyear", "alltime");

    if (in_array($interval, $intervals)) {

            return $interval;
            
        }else{
   
        return false;
    }
    
}
}


if (!function_exists('getStatsFo')) {
function getStatsFor(){

    $for = isset($_GET['fo']) && !empty($_GET['fo']) && $_GET['fo'] ? cleardata($_GET['fo']) : NULL;

    $stats = array("referrers", "countries", "cities", "languages", "os", "browsers", "devices");

    if (in_array($for, $stats)) {

            return $for;
            
        }else{
   
        return false;
    }
    
}
}


if (!function_exists('get_date_by_interval')) {
function get_date_by_interval($interval){

    $date = new DateTime("now", new DateTimeZone(get_timezone()));

    $intervals = array("today", "yesterday", "last7days", "last30days", "last6months", "lastyear", "alltime");

    if (in_array($interval, $intervals)) {

        switch($interval) {

            case 'today':

                return $date;

            break;
    
            case 'yesterday':

                $date->sub(new \DateInterval('P1D'));
                return $date;

            break;
    
            case 'last7days':

                $date->sub(new \DateInterval('P7D'));
                return $date;

            break;
    
            case 'last30days':

                $date->sub(new \DateInterval('P1M'));
                return $date;
                
            break;
    
            case 'last6months':

                $date->sub(new \DateInterval('P6M'));
                return $date;

            break;
    
            case 'lastyear':

                $date->sub(new \DateInterval('P1Y'));
                return $date;

            break;

            case 'alltime':

                $date->sub(new \DateInterval('P5Y'));
                return $date;

            break;
    
            }

        }else{
   
        return false;
    }
    
}
}


if (!function_exists('get_timezone')) {
function get_timezone(){

    $sentence = connect()->prepare("SELECT st_timezone FROM settings");
    $sentence->execute();
    $row = $sentence->fetch();

    if(!empty($row['st_timezone'])){

        return $row['st_timezone'];

    }else{

        return "UTC";
    }

}
}


if (!function_exists('get_date_by_timezone')) {
function get_date_by_timezone($format = null){

    $sentence = connect()->prepare("SELECT st_timezone FROM settings");
    $sentence->execute();
    $row = $sentence->fetch();

    $date = new DateTime("now", new DateTimeZone($row['st_timezone']) );

    if($format){
        return $date->format($format);
    }else{
        return $date->format('Y-m-d H:i');
    }

}
}



if (!function_exists('get_language_from_locale')) {
function get_language_from_locale($array, $locale) {

    if(!isset($array[$locale])) {
        return $locale;
    } else {
        return $array[$locale];
    }
}
}


if (!function_exists('get_top_countries')) {
function get_top_countries($limit = null){

    $start_date = new DateTime("now", new DateTimeZone(get_timezone()));
    $end_date = get_date_by_interval(getInterval());

    $sql = "SELECT
                track_country_code,
                track_country_name,
                COUNT(*) AS total,
                SUM(CASE WHEN track_is_unique = '1' THEN 1 ELSE 0 END) AS totalunique
            FROM tracking";

    if (getInterval() && getInterval() != "today") {
        $sql .= " WHERE (track_datetime BETWEEN '".$end_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";
    } elseif (getInterval() && getInterval() == "today") {
        $sql .= " WHERE (track_datetime BETWEEN '".$start_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";
    }

    $sql .= " GROUP BY track_country_code, track_country_name
              ORDER BY total DESC, track_country_name ASC";

    if ($limit && is_int($limit)) {
        $sql .= " LIMIT $limit";
    }

    $st = connect()->prepare($sql);
    $st->execute();
    return $st->fetchAll();
}
}


if (!function_exists('get_top_cities')) {
function get_top_cities($limit = null){

    $start_date = new DateTime("now", new DateTimeZone(get_timezone()));
    $end_date   = get_date_by_interval(getInterval());

    // Remove track_region e usa apenas colunas existentes
    $sql = "SELECT
                track_city,
                track_country_code,
                track_country_name,
                COUNT(*) AS total,
                SUM(CASE WHEN track_is_unique = '1' THEN 1 ELSE 0 END) AS totalunique
            FROM tracking";

    if (getInterval() && getInterval() != "today") {
        $sql .= " WHERE (track_datetime BETWEEN '".$end_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";
    } elseif (getInterval() && getInterval() == "today") {
        $sql .= " WHERE (track_datetime BETWEEN '".$start_date->format('Y-m-d 00:00:00')."' AND '".$start_date->format('Y-m-d 23:59:59')."')";
    }

    $sql .= " GROUP BY track_city, track_country_code, track_country_name
              ORDER BY total DESC, track_city ASC";

    if ($limit) {
        $limit = (int)$limit;
        if ($limit > 0) $sql .= " LIMIT $limit";
    }

    $st = connect()->prepare($sql);
    $st->execute();
    return $st->fetchAll();
}
}


?>