<?php

declare(strict_types=1);
// admin/inc/i18n.php — helper simples (idioma único PT-BR)
if (!isset($T) || !is_array($T)) { $T = []; }

/** Texto traduzido (PT-BR fixo) com fallback. */
function __t(string $key, string $fallback = ''): string {
  global $T;
  return $T[$key] ?? ($fallback !== '' ? $fallback : $key);
}

/** Escapar HTML com segurança. */
function e(string $s): string {
  return htmlspecialchars($s, ENT_QUOTES, 'UTF-8');
}
