<?php

declare(strict_types=1);
// admin/partials/expire-field.inc.php
// $deal['deal_expire'] expected as 'Y-m-d H:i:s' or null
$__dbExpire = isset($deal['deal_expire']) && $deal['deal_expire'] ? $deal['deal_expire'] : '';
$__value = '';
if ($__dbExpire) {
  // to datetime-local => 'YYYY-MM-DDTHH:MM'
  $__value = preg_replace('~\s+~',' ', $__dbExpire);
  $__value = str_replace(' ', 'T', substr($__value, 0, 16));
}
?>
<label for="deal-expire-local">Data de expiração</label>
<input class="form-control" type="datetime-local" id="deal-expire-local" name="deal_expire" data-db-value="<?php echo htmlspecialchars($__dbExpire, ENT_QUOTES, 'UTF-8'); ?>" value="<?php echo htmlspecialchars($__value, ENT_QUOTES, 'UTF-8'); ?>">
<small>Se deixar em branco, a oferta não terá data de expiração.</small>
<script>
(function(){
  var s = document.createElement('script');
  s.src = '<?php echo htmlspecialchars((new Routes())->assets_js("fix-expire-datetime.js"), ENT_QUOTES, "UTF-8"); ?>';
  document.currentScript.parentNode.appendChild(s);
})();
</script>
