<?php

declare(strict_types=1);
// admin/partials/expire-normalize.php
if (!function_exists('__normalize_expire')) {
  function __normalize_expire($s) {
    $s = trim((string)$s);
    if ($s === '' || strtolower($s) === 'null') { return null; }
    // Accept HTML5 datetime-local (YYYY-MM-DDTHH:MM[:SS]) or 'YYYY-MM-DD HH:MM[:SS]' or 'dd/mm/yyyy hh:mm[:ss]'
    $s = str_replace('T', ' ', $s);
    // Try dd/mm/yyyy first
    if (preg_match('~^(\d{2})/(\d{2})/(\d{4})\s+(\d{2}):(\d{2})(?::(\d{2}))?$~', $s, $m)) {
      $s = sprintf('%04d-%02d-%02d %02d:%02d:%02d', $m[3], $m[2], $m[1], $m[4], $m[5], isset($m[6])?$m[6]:0);
    }
    try {
      $dt = new DateTime($s);
      return $dt->format('Y-m-d H:i:s');
    } catch (Throwable $e) {
      return null;
    }
  }
}
