<?php

declare(strict_types=1);
// /admin/twofa_log.php
if (!function_exists('twofa_log')) {
  function twofa_log(string $type, string $email = '', array $meta = []): void {
    $dir = __DIR__ . '/logs';
    if (!is_dir($dir)) @mkdir($dir, 0755, true);
    $line = date('c') . " [$type]" .
            ($email !== '' ? " email=$email" : "") .
            (empty($meta) ? "" : " meta=" . json_encode($meta, JSON_UNESCAPED_SLASHES)) .
            PHP_EOL;
    @file_put_contents($dir . '/2fa.log', $line, FILE_APPEND);
  }
}