<?php
require_once __DIR__ . '/../controller/header.php';
require_once __DIR__ . '/../controller/sidebar.php';
?>
<style>
  /* 2FA: alinhar o bloco superior (instruções + botão) à esquerda */
  .page-container .content .container-fluid .text-right { 
    text-align: left !important; 
  }
  /* evita que o botão fique "flutuando" à direita nesse bloco */
  .page-container .content .container-fluid .text-right .btn {
    float: none !important;
  }
</style>
<?php
/* =========================
   Helpers locais (sem colisões)
   ========================= */
if (!function_exists('__build_otpauth_uri')) {
  function __build_otpauth_uri(string $email, string $secret, ?string $issuer = null): string {
    $issuer = $issuer ?: (defined('APP_NAME_FOR_TOTP') ? APP_NAME_FOR_TOTP : 'Cupons NDMidia');
    $label  = rawurlencode($issuer) . ':' . rawurlencode($email ?: 'user@example.com');
    $params = http_build_query([
      'secret'    => preg_replace('/\s+/', '', $secret),
      'issuer'    => $issuer,
      'algorithm' => 'SHA1',
      'digits'    => 6,
      'period'    => 30,
    ]);
    return "otpauth://totp/{$label}?{$params}";
  }
}

if (!function_exists('__qr_external_url')) {
  function __qr_external_url(string $otpauth, int $size = 220): string {
    $size = max(120, min(512, $size));
    return 'https://chart.googleapis.com/chart?chs=' . $size . 'x' . $size . '&cht=qr&chl=' . urlencode($otpauth);
  }
}

if (!function_exists('__http_get_binary')) {
  function __http_get_binary(string $url, int $timeout = 6): ?string {
    // cURL primeiro
    if (function_exists('curl_init')) {
      $ch = curl_init($url);
      curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT        => $timeout,
        CURLOPT_CONNECTTIMEOUT => $timeout,
        CURLOPT_SSL_VERIFYPEER => true,
        CURLOPT_SSL_VERIFYHOST => 2,
        CURLOPT_USERAGENT      => '2FA-QR/1.0'
      ]);
      $bin  = curl_exec($ch);
      $code = (int) curl_getinfo($ch, CURLINFO_HTTP_CODE);
      curl_close($ch);
      if ($code === 200 && $bin !== false) return $bin;
    }
    // fallback file_get_contents
    if (ini_get('allow_url_fopen')) {
      $ctx = stream_context_create(['http' => ['timeout' => $timeout, 'header' => "User-Agent: 2FA-QR/1.0\r\n"]]);
      $bin = @file_get_contents($url, false, $ctx);
      if ($bin !== false) return $bin;
    }
    return null;
  }
}

if (!function_exists('__qr_png_data_uri')) {
  function __qr_png_data_uri(string $otpauth, int $size = 220): ?string {
    $size = max(120, min(512, $size));

    // 1) Google Charts
    $u1 = 'https://chart.googleapis.com/chart?chs=' . $size . 'x' . $size . '&cht=qr&chl=' . urlencode($otpauth) . '&chld=M|0';
    $png = __http_get_binary($u1);

    // 2) Fallback público
    if (!$png) {
      $u2 = 'https://api.qrserver.com/v1/create-qr-code/?size=' . $size . 'x' . $size . '&data=' . urlencode($otpauth);
      $png = __http_get_binary($u2);
    }

    return $png ? ('data:image/png;base64,' . base64_encode($png)) : null;
  }
}

/* =========================
   Coleta de dados da view
   ========================= */
$twofa_ok  = isset($__twofa['ok'])   ? $__twofa['ok']   : '';
$twofa_err = isset($__twofa['err'])  ? $__twofa['err']  : '';
$enabled   = isset($__twofa['enabled']) ? (bool)$__twofa['enabled'] : false;

$issuer = defined('APP_NAME_FOR_TOTP') ? APP_NAME_FOR_TOTP : 'Cupons NDMidia';
$email  = $_SESSION['user_email'] ?? ($user['user_email'] ?? '');
$secret = '';

if (!empty($__twofa['secret']))                  $secret = $__twofa['secret'];
elseif (!empty($setupData['secret']))            $secret = $setupData['secret'];
elseif (!empty($twofa_secret))                   $secret = $twofa_secret;
elseif (!empty($user['twofa_secret']))           $secret = $user['twofa_secret'];
elseif (!empty($_SESSION['twofa_setup_secret'])) $secret = $_SESSION['twofa_setup_secret'];

// Se não tem segredo ainda, tenta gerar apenas para exibir QR/segredo
if (!$secret && function_exists('twofa_generate_secret')) {
  $secret = twofa_generate_secret();
  $_SESSION['twofa_setup_secret'] = $secret;
}

$reveal = (isset($_GET['reveal']) && $_GET['reveal'] == '1') || (isset($_GET['show']) && $_GET['show'] == '1');
?>
<section class="page-container">
  <div class="page-content-wrapper">
    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h4>Segurança: Autenticação em Duas Etapas (2FA)</h4>
            </div>
          </div>

          <div class="col-12 c-col-12">

            <?php if ($twofa_ok): ?>
              <div class="alert alert-success"><?php echo htmlspecialchars($twofa_ok); ?></div>
            <?php endif; ?>

            <?php if ($twofa_err): ?>
              <div class="alert alert-danger"><?php echo htmlspecialchars($twofa_err); ?></div>
            <?php endif; ?>

            <div class="block form-block mb-4" style="margin-top:10px;">
              <div class="p-3">

                <!-- Instruções 1/2/3 com texto à esquerda -->
                <ol style="padding-left:18px; list-style-position:outside; margin-bottom:12px;">
                  <li>Instale um app autenticador (Google/Microsoft Authenticator, 1Password, etc.).</li>
                  <li><strong>Opcional:</strong> clique em <em>“Mostrar QR / Segredo”</em> para escanear o QR ou anotar o segredo manualmente.</li>
                  <li>Depois, digite abaixo o código de 6 dígitos que o app gerar e clique em <em>Ativar 2FA</em>.</li>
                </ol>

                <div class="mb-3">
                  <a class="btn btn-secondary" href="./2fa-setup.php?reveal=1">Mostrar QR / Segredo</a>
                </div>

                <?php if ($reveal): ?>
                  <div class="card p-3 mb-3" style="max-width:520px;">
                    <?php if ($secret): ?>
                      <?php
                        $otpauth = __build_otpauth_uri($email, $secret, $issuer);
                        // Tenta embutir o PNG como data URI (evita bloqueio de domínio externo)
                        $img_src = __qr_png_data_uri($otpauth, 220);
                        if (!$img_src) {
                          // Último recurso: usar URL externa mesmo
                          $img_src = __qr_external_url($otpauth, 220);
                        }
                      ?>
                      <div class="mb-2">
                        <img src="<?php echo htmlspecialchars($img_src, ENT_QUOTES, 'UTF-8'); ?>" alt="QR 2FA" style="max-width:220px;">
                      </div>
                      <div class="small">
                        <strong>Segredo:</strong> <code><?php echo htmlspecialchars($secret, ENT_QUOTES, 'UTF-8'); ?></code><br>
                        Tipo: TOTP (Time-based), dígitos: 6, intervalo: 30s. Emissor: <code><?php echo htmlspecialchars($issuer, ENT_QUOTES, 'UTF-8'); ?></code>.
                      </div>
                    <?php else: ?>
                      <div class="alert alert-warning mb-0">
                        Segredo 2FA não encontrado. Gere/salve o segredo e recarregue esta página com <code>?reveal=1</code>.
                      </div>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>

                <form method="post" class="mb-2">
                  <input type="hidden" name="activate" value="1">
                  <div class="form-group">
                    <label for="code">Código do app autenticador</label>
                    <input type="text"
                           id="code"
                           name="code"
                           class="form-control"
                           inputmode="numeric"
                           pattern="\d{6}"
                           maxlength="6"
                           placeholder="000000">
                  </div>
                  <button type="submit" class="btn btn-primary">Ativar 2FA</button>
                </form>

                <?php if ($enabled): ?>
                  <div class="alert alert-info mt-3">
                    2FA já está <strong>ativada</strong> para este usuário. No próximo login, será solicitado o código
                    (a menos que o dispositivo esteja marcado como confiável).
                  </div>
                <?php endif; ?>

              </div>
            </div>

          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<div class="scrollTop">
  <span><a href=""><i class="dripicons-arrow-thin-up"></i></a></span>
</div>

<?php require_once __DIR__ . '/../controller/footer.php'; ?>