<?php
require_once __DIR__ . '/../controller/header.php';
require_once __DIR__ . '/../controller/sidebar.php';
$addon_orders = isset($addon_orders) && is_array($addon_orders) ? $addon_orders : [];

function nd_badge_class(string $status): string {
  $s = strtolower(trim($status));
  if ($s === 'active') return 'success';
  if ($s === 'pending_activation') return 'warning';
  if ($s === 'pending_payment') return 'secondary';
  if ($s === 'expired') return 'dark';
  if ($s === 'canceled') return 'danger';
  return 'info';
}

function nd_status_label(string $status): string {
  $s = strtolower(trim($status));
  return match ($s) {
    'pending_payment' => 'Pendente de pagamento',
    'pending_activation' => 'Pendente de ativação',
    'active' => 'Ativo',
    'expired' => 'Expirado',
    'canceled' => 'Cancelado',
    default => $status,
  };
}
?>

<div class="content p-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <h3 class="mb-0">Add-ons (Operação)</h3>
      <small class="text-muted">Gerencie ativações, datas e exclusividades de campanhas vendidas.</small>
    </div>
  </div>

  <div class="table-responsive">
    <table class="table table-striped table-hover align-middle">
      <thead>
        <tr>
          <th style="width:70px;">ID</th>
          <th>Anunciante</th>
          <th>Add-on</th>
          <th style="width:110px;">Valor</th>
          <th>Loja</th>
          <th style="width:170px;">Status</th>
          <th style="width:190px;">Vigência</th>
          <th style="width:120px;">Ações</th>
        </tr>
      </thead>
      <tbody>
      <?php if (!$addon_orders): ?>
        <tr>
          <td colspan="8" class="text-center text-muted py-4">Nenhum add-on encontrado.</td>
        </tr>
      <?php else: ?>
        <?php foreach($addon_orders as $o): ?>
          <?php
            $status = (string)($o['status'] ?? '');
            $badge = nd_badge_class($status);
            $start = (string)($o['start_date'] ?? '');
            $end   = (string)($o['end_date'] ?? '');
            $range = '-';
            if ($start || $end) {
              $range = trim(($start ?: '—') . ' → ' . ($end ?: '—'));
            }
          ?>
          <tr>
            <td><?php echo (int)($o['id'] ?? 0); ?></td>
            <td>
              <a href="./edit_user.php?id=<?php echo (int)($o['user_id'] ?? 0); ?>">
                <?php echo htmlspecialchars((string)($o['user_email'] ?? $o['user_name'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>
              </a>
            </td>
            <td><?php echo htmlspecialchars((string)($o['addon_title'] ?? $o['addon_key'] ?? ''), ENT_QUOTES, 'UTF-8'); ?></td>
            <td>R$ <?php echo htmlspecialchars((string)($o['amount_total'] ?? '0.00'), ENT_QUOTES, 'UTF-8'); ?></td>
            <td><?php echo htmlspecialchars((string)($o['store_title'] ?? '-'), ENT_QUOTES, 'UTF-8'); ?></td>
            <td>
              <span class="badge bg-<?php echo $badge; ?>">
                <?php echo htmlspecialchars(nd_status_label($status), ENT_QUOTES, 'UTF-8'); ?>
              </span>
            </td>
            <td><?php echo htmlspecialchars($range, ENT_QUOTES, 'UTF-8'); ?></td>
            <td>
              <a class="btn btn-sm btn-primary" href="./edit_addon.php?id=<?php echo (int)($o['id'] ?? 0); ?>">Gerenciar</a>
            </td>
          </tr>
        <?php endforeach; ?>
      <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
