<?php
require_once __DIR__ . '/../controller/header.php';
require_once __DIR__ . '/../controller/sidebar.php';
?>

<?php
// Helpers de QR Code (reutilizando o conceito do 2FA, mas para URLs genéricas)
if (!function_exists('__qr_external_url')) {
  function __qr_external_url(string $text, int $size = 220): string {
    $size = max(120, min(512, $size));
    return 'https://chart.googleapis.com/chart?chs=' . $size . 'x' . $size . '&cht=qr&chl=' . urlencode($text);
  }
}

if (!function_exists('__http_get_binary')) {
  function __http_get_binary(string $url, int $timeout = 6): ?string {
    if (function_exists('curl_init')) {
      $ch = curl_init($url);
      curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT        => $timeout,
        CURLOPT_CONNECTTIMEOUT => $timeout,
        CURLOPT_SSL_VERIFYPEER => true,
        CURLOPT_SSL_VERIFYHOST => 2,
        CURLOPT_USERAGENT      => 'Assoc-QR/1.0'
      ]);
      $bin  = curl_exec($ch);
      $code = (int) curl_getinfo($ch, CURLINFO_HTTP_CODE);
      curl_close($ch);
      if ($code === 200 && $bin !== false) return $bin;
    }
    // Fallback stream
    $ctx = stream_context_create([
      'http' => [
        'timeout' => $timeout,
        'header'  => "User-Agent: Assoc-QR/1.0\r\n"
      ]
    ]);
    $bin = @file_get_contents($url, false, $ctx);
    return ($bin !== false) ? $bin : null;
  }
}

if (!function_exists('__qr_png_data_uri')) {
  function __qr_png_data_uri(string $text, int $size = 220): ?string {
    $size = max(120, min(512, $size));
    // usa o mesmo endpoint de QR do Google Charts
    $url  = 'https://chart.googleapis.com/chart?chs=' . $size . 'x' . $size . '&cht=qr&chl=' . urlencode($text);
    $png  = __http_get_binary($url, 6);
    return $png ? ('data:image/png;base64,' . base64_encode($png)) : null;
  }
}

// Monta link do QR para este associado
$qr_text = '';
$qr_img  = null;

if (!empty($associate['associate_code'])) {
  $qr_text = rtrim(SITE_URL, '/') . '/qr.php?code=' . urlencode((string)$associate['associate_code']);
  $qr_img  = __qr_png_data_uri($qr_text, 220);
  if (!$qr_img) {
    $qr_img = __qr_external_url($qr_text, 220);
  }
}

// Prepara dados do gráfico (labels e valores)
$chartLabels = array();
$chartValues = array();
if (!empty($clicksByDay)) {
  foreach ($clicksByDay as $row) {
    $chartLabels[] = isset($row['day']) ? (string)$row['day'] : '';
    $chartValues[] = isset($row['total']) ? (int)$row['total'] : 0;
  }
}
?>

<section class="page-container">
  <div class="page-content-wrapper">

    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">

        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h5>Detalhes do associado</h5>
              <p class="text-muted">
                Visualize o desempenho deste parceiro de mídia (cliques por dia) e o QR Code de divulgação.
              </p>
            </div>
          </div>
        </div>

        <div class="row mb-3">
          <div class="col-md-6 col-12">
            <div class="card card-stats mb-3">
              <div class="card-body">
                <h6>Dados do associado</h6>
                <p class="mb-1"><strong>ID:</strong> <?php echo (int)$associate['associate_id']; ?></p>
                <p class="mb-1"><strong>Nome:</strong> <?php echo htmlspecialchars((string)$associate['associate_name'], ENT_QUOTES, 'UTF-8'); ?></p>
                <p class="mb-1"><strong>E-mail:</strong> <?php echo htmlspecialchars((string)$associate['associate_email'], ENT_QUOTES, 'UTF-8'); ?></p>
                <p class="mb-1"><strong>Telefone:</strong> <?php echo htmlspecialchars((string)$associate['associate_phone'], ENT_QUOTES, 'UTF-8'); ?></p>
                <p class="mb-1"><strong>Cidade / UF:</strong>
                  <?php 
                    $city  = (string)($associate['associate_city'] ?? '');
                    $state = (string)($associate['associate_state'] ?? '');
                    echo htmlspecialchars(trim($city . ' / ' . $state), ENT_QUOTES, 'UTF-8');
                  ?>
                </p>
                <p class="mb-1"><strong>Grupo:</strong>
                  <?php 
                    $grp = isset($associate['associate_group']) ? (string)$associate['associate_group'] : '';
                    echo htmlspecialchars($grp, ENT_QUOTES, 'UTF-8');
                  ?>
                </p>
                <p class="mb-1"><strong>Código:</strong> <?php echo htmlspecialchars((string)$associate['associate_code'], ENT_QUOTES, 'UTF-8'); ?></p>
                <p class="mb-1"><strong>Status:</strong>
                  <?php if ((int)$associate['associate_status'] === 1): ?>
                    <span class="badge badge-pill bg-success"><i class="dripicons-checkmark"></i> Ativo</span>
                  <?php else: ?>
                    <span class="badge badge-pill bg-danger"><i class="dripicons-cross"></i> Inativo</span>
                  <?php endif; ?>
                </p>
                <p class="mb-1"><strong>Criado em:</strong> <?php echo htmlspecialchars((string)$associate['associate_created'], ENT_QUOTES, 'UTF-8'); ?></p>
                <?php if (!empty($associate['associate_updated'])): ?>
                  <p class="mb-1"><strong>Atualizado em:</strong> <?php echo htmlspecialchars((string)$associate['associate_updated'], ENT_QUOTES, 'UTF-8'); ?></p>
                <?php endif; ?>
              </div>
            </div>
          </div>

          <div class="col-md-6 col-12">
            <div class="card card-stats mb-3 text-center">
              <div class="card-body">
                <h6>QR Code do associado</h6>
                <?php if ($qr_img && $qr_text): ?>
                  <div class="mb-2">
                    <img src="<?php echo htmlspecialchars($qr_img, ENT_QUOTES, 'UTF-8'); ?>" alt="QR do associado" style="max-width:220px;">
                  </div>
                  <div class="small">
                    <strong>URL do QR:</strong><br>
                    <code style="word-break:break-all;"><?php echo htmlspecialchars($qr_text, ENT_QUOTES, 'UTF-8'); ?></code>
                  </div>
                <?php else: ?>
                  <div class="alert alert-warning mb-0">
                    Não foi possível gerar o QR Code. Verifique se este associado possui um código cadastrado.
                  </div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>

        <div class="row mb-3">
          <div class="col-12">
            <div class="block table-block mb-4">
              <div class="block-heading mb-3">
                <h6 class="font-weight-bold">Cliques por dia (últimos 30 dias)</h6>
              </div>
              <div class="p-3">
                <?php if (!empty($chartLabels)): ?>
                  <canvas id="assocClicksChart" height="120"></canvas>
                <?php else: ?>
                  <div class="alert alert-info mb-0">
                    Ainda não há cliques registrados para este associado no período analisado.
                  </div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>

        <div class="row mb-3">
          <div class="col-12">
            <a href="./associates.php" class="btn btn-secondary">
              <i class="fa fa-arrow-left"></i> Voltar para lista de associados
            </a>
            <a href="../controller/edit_associate.php?id=<?php echo (int)$associate['associate_id']; ?>" class="btn btn-primary">
              <i class="fa fa-edit"></i> Editar associado
            </a>
          </div>
        </div>

      </div>
    </div>
  </div>
</section>

<?php require_once __DIR__ . '/../controller/footer.php'; ?>

<script type="text/javascript">
document.addEventListener('DOMContentLoaded', function () {
  var ctx = document.getElementById('assocClicksChart');
  if (!ctx) return;

  var labels = <?php echo json_encode($chartLabels ?: array()); ?>;
  var data   = <?php echo json_encode($chartValues ?: array()); ?>;

  if (!labels.length) return;

  var assocChart = new Chart(ctx, {
    type: 'line',
    data: {
      labels: labels,
      datasets: [{
        label: 'Cliques por dia',
        data: data,
        fill: false,
        borderColor: '#18BCC9',
        borderWidth: 2,
        pointRadius: 3,
        lineTension: 0
      }]
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,
      scales: {
        xAxes: [{
          ticks: {
            autoSkip: true,
            maxTicksLimit: 10
          }
        }],
        yAxes: [{
          ticks: {
            beginAtZero: true,
            precision: 0
          }
        }]
      },
      tooltips: {
        mode: 'index',
        intersect: false
      },
      hover: {
        mode: 'nearest',
        intersect: true
      }
    }
  });
});
</script>
