<?php
require_once __DIR__ . '/../controller/header.php';
require_once __DIR__ . '/../controller/sidebar.php';
?>

<section class="page-container">
  <div class="page-content-wrapper">

    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">

        <div class="row">
          <div class="col-12">
            <div class="section-title d-flex justify-content-between align-items-center">
              <div>
                <h5>Ranking de associados</h5>
                <p class="text-muted mb-0">
                  Associados com mais acessos no mês atual (<?php echo htmlspecialchars($monthLabel, ENT_QUOTES, 'UTF-8'); ?>).
                </p>
              </div>
              <div>
                <a href="./associates.php" class="btn btn-secondary">
                  <i class="fa fa-arrow-left"></i> Voltar para lista
                </a>
              </div>
            </div>
          </div>
        </div>

        <div class="row mb-3">
          <div class="col-12">
            <div class="block table-block mb-4">
              <div class="table-responsive">
                <table class="table table-striped table-bordered" cellspacing="0" width="100%">
                  <thead>
                    <tr>
                      <th style="width:6%;">Posição</th>
                      <th>Nome</th>
                      <th>Cidade / UF</th>
                      <th>Grupo</th>
                      <th>Código</th>
                      <th style="width:12%;">Cliques no mês</th>
                      <th style="width:12%;">Total de cliques</th>
                      <th style="width:12%;">Status</th>
                      <th style="width:10%;">Detalhes</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php if (!empty($ranking)): ?>
                      <?php 
                        $pos = 0;
                        foreach ($ranking as $row): 
                          $pos++;
                          $city  = (string)($row['associate_city'] ?? '');
                          $state = (string)($row['associate_state'] ?? '');
                          $totalLifetime = associate_clicks_total($row['associate_id']);
                      ?>
                        <tr>
                          <td class="text-center">
                            <?php if ($pos === 1): ?>
                              🥇
                            <?php elseif ($pos === 2): ?>
                              🥈
                            <?php elseif ($pos === 3): ?>
                              🥉
                            <?php else: ?>
                              <?php echo (int)$pos; ?>
                            <?php endif; ?>
                          </td>
                          <td><?php echo htmlspecialchars((string)$row['associate_name'], ENT_QUOTES, 'UTF-8'); ?></td>
                          <td><?php echo htmlspecialchars(trim($city . ' / ' . $state), ENT_QUOTES, 'UTF-8'); ?></td>
                          <td>
                            <?php 
                              $grp = isset($row['associate_group']) ? (string)$row['associate_group'] : '';
                              echo htmlspecialchars($grp, ENT_QUOTES, 'UTF-8');
                            ?>
                          </td>
                          <td><?php echo htmlspecialchars((string)$row['associate_code'], ENT_QUOTES, 'UTF-8'); ?></td>
                          <td class="text-center">
                            <?php echo number_format((int)$row['total_clicks_month'], 0, ',', '.'); ?>
                          </td>
                          <td class="text-center">
                            <?php echo number_format((int)$totalLifetime, 0, ',', '.'); ?>
                          </td>
                          <td class="text-center">
                            <?php if ((int)$row['associate_status'] === 1): ?>
                              <span class="badge badge-pill bg-success">
                                <i class="dripicons-checkmark"></i> Ativo
                              </span>
                            <?php else: ?>
                              <span class="badge badge-pill bg-danger">
                                <i class="dripicons-cross"></i> Inativo
                              </span>
                            <?php endif; ?>
                          </td>
                          <td class="text-center">
                            <a href="../controller/associate_details.php?id=<?php echo (int)$row['associate_id']; ?>" class="btn btn-sm btn-info">
                              <i class="fa fa-eye"></i>
                            </a>
                          </td>
                        </tr>
                      <?php endforeach; ?>
                    <?php else: ?>
                      <tr>
                        <td colspan="8" class="text-center">
                          Ainda não há dados de cliques para este mês.
                        </td>
                      </tr>
                    <?php endif; ?>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>

      </div>
    </div>

  </div>
</section>

<?php require_once __DIR__ . '/../controller/footer.php'; ?>
