<?php
require_once __DIR__ . '/../controller/header.php'; ?>
<?php require_once __DIR__ . '/../controller/sidebar.php'; ?>  

<script type="text/javascript">
  $(document).ready(function(){
    $('#table_id').dataTable({
      "responsive": true,
      "bPaginate": true,
      "sPaginationType": "full_numbers",
      "iDisplayLength": 10
    });
  });
</script>

<section class="page-container">
  <div class="page-content-wrapper">

    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">

        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h5>Associados</h5>
              <p class="text-muted">
                Rede de parceiros de mídia (motoristas, táxis, vans) que divulgam os QR Codes.
              </p>
            </div>
          </div>
        </div>

        <div class="row mb-3">
          <div class="col-md-4 col-12">
            <div class="card card-stats">
              <div class="card-body">
                <h6>Total de associados</h6>
                <h3>
                  <?php echo number_format((int)associates_total(), 0, ',', '.'); ?>
                </h3>
              </div>
            </div>
          </div>
        </div>

        <div class="row">
          <div class="col-12 c-col-12">
            <a class="btn btn-primary" href="../controller/new_associate.php">
              <i class="fa fa-plus add-new-i"></i> Cadastrar associado
            </a>
            <a class="btn btn-outline-info" href="../controller/associates_ranking.php" style="margin-left:8px;">
              <i class="fa fa-trophy"></i> Ranking de associados
            </a>
          </div>

          <div class="col-12">
            <div class="block table-block mb-4 c-4">
              <div class="row">
                <div class="table-responsive">
                  <table id="table_id" class="table table-striped table-bordered" cellspacing="0" width="100%">
                    <thead>
                      <tr>
                        <th style="width:5%;"><?php echo _TABLEFIELDID; ?></th>
                        <th>Nome</th>
                        <th>E-mail</th>
                        <th>Telefone</th>
                        <th>Cidade / UF</th>
                        <th>Grupo</th>
                        <th>Código</th>
                        <th>Cliques</th>
                        <th>Último clique</th>
                        <th style="width:8%;">Status</th>
                        <th style="width:12%;">Criado em</th>
                        <th style="width:12%;">Ações</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php if (!empty($associates)): ?>
                        <?php foreach ($associates as $a): ?>
                          <tr>
                            <td class="text-center"><?php echo (int)$a['associate_id']; ?></td>
                            <td><?php echo htmlspecialchars($a['associate_name'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?php echo htmlspecialchars((string)$a['associate_email'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?php echo htmlspecialchars((string)$a['associate_phone'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td>
                              <?php 
                                $city  = (string)$a['associate_city'];
                                $state = (string)$a['associate_state'];
                                echo htmlspecialchars(trim($city . ' / ' . $state), ENT_QUOTES, 'UTF-8');
                              ?>
                            </td>
                            <td>
                              <?php 
                                $grp = isset($a['associate_group']) ? (string)$a['associate_group'] : '';
                                echo htmlspecialchars($grp, ENT_QUOTES, 'UTF-8');
                              ?>
                            </td>
                            <td><?php echo htmlspecialchars((string)$a['associate_code'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td class="text-center">
                              <?php echo number_format((int)associate_clicks_total($a['associate_id']), 0, ',', '.'); ?>
                            </td>
                            <td>
                              <?php 
                                $lastClick = associate_last_click($a['associate_id']);
                                echo $lastClick ? htmlspecialchars((string)$lastClick, ENT_QUOTES, 'UTF-8') : '-';
                              ?>
                            </td>
                            <td class="text-center">
                              <?php if ((int)$a['associate_status'] === 1): ?>
                                <span class="badge badge-pill bg-success">
                                  <i class="dripicons-checkmark"></i>
                                </span>
                              <?php else: ?>
                                <span class="badge badge-pill bg-danger">
                                  <i class="dripicons-cross"></i>
                                </span>
                              <?php endif; ?>
                            </td>
                            <td>
                              <?php echo htmlspecialchars((string)$a['associate_created'], ENT_QUOTES, 'UTF-8'); ?>
                            </td>
                            <td class="text-center">
                              <a class="btn btn-sm btn-info" href="../controller/associate_details.php?id=<?php echo (int)$a['associate_id']; ?>">
                                <i class="fa fa-eye"></i>
                              </a>
                              <a class="btn btn-sm btn-primary" href="../controller/edit_associate.php?id=<?php echo (int)$a['associate_id']; ?>">
                                <i class="fa fa-edit"></i>
                              </a>
                              <?php if ((int)$a['associate_status'] === 1): ?>
                                <a class="btn btn-sm btn-warning" href="../controller/associate_status.php?id=<?php echo (int)$a['associate_id']; ?>&status=0">
                                  <i class="dripicons-cross"></i>
                                </a>
                              <?php else: ?>
                                <a class="btn btn-sm btn-success" href="../controller/associate_status.php?id=<?php echo (int)$a['associate_id']; ?>&status=1">
                                  <i class="dripicons-checkmark"></i>
                                </a>
                              <?php endif; ?>
                            </td>
                          </tr>
                        <?php endforeach; ?>
                      <?php endif; ?>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>

        </div>

      </div>
    </div>
  </div>
</section>

<?php require_once __DIR__ . '/../controller/footer.php'; ?>
