<?php
/**
 * ND Reports View (v3) - visual refinado + compatibilidade
 * Este arquivo é "auto-contido": se as variáveis não existirem, ele não quebra.
 * Possíveis arrays aceitos: $reports, $rows, $list, $_ND_REPORTS
 */
$__nd_reports = $reports ?? $rows ?? $list ?? ($_ND_REPORTS ?? []);
$__status_map = [
    'open'     => ['label' => 'OPEN',          'class' => 'nd-badge nd-badge-open'],
    'progress' => ['label' => 'EM ANDAMENTO',  'class' => 'nd-badge nd-badge-progress'],
    'closed'   => ['label' => 'FECHADO',       'class' => 'nd-badge nd-badge-closed'],
    'OPEN'     => ['label' => 'OPEN',          'class' => 'nd-badge nd-badge-open'],
    'IN_PROGRESS' => ['label' => 'EM ANDAMENTO','class' => 'nd-badge nd-badge-progress'],
    'CLOSED'   => ['label' => 'FECHADO',       'class' => 'nd-badge nd-badge-closed'],
];

function nd_h($s){ return htmlspecialchars((string)$s ?? '', ENT_QUOTES, 'UTF-8'); }
?>
<!-- nd-view: deal_reports.view.php v3 -->
<link rel="stylesheet" href="../assets/css/nd-reports.css?v=3" />
<div id="nd-deal-reports" class="nd-reports-container">
<?php if (empty($__nd_reports)): ?>
    <div class="nd-empty">
        <strong>ND Reports View carregada.</strong>
        <div>Não encontrei registros no array fornecido (tente $reports, $rows, $list ou $_ND_REPORTS).</div>
    </div>
<?php else: ?>
    <div class="nd-table-wrap">
        <table class="nd-table">
            <thead>
                <tr>
                    <th>Oferta</th>
                    <th>Motivo / Detalhes</th>
                    <th>Origem</th>
                    <th>Status</th>
                    <th>Criado</th>
                    <th class="nd-col-actions">Ações</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($__nd_reports as $r): 
                    $deal_id   = $r['deal_id']   ?? $r['id_oferta'] ?? $r['oferta_id'] ?? null;
                    $deal_tit  = $r['deal_title']?? $r['oferta_titulo'] ?? $r['titulo'] ?? ('#' . (string)($deal_id ?? ''));
                    $reason    = $r['reason_label'] ?? $r['reason'] ?? $r['motivo_label'] ?? $r['motivo'] ?? '—';
                    $details   = $r['details'] ?? $r['detalhes'] ?? '';
                    $ip        = $r['ip'] ?? $r['ip_address'] ?? '';
                    $ua        = $r['user_agent'] ?? $r['ua'] ?? '';
                    $status    = $r['status'] ?? 'open';
                    $created   = $r['created_at'] ?? $r['created'] ?? $r['criado'] ?? '';
                    $notes     = $r['notes'] ?? $r['admin_notes'] ?? '';
                    $row_id    = $r['id'] ?? $r['report_id'] ?? null;

                    $st        = $__status_map[$status] ?? $__status_map[strtoupper($status)] ?? ['label'=>$status,'class'=>'nd-badge'];
                ?>
                <tr>
                    <td class="nd-offer">
                        <div class="nd-offer-title">
                            <div class="nd-offer-name"><?php echo nd_h($deal_tit); ?></div>
                            <?php if (!empty($deal_id)): ?>
                                <a class="nd-link" target="_blank" href="/?deal_id=<?php echo (int)$deal_id; ?>">ABRIR PÁGINA</a>
                            <?php endif; ?>
                        </div>
                    </td>
                    <td class="nd-reason">
                        <div class="nd-reason-title"><?php echo nd_h($reason); ?></div>
                        <?php if (trim((string)$details) !== ''): ?>
                            <div class="nd-reason-details"><?php echo nl2br(nd_h($details)); ?></div>
                        <?php endif; ?>
                    </td>
                    <td class="nd-origin">
                        <?php if ($ip): ?><div class="nd-ip">IP: <?php echo nd_h($ip); ?></div><?php endif; ?>
                        <?php if ($ua): ?><div class="nd-ua">UA: <?php echo nd_h($ua); ?></div><?php endif; ?>
                    </td>
                    <td class="nd-status">
                        <span class="<?php echo nd_h($st['class']); ?>"><?php echo nd_h($st['label']); ?></span>
                    </td>
                    <td class="nd-created">
                        <?php echo nd_h($created); ?>
                    </td>
                    <td class="nd-actions">
                        <form method="post" action="" class="nd-actions-form">
                            <?php if ($row_id !== null): ?>
                                <input type="hidden" name="id" value="<?php echo (int)$row_id; ?>"/>
                            <?php endif; ?>
                            <select name="status" class="nd-select">
                                <option value="open"     <?php echo ($status==='open' || strtoupper($status)==='OPEN')?'selected':''; ?>>Aberto</option>
                                <option value="progress" <?php echo ($status==='progress' || strtoupper($status)==='IN_PROGRESS')?'selected':''; ?>>Em andamento</option>
                                <option value="closed"   <?php echo ($status==='closed' || strtoupper($status)==='CLOSED')?'selected':''; ?>>Fechado</option>
                            </select>
                            <textarea name="notes" class="nd-notes" placeholder="Notas"><?php echo nd_h($notes); ?></textarea>
                            <button type="submit" class="nd-btn">SALVAR</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>
</div>
