<?php
require_once __DIR__ . '/../controller/header.php';
require_once __DIR__ . '/../controller/sidebar.php';

// Fallbacks seguros caso as constantes não estejam definidas
$title = defined('_ACCESSDENIEDTITLE')
    ? _ACCESSDENIEDTITLE
    : 'Acesso negado';

$subtitle = defined('_ACCESSDENIEDSUBTITLE')
    ? _ACCESSDENIEDSUBTITLE
    : 'Você não tem permissão para acessar esta área.';
?>

<!--Page Container-->
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->
    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h4><?= htmlspecialchars($title, ENT_QUOTES, 'UTF-8'); ?></h4>
            </div>
          </div>

          <div class="col-12">
            <div class="block bg-trans table-block mb-4 pt-0">
              <p style="font-size: 16px;"><?= htmlspecialchars($subtitle, ENT_QUOTES, 'UTF-8'); ?></p>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div>
</section>

<?php require_once __DIR__ . '/../controller/footer.php'; ?>
