<?php
require_once __DIR__ . '/../controller/header.php'; ?>
<?php require_once __DIR__ . '/../controller/sidebar.php'; ?>

<!--Page Container--> 
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->

    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h5><?php echo _EDITITEM; ?></h5>
            </div>
          </div>

          <div class="col-md-12">

          <?php if(!empty($success)): ?>
          <div class="d-flex align-items-center alert alert-success" role="alert">
          <i class="icon dripicons-checkmark"></i> <?php echo $success; ?>
          </div>
          <?php endif; ?>

          <?php if(!empty($errors)): ?>
          <div class="alert alert-danger" role="alert">
          <ul>
          <?php foreach($errors as $key => $value):?>
          <li><?php echo $value; ?></li>
          <?php endforeach; ?>
          </ul>
          </div>
          <?php endif; ?>

            <div class="form-block mb-4">

                <form enctype="multipart/form-data" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>?id=<?php echo $category['category_id']; ?>" method="post">

               <input type="hidden" value="<?php echo $category['category_id']; ?>" name="category_id">

               <div class="form-row">
                <div class="form-group col-12 col-lg-9">
                  <div class="block col-md-12">

                    <label class="required"><?php echo _TABLEFIELDTITLE; ?></label>
                    <input type="text" value="<?php echo $category['category_title']; ?>" name="category_title" class="form-control">

                    <label><?php echo _TABLEFIELDSLUG; ?></label>
                    <input type="hidden" value="<?php echo $category['category_slug']; ?>" name="category_slug_save">
                    <input type="text" placeholder="<?php echo $category['category_slug']; ?>" name="category_slug" class="form-control">
                    
                    <label><?php echo _TABLEFIELDDESCRIPTION; ?></label>

                    <textarea type="text" class="mceNoEditor form-control" name="category_description"><?php echo $category['category_description']; ?></textarea>

                    <label><?php echo _ICON; ?></label>
                    <a href="https://tabler-icons.io/" target="_blank"><?php echo _SELECTICON; ?> <i class="dripicons-export"></i></a>
                    <input type="text" value="<?php echo $category['category_icon']; ?>" name="category_icon" class="form-control">



                    <label class="control-label"><?php echo _TABLEFIELDSHOWMENU; ?></label>
                    <select class="custom-select form-control" name="category_menu">
                      <?php
                      if($category['category_menu'] == 1)
                      {
                        echo '<option value="1" selected="selected">'._YESTEXT.'</option>';
                        echo '<option value="0">'._NOTEXT.'</option>';

                      }
                      else {
                        echo '<option value="0" selected="selected">'._NOTEXT.'</option>';
                        echo '<option value="1">'._YESTEXT.'</option>';
                      }
                      ?>
                    </select>

                    <label class="control-label"><?php echo _TABLEFIELDFEATURED; ?></label>
                    <select class="custom-select form-control" name="category_featured">
                      <?php
                      if($category['category_featured'] == 1)
                      {
                        echo '<option value="1" selected="selected">'._YESTEXT.'</option>';
                        echo '<option value="0">'._NOTEXT.'</option>';

                      }
                      else {
                        echo '<option value="0" selected="selected">'._NOTEXT.'</option>';
                        echo '<option value="1">'._YESTEXT.'</option>';
                      }
                      ?>
                    </select>
                    

                    <br>
                    <br>

                    <fieldset>
                      <legend><?php echo _SEO; ?></legend>

                      <label class="no-margin-top"><?php echo _SEOTITLE; ?></label>
                      <input type="text" value="<?php echo $category['category_seotitle']; ?>" name="category_seotitle" class="form-control">


                      <label><?php echo _SEODESCRIPTION; ?></label>
                      <textarea type="text" class="form-control" name="category_seodescription"><?php echo $category['category_seodescription']; ?></textarea>

                    </fieldset>

                  </div>
                </div>

                <div class="form-group col-12 col-lg-3 sidebar">

                 <div class="block col-md-12">
                   <label><?php echo _TABLEFIELDSTATUS; ?></label>

                   <select class="custom-select form-control" name="category_status">

                    <?php
                    if($category['category_status'] == 1){
                      echo '<option value="1" selected="selected">'._ENABLED.'</option>';
                      echo '<option value="0">'._DISABLED.'</option>';

                    } else{
                      echo '<option value="0" selected="selected">'._DISABLED.'</option>';
                      echo '<option value="1">'._ENABLED.'</option>';
                    }
                    ?>
                  </select>

                </div>

                <div class="block col-md-12">
                  <label><?php echo _TABLEFIELDIMAGE; ?></label>

                  <div class="new-image" id="image-preview" style="background: url(<?php echo $target_dir; ?><?php echo $category['category_image'] ?>);">
                    <label for="image-upload" id="image-label"><?php echo _CHOOSEFILE; ?></label>
                    <input type="hidden" value="<?php echo $category['category_image']; ?>" name="category_image_save">
                    <input type="file" name="category_image" accept=".jpg, .jpeg, .png, .gif" id="image-upload" />
                  </div>

                  <span class="text-danger recomendedsize"><?php echo _RECOMMENDEDSIZE; ?> <b>350 x 350</b> </span>
                  <br/>
                </div>

                <div class="block col-md-12">
                <button class="btn btn-primary" type="submit" name="save"><?php echo _UPDATEITEM; ?></button>
                <button class="btn btn-danger deleteItem" type="button" data-url="../controller/delete_category.php?id=<?php echo $category['category_id']; ?>" data-redirect="../controller/categories.php"><?php echo _DELETEITEM; ?></button>
                </div>

              </div>
            </div>

          </form>
        </div>
      </div>
    </div>
  </div>
</div>
</div>
</section>
<!-- NEW_CATEGORY_PTBR_INJECT -->
<script>
(function () {
  try {
    function run() {
      // 1) Tradução de rótulos, legendas, botões e pequenos textos
      document.querySelectorAll('label, legend, th, .section-title h4, .section-title h5, small, .btn').forEach(function (el) {
        var t = (el.textContent || '').trim();

        // “Recommended size: …” -> “Tamanho recomendado: …”
        if (/recommended size\s*:/i.test(t)) {
          el.textContent = t.replace(/recommended size\s*:\s*/i, 'Tamanho recomendado: ');
          return;
        }

        // Trocas diretas
        var map = {
          // campos comuns
          'Title': 'Título',
          'Slug': 'Slug',
          'Parent': 'Categoria Pai',
          'Description': 'Descrição',
          'Status': 'Status',
          'Featured': 'Destaque',
          'Order': 'Ordem',
          'Icon': 'Ícone',
          'Image': 'Imagem',
          'SEO': 'SEO',
          // botões/ações
          'Update': 'Atualizar',
          'Save': 'Salvar',
          'Create': 'Criar',
          'Add Category': 'Adicionar Categoria',
          'Delete': 'Excluir',
          'Choose File': 'Escolher arquivo'
        };
        if (map[t]) el.textContent = map[t];
      });

      // 2) Placeholders
      document.querySelectorAll('input[placeholder], textarea[placeholder]').forEach(function (el) {
        var ph = el.getAttribute('placeholder') || '';
        ph = ph
          .replace(/\bTitle\b/ig, 'Título')
          .replace(/\bSlug\b/ig, 'Slug')
          .replace(/\bDescription\b/ig, 'Descrição')
          .replace(/\bIcon\b/ig, 'Ícone');
        el.setAttribute('placeholder', ph);
      });

      // 3) Botões (innerText / value)
      document.querySelectorAll('button, input[type=submit]').forEach(function (btn) {
        var txt = (btn.innerText || btn.value || '').trim();
        if (/^Update$/i.test(txt)) { btn.innerText = 'Atualizar'; if (btn.value) btn.value = 'Atualizar'; }
        if (/^Save$/i.test(txt))   { btn.innerText = 'Salvar';    if (btn.value) btn.value = 'Salvar'; }
        if (/^Create$/i.test(txt)) { btn.innerText = 'Criar';     if (btn.value) btn.value = 'Criar'; }
        if (/^Delete$/i.test(txt)) { btn.innerText = 'Excluir';   if (btn.value) btn.value = 'Excluir'; }
      });

      // 4) Opções de <select>
      var optMap = {
        'Yes': 'Sim',
        'No': 'Não',
        'Hidden': 'Oculto',
        'Visible': 'Visível',
        'Enabled': 'Ativado',
        'Disabled': 'Desativado',
        'Active': 'Ativo',
        'Inactive': 'Inativo'
      };
      document.querySelectorAll('select option').forEach(function (opt) {
        var t = (opt.textContent || '').trim();
        if (optMap[t]) opt.textContent = optMap[t];
      });
    }

    run();
    // reaplica após um pequeno atraso se a UI re-renderizar algo
    setTimeout(run, 300);
  } catch (e) {
    console.error('NEW_CATEGORY_PTBR_INJECT error:', e);
  }
})();
</script>
<!-- /NEW_CATEGORY_PTBR_INJECT -->

<?php require_once __DIR__ . '/../controller/footer.php'; ?>

