<?php
require_once __DIR__ . '/../controller/header.php'; ?>
<?php require_once __DIR__ . '/../controller/sidebar.php'; ?>

<!--Page Container--> 
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Conteúdo-->

    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h5><?php echo _EDITITEM; ?></h5>
            </div>
          </div>

          <div class="col-md-12">

          <?php if(!empty($success)): ?>
          <div class="d-flex align-items-center alert alert-success" role="alert">
          <i class="icon dripicons-checkmark"></i> <?php echo $success; ?>
          </div>
          <?php endif; ?>

          <?php if(!empty($errors)): ?>
          <div class="alert alert-danger" role="alert">
          <ul>
          <?php foreach($errors as $key => $value):?>
          <li><?php echo $value; ?></li>
          <?php endforeach; ?>
          </ul>
          </div>
          <?php endif; ?>
          
            <div class="form-block mb-4">

              <form enctype="multipart/form-data" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>?id=<?php echo $page['page_id']; ?>" method="post">

               <input type="hidden" value="<?php echo $page['page_id']; ?>" name="page_id">

               <div class="form-row">
                <div class="form-group col-12 col-lg-9">
                  <div class="block col-md-12">

                    <label class="required"><?php echo _PAGETITLE; ?></label>
                    <input type="text" value="<?php echo $page['page_title']; ?>" name="page_title" class="form-control" required="">

                    <label><?php echo _TABLEFIELDSLUG; ?></label>
                    <div class="input-group">
                    <span class="input-group-addon"><?php echo SITE_URL . '/' ?></span>
                    <input type="hidden" value="<?php echo $page['page_slug']; ?>" name="page_slug_save">
                    <input type="text" placeholder="<?php echo $page['page_slug']; ?>" name="page_slug" class="form-control">
                    </div>
                    
                    <label><?php echo _PAGETEMPLATE; ?></label>
                    <?php if(is_default_page($page['page_id'])): ?>
                      <input type="hidden" name="page_template" value="<?php echo $page['page_template']; ?>" />
                    <?php endif; ?>
                    
                    <select class="custom-select form-control" id="single-select" data-selected="<?php echo $page['page_template']; ?>" name="page_template" <?php echo !(is_default_page($page['page_id'])) ? NULL : 'disabled' ?>>
                      <option value="blank"><?php echo _PAGEBLANK; ?></option>
                      <option value="search"><?php echo _PAGESEARCH; ?></option>
                      <option value="categories"><?php echo _PAGECATEGORIES; ?></option>
                      <option value="locations"><?php echo _PAGELOCATIONS; ?></option>
                      <option value="stores"><?php echo _PAGESTORES; ?></option>
                      <option value="contact"><?php echo _PAGECONTACT; ?></option>
                      <option value="terms"><?php echo _PAGETERMSCONDITIONS; ?></option>
                      <option value="privacy"><?php echo _PAGEPRIVACYPOLICY; ?></option>
                      <option value="pricing"><?php echo _PAGEPRICING; ?></option>
                    </select>

                    <?php echo !(is_default_page($page['page_id'])) ? NULL : "<small>"._CANTCHANGEPAGE." <a href='../controller/settings.php#pages'>"._CHANGESETTINGBTN."</a></small><br/>" ?>

                    <div class="row">
                      
                      <div class="col-6">
                        
                    <label><?php echo _PAGEFOOTER; ?></label>
                    <select class="custom-select form-control" name="page_show_footer">
                      <?php
                      if($page['page_show_footer'] == 1){
                        echo '<option value="1" selected="selected">'._YESTEXT.'</option>';
                        echo '<option value="0">'._NOTEXT.'</option>';
                      }
                      else{
                        echo '<option value="0" selected="selected">'._NOTEXT.'</option>';
                        echo '<option value="1">'._YESTEXT.'</option>';
                      }
                      ?>
                    </select>

                    <label><?php echo _PAGESHOWTITLE; ?></label>
                    <select class="custom-select form-control" name="page_show_title">
                      <?php
                      if($page['page_show_title'] == 1){
                        echo '<option value="1" selected="selected">'._YESTEXT.'</option>';
                        echo '<option value="0">'._NOTEXT.'</option>';
                      }
                      else{
                        echo '<option value="0" selected="selected">'._NOTEXT.'</option>';
                        echo '<option value="1">'._YESTEXT.'</option>';
                      }
                      ?>
                    </select>

                    <label><?php echo _PAGEHEADERAD; ?></label>
                    <select class="custom-select form-control" name="page_ad_header">
                      <?php
                      if($page['page_ad_header'] == 1){
                        echo '<option value="1" selected="selected">'._YESTEXT.'</option>';
                        echo '<option value="0">'._NOTEXT.'</option>';
                      }
                      else{
                        echo '<option value="0" selected="selected">'._NOTEXT.'</option>';
                        echo '<option value="1">'._YESTEXT.'</option>';
                      }
                      ?>
                    </select>

                      </div>

                      <div class="col-6">
                        
                    <label><?php echo _PAGEFOOTERAD; ?></label>
                    <select class="custom-select form-control" name="page_ad_footer">
                      <?php
                      if($page['page_ad_footer'] == 1){
                        echo '<option value="1" selected="selected">'._YESTEXT.'</option>';
                        echo '<option value="0">'._NOTEXT.'</option>';
                      }
                      else{
                        echo '<option value="0" selected="selected">'._NOTEXT.'</option>';
                        echo '<option value="1">'._YESTEXT.'</option>';
                      }
                      ?>
                    </select>

                    <label><?php echo _PAGESIDEBARAD; ?></label>
                    <select class="custom-select form-control" name="page_ad_sidebar">
                      <?php
                      if($page['page_ad_sidebar'] == 1){
                        echo '<option value="1" selected="selected">'._YESTEXT.'</option>';
                        echo '<option value="0">'._NOTEXT.'</option>';
                      }
                      else{
                        echo '<option value="0" selected="selected">'._NOTEXT.'</option>';
                        echo '<option value="1">'._YESTEXT.'</option>';
                      }
                      ?>
                    </select>

                      </div>


                    </div>

                    <label><?php echo _PAGECONTENT; ?></label>
                    <textarea type="text" class="advancedtinymce form-control" name="page_content"><?php echo $page['page_content']; ?></textarea>
                    <br>

                    <fieldset>
                      <legend><?php echo _SEO; ?></legend>

                      <label class="no-margin-top"><?php echo _SEOTITLE; ?></label>
                      <input type="text" value="<?php echo $page['page_seotitle']; ?>" name="page_seotitle" class="form-control">


                      <label><?php echo _SEODESCRIPTION; ?></label>
                      <textarea type="text" class="form-control" name="page_seodescription"><?php echo $page['page_seodescription']; ?></textarea>

                    </fieldset>

                  </div>
                </div>

                <div class="form-group col-12 col-lg-3 sidebar">

         <div class="block col-md-12">
  
                      <label><?php echo _PAGEPRIVATE; ?></label>
                    <select class="custom-select form-control" name="page_private">

                      <?php
                      if($page['page_private'] == 1){
                        echo '<option value="1" selected="selected">'._PAGEHIDDEN.'</option>';
                        echo '<option value="0">'._PAGEPUBLIC.'</option>';
                      }else{
                        echo '<option value="0" selected="selected">'._PAGEPUBLIC.'</option>';
                        echo '<option value="1">'._PAGEHIDDEN.'</option>';
                      }
                      ?>

                    </select>
          </div>


         <div class="block col-md-12">
           <label class="required"><?php echo _TABLEFIELDSTATUS; ?></label>

           <select class="custom-select form-control" name="page_status" required="">
          <?php
          if($page['page_status'] == 1){
            echo '<option value="1" selected="selected">'._ENABLED.'</option>';
            echo '<option value="0">'._DISABLED.'</option>';

          } else{
            echo '<option value="0" selected="selected">'._DISABLED.'</option>';
            echo '<option value="1">'._ENABLED.'</option>';
          }
          ?>
          </select>

        </div>

        <div class="block col-md-12">

        <button class="btn btn-primary" type="submit" name="save"><?php echo _UPDATEITEM; ?></button>

        <?php if (is_default_page($page['page_id'])): ?>

         <button class="btn btn-danger cursor-not" type="button" disabled="">
          <?php echo _DELETEITEM; ?>
        </button>

      <?php else: ?>

        <button class="btn btn-danger deleteItem" type="button" data-url="../controller/delete_page.php?id=<?php echo $page['page_id']; ?>" data-redirect="../controller/pages.php"><?php echo _DELETEITEM; ?></button>

      <?php endif; ?>

      </div>

    </div>
  </div>

</form>
</div>
</div>
</div>
</div>
</div>
</div>
</section>
<?php /* EDIT_PAGE_PTBR_INJECT */ ?>
<script>
(function(){
  try{
    var pairs = [
      [/^\s*Title\s*\*?\s*$/i, 'Título *'],
      [/^\s*Slug\s*\*?\s*$/i, 'Slug *'],
      [/^\s*Template\s*\*?\s*$/i, 'Modelo *'],
      [/^\s*Change settings\s*$/i, 'Alterar configurações'],
      [/^\s*Show footer ad\s*$/i, 'Mostrar anúncio no rodapé'],
      [/^\s*Show sidebar ad\s*$/i, 'Mostrar anúncio na barra lateral'],
      [/^\s*Show header ad\s*$/i, 'Mostrar anúncio no cabeçalho'],
      [/^\s*Show footer\s*$/i, 'Mostrar rodapé'],
      [/^\s*Show title\s*$/i, 'Mostrar título'],
      [/^\s*Content\s*\*?\s*$/i, 'Conteúdo *'],
      [/^\s*Description\s*\*?\s*$/i, 'Descrição *'],
      [/^\s*Description\s*$/i, 'Descrição'],
      [/^\s*Private\s*$/i, 'Privado'],
      [/^\s*Hidden\s*$/i,  'Oculto'],
      [/^\s*Update\s*$/i, 'Atualizar'],
      [/^\s*Delete\s*$/i, 'Excluir'],
      [/^\s*SEO\s*$/i, 'SEO'],
      [/^\s*You cannot change the template because this page is selected as default\s*$/i, 'Você não pode alterar o modelo porque esta página está definida como padrão']
    ];
    function applyText(){
      document.querySelectorAll('label, legend, th, button, .btn, .section-title h4, p, span, small').forEach(function(el){
        var t = (el.textContent || '').trim();
        for (var i=0;i<pairs.length;i++){
          var rx = pairs[i][0], rep = pairs[i][1];
          if (rx.test(t)) { el.textContent = t.replace(rx, rep); break; }
        }
      });
      document.querySelectorAll('input[placeholder], textarea[placeholder]').forEach(function(el){
        var ph = el.getAttribute('placeholder') || '';
        ph = ph.replace(/Title/ig,'Título').replace(/Slug/ig,'Slug').replace(/Description/ig,'Descrição').replace(/Content/ig,'Conteúdo');
        if (ph) el.setAttribute('placeholder', ph);
      });
    }
    applyText(); setTimeout(applyText, 300);
  }catch(e){}
})();
</script>
<?php /* /EDIT_PAGE_PTBR_INJECT */ ?>

?>
<!-- EDIT_PAGE_PTBR_INJECT -->
<script>
(function(){
  try{
    var pairs = [
      [/^\s*Title\s*\*?\s*$/i, 'Título *'],
      [/^\s*Slug\s*\*?\s*$/i, 'Slug *'],
      [/^\s*Template\s*\*?\s*$/i, 'Template *'],
      [/^\s*Change settings\s*$/i, 'Alterar configurações'],
      [/^\s*Show footer ad\s*$/i, 'Mostrar Anúncio no Rodapé'],
      [/^\s*Show sidebar ad\s*$/i, 'Mostrar Anúncio na Barra Lateral'],
      [/^\s*Show header ad\s*$/i, 'Mostrar Anúncio no Cabeçalho'],
      [/^\s*Show footer\s*$/i, 'Mostrar Rodapé'],
      [/^\s*Show title\s*$/i, 'Mostrar Título'],
      [/^\s*Content\s*\*?\s*$/i, 'Conteúdo *'],
      [/^\s*Description\s*\*?\s*$/i, 'Descrição *'],
      [/^\s*Description\s*$/i, 'Descrição'],
      [/^\s*Private\s*$/i, 'Privado'],
      [/^\s*Hidden\s*$/i,  'Oculto'],
      [/^\s*SEO\s*$/i, 'SEO'],
      [/^\s*Update\s*$/i, 'Atualizar'],
      [/^\s*Delete\s*$/i, 'Excluir'],
      [/^\s*You cannot change the template because this page is selected as default\s*$/i,
        'Você não pode alterar o template porque esta página está definida como padrão']
    ];

    function trTextNode(node){
      var t = node.nodeValue, changed = false;
      for (var i=0;i<pairs.length;i++){
        var rx = pairs[i][0], rep = pairs[i][1];
        if (rx.test(t)) { t = t.replace(rx, rep); changed = true; }
      }
      if (changed) node.nodeValue = t;
    }

    function walk(root){
      var w = document.createTreeWalker(root, NodeFilter.SHOW_TEXT, {
        acceptNode: function(n){
          if (!n.nodeValue || !n.nodeValue.trim()) return NodeFilter.FILTER_REJECT;
          var p = n.parentElement; if (!p) return NodeFilter.FILTER_REJECT;
          var tag = p.tagName; if (tag === 'SCRIPT' || tag === 'STYLE') return NodeFilter.FILTER_REJECT;
          return NodeFilter.FILTER_ACCEPT;
        }
      });
      var nodes=[]; while (w.nextNode()) nodes.push(w.currentNode);
      nodes.forEach(trTextNode);
    }

    function run(){
      walk(document.body);
      document.querySelectorAll('input[placeholder],textarea[placeholder]').forEach(function(el){
        var ph = el.getAttribute('placeholder') || '';
        ph = ph.replace(/\bTitle\b/ig,'Título')
               .replace(/\bSlug\b/ig,'Slug')
               .replace(/\bDescription\b/ig,'Descrição')
               .replace(/\bContent\b/ig,'Conteúdo');
        el.setAttribute('placeholder', ph);
      });
      document.querySelectorAll('button, input[type=submit]').forEach(function(el){
        var txt = (el.innerText || el.value || '').trim();
        if (/^Update$/i.test(txt)) { el.innerText = 'Atualizar'; if (el.value) el.value='Atualizar'; }
        if (/^Delete$/i.test(txt)) { el.innerText = 'Excluir';   if (el.value) el.value='Excluir'; }
      });
    }

    run();
    setTimeout(run, 300);
  }catch(e){}
})();
</section>
<?php /* EDIT_PAGE_PTBR_INJECT */ ?>
<script>
(function () {
  try {
    // ... (deixe o que já existe no bloco)

    // ===== Tradução de opções dos <select> (Yes/No/Hidden) =====
    var optMap = {
      'Yes': 'Sim',
      'No': 'Não',
      'Hidden': 'Oculto'
    };
    document.querySelectorAll('select option').forEach(function (opt) {
      var t = (opt.textContent || '').trim();
      if (optMap[t]) opt.textContent = optMap[t];
    });

    // (opcional) se seu tema também usa "Visible", já deixa mapeado:
    // document.querySelectorAll('select option').forEach(function (opt) {
    //   if ((opt.textContent || '').trim() === 'Visible') opt.textContent = 'Visível';
    // });

  } catch (e) {
    console.error('PT-BR inject (options) err:', e);
  }
})();
</script>

<script>
(function(){
  try{
    var pairs = [
      [/^\s*Title\s*\*?\s*$/i, 'Título *'],
      [/^\s*Slug\s*\*?\s*$/i, 'Slug *'],
      [/^\s*Template\s*\*?\s*$/i, 'Modelo *'],
      [/^\s*Change settings\s*$/i, 'Alterar configurações'],
      [/^\s*Show footer ad\s*$/i, 'Mostrar anúncio no rodapé'],
      [/^\s*Show sidebar ad\s*$/i, 'Mostrar anúncio na barra lateral'],
      [/^\s*Show header ad\s*$/i, 'Mostrar anúncio no cabeçalho'],
      [/^\s*Show footer\s*$/i, 'Mostrar rodapé'],
      [/^\s*Show title\s*$/i, 'Mostrar título'],
      [/^\s*Content\s*\*?\s*$/i, 'Conteúdo *'],
      [/^\s*Description\s*\*?\s*$/i, 'Descrição *'],
      [/^\s*Description\s*$/i, 'Descrição'],
      [/^\s*Private\s*$/i, 'Privado'],
      [/^\s*Hidden\s*$/i,  'Oculto'],
      [/^\s*Update\s*$/i, 'Atualizar'],
      [/^\s*Delete\s*$/i, 'Excluir'],
      [/^\s*SEO\s*$/i, 'SEO'],
      [/^\s*You cannot change the template because this page is selected as default\s*$/i, 'Você não pode alterar o modelo porque esta página está definida como padrão']
    ];
    function applyText(){
      document.querySelectorAll('label, legend, th, button, .btn, .section-title h4, p, span, small').forEach(function(el){
        var t = (el.textContent || '').trim();
        for (var i=0;i<pairs.length;i++){
          var rx = pairs[i][0], rep = pairs[i][1];
          if (rx.test(t)) { el.textContent = t.replace(rx, rep); break; }
        }
      });
      document.querySelectorAll('input[placeholder], textarea[placeholder]').forEach(function(el){
        var ph = el.getAttribute('placeholder') || '';
        ph = ph.replace(/Title/ig,'Título').replace(/Slug/ig,'Slug').replace(/Description/ig,'Descrição').replace(/Content/ig,'Conteúdo');
        if (ph) el.setAttribute('placeholder', ph);
      });
    }
    applyText(); setTimeout(applyText, 300);
  }catch(e){}
})();
</script>
<script>
(function enforcePTBR(){
  try {
    // O que traduzir
    var map = {
      'Yes': 'Sim',
      'No': 'Não',
      'Hidden': 'Oculto',
      'Public': 'Público',
      'Visible': 'Visível'
    };

    // 1) Traduz o texto das <option>
    document.querySelectorAll('select option').forEach(function(opt){
      var t = (opt.textContent || '').trim();
      if (map[t]) opt.textContent = map[t];
    });

    // 2) Se o tema usa componentes que "espelham" o select (chosen, nice-select etc),
    //    também traduz o texto visível nesses espelhos
    document.querySelectorAll(
      '.filter-option-inner-inner, .current, .selected, .nice-select .current'
    ).forEach(function(el){
      var t = (el.textContent || '').trim();
      if (map[t]) el.textContent = map[t];
    });

    // Reaplica periodicamente (alguns templates trocam o DOM depois do carregamento)
    setTimeout(enforcePTBR, 400);
  } catch(e) {}
})();
</script>
<script>
(function fixCantChangeTemplate(){
  try {
    function apply() {
      document.querySelectorAll('small').forEach(function(s){
        var txt = (s.textContent || '').trim();
        if (/you cannot change the template because this page is selected as default/i.test(txt)) {
          // traduz o texto do aviso (nó de texto)
          s.childNodes.forEach(function(n){
            if (n.nodeType === 3) { // text node
              n.nodeValue = n.nodeValue.replace(
                /you cannot change the template because this page is selected as default/i,
                'Você não pode alterar o modelo porque esta página está definida como padrão'
              );
            }
          });
          // traduz o texto do link, se existir
          var a = s.querySelector('a');
          if (a) a.textContent = 'Alterar configurações';
        }
      });
    }
    apply();
    setTimeout(apply, 300); // reaplica caso o template re-renderize o bloco
  } catch(e) {}
})();
</script>

<?php require_once __DIR__ . '/../controller/footer.php'; ?>
