<?php
require_once __DIR__ . '/../controller/header.php'; ?>
<?php require_once __DIR__ . '/../controller/sidebar.php'; ?>

<!--Page Container--> 
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->

    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h5><?php echo _EDITITEM; ?></h5>
            </div>
          </div>

          <div class="col-md-12">

          <?php if(!empty($success)): ?>
          <div class="d-flex align-items-center alert alert-success" role="alert">
          <i class="icon dripicons-checkmark"></i> <?php echo $success; ?>
          </div>
          <?php endif; ?>

          <?php if(!empty($errors)): ?>
          <div class="alert alert-danger" role="alert">
          <ul>
          <?php foreach($errors as $key => $value):?>
          <li><?php echo $value; ?></li>
          <?php endforeach; ?>
          </ul>
          </div>
          <?php endif; ?>

            <div class="form-block mb-4">

              <form enctype="multipart/form-data" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>?id=<?php echo $store['store_id']; ?>" method="post">

               <input type="hidden" value="<?php echo $store['store_id']; ?>" name="store_id">

               <div class="form-row">
                <div class="form-group col-12 col-lg-9">
                  <div class="block col-md-12">

                    <label class="required"><?php echo _TABLEFIELDTITLE; ?></label>
                    <input type="text" value="<?php echo $store['store_title']; ?>" name="store_title" class="form-control" required="">

                    <input type="hidden" value="<?php echo $store['store_url']; ?>" name="store_url">


                    <label><?php echo _TABLEFIELDSLUG; ?></label>
                    <input type="hidden" value="<?php echo $store['store_slug']; ?>" name="store_slug_save">
                    <input type="text" placeholder="<?php echo $store['store_slug']; ?>" name="store_slug" class="form-control">
                    
                    <label><?php echo _TABLEFIELDDESCRIPTION; ?></label>

                    <textarea type="text" class="mceNoEditor form-control" name="store_description"><?php echo $store['store_description']; ?></textarea>

                    <label>Endereço</label>
                    <input type="text" class="form-control" name="store_address" value="<?php echo htmlspecialchars($store['store_address'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">

                    <label>Horário de atendimento</label>
                    <?php
                      $hoursText = $store['store_hours'] ?? '';
                      $openVal = '';
                      $closeVal = '';
                      if (function_exists('parseStoreHoursRange')) {
                        $parsed = parseStoreHoursRange($hoursText);
                        $openVal = $parsed['open'] ?? '';
                        $closeVal = $parsed['close'] ?? '';
                      }
                    ?>
                    <div class="form-row">
                      <div class="col">
                        <small class="text-muted d-block mb-1">Abre</small>
                        <input type="time" class="form-control" name="store_hours_open" value="<?php echo htmlspecialchars($openVal, ENT_QUOTES, 'UTF-8'); ?>">
                      </div>
                      <div class="col">
                        <small class="text-muted d-block mb-1">Fecha</small>
                        <input type="time" class="form-control" name="store_hours_close" value="<?php echo htmlspecialchars($closeVal, ENT_QUOTES, 'UTF-8'); ?>">
                      </div>
                    </div>
                    <small class="form-text text-muted mt-1">
                      Se preferir um formato diferente, preencha abaixo. Se os campos de hora estiverem vazios,
                      será usado este texto livre.
                    </small>
                    <input type="text" class="form-control mt-1" name="store_hours" value="<?php echo htmlspecialchars($store['store_hours'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">

                    <label>WhatsApp</label>
                    <input type="text" class="form-control" name="store_whatsapp" value="<?php echo htmlspecialchars($store['store_whatsapp'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" placeholder="(48) 9 9999-9999 ou link completo">

                    <label class="control-label"><?php echo _TABLEFIELDFEATURED; ?></label>


                    <select class="custom-select form-control" name="store_featured" required="">
                      <?php
                      if($store['store_featured'] == 1)
                      {
                        echo '<option value="1" selected="selected">'._YESTEXT.'</option>';
                        echo '<option value="0">'._NOTEXT.'</option>';

                      }
                      else {
                        echo '<option value="0" selected="selected">'._NOTEXT.'</option>';
                        echo '<option value="1">'._YESTEXT.'</option>';
                      }
                      ?>
                    </select>

                    <br>
                    <br>


                    <fieldset>
                      <legend><?php echo _SEO; ?></legend>

                      <label class="no-margin-top"><?php echo _SEOTITLE; ?></label>
                      <input type="text" value="<?php echo $store['store_seotitle']; ?>" name="store_seotitle" class="form-control">


                      <label><?php echo _SEODESCRIPTION; ?></label>
                      <textarea type="text" class="form-control" name="store_seodescription"><?php echo $store['store_seodescription']; ?></textarea>

                    </fieldset>

                  </div>
                </div>

                <div class="form-group col-12 col-lg-3 sidebar">

                 <div class="block col-md-12">
                   <label><?php echo _TABLEFIELDSTATUS; ?></label>

                   <select class="custom-select form-control" name="store_status">

                    <?php
                    if($store['store_status'] == 1){
                      echo '<option value="1" selected="selected">'._ENABLED.'</option>';
                      echo '<option value="0">'._DISABLED.'</option>';

                    } else{
                      echo '<option value="0" selected="selected">'._DISABLED.'</option>';
                      echo '<option value="1">'._ENABLED.'</option>';
                    }
                    ?>
                  </select>

                </div>


                <div class="block col-md-12">
                  <label><?php echo _TABLEFIELDSELLER; ?> (Anunciante)</label>
                  <select class="custom-select form-control" name="store_user_id">
                    <option value=""><?php echo '---'; ?></option>
                    <?php if (!empty($sellers_list)): ?>
                      <?php foreach ($sellers_list as $seller): ?>
                        <?php
                          $sellerUserId = (int)($seller['seller_user'] ?? 0);
                          $currentOwner = isset($store['store_user_id']) ? (int)$store['store_user_id'] : 0;
                          $selected = ($sellerUserId > 0 && $sellerUserId === $currentOwner) ? 'selected="selected"' : '';
                        ?>
                        <option value="<?php echo $sellerUserId; ?>" <?php echo $selected; ?>>
                          <?php echo htmlspecialchars($seller['seller_title'] ?? ''); ?>
                          <?php if (!empty($seller['user_email'])): ?>
                            (<?php echo htmlspecialchars($seller['user_email']); ?>)
                          <?php endif; ?>
                        </option>
                      <?php endforeach; ?>
                    <?php endif; ?>
                  </select>
                  <small class="text-muted">Deixe em branco para loja genérica (não vinculada a um anunciante específico).</small>
                </div>

                <div class="block col-md-12">
                  <label><?php echo _TABLEFIELDIMAGE; ?></label>

                  <div class="new-image" id="image-preview" style="background: url(<?php echo $target_dir; ?><?php echo $store['store_image'] ?>);">
                    <label for="image-upload" id="image-label"><?php echo _CHOOSEFILE; ?></label>
                    <input type="hidden" value="<?php echo $store['store_image']; ?>" name="store_image_save">
                    <input type="file" name="store_image" accept=".jpg, .jpeg, .png, .gif" id="image-upload" />
                  </div>

                  <span class="text-danger recomendedsize"><?php echo _RECOMMENDEDSIZE; ?> <b>350 x 350</b> </span>
                  <br/>
                </div>

                <div class="block col-md-12">
                <button class="btn btn-primary" type="submit" name="save"><?php echo _UPDATEITEM; ?></button>
                <button class="btn btn-danger deleteItem" type="button" data-url="../controller/delete_store.php?id=<?php echo $store['store_id']; ?>" data-redirect="../controller/categories.php"><?php echo _DELETEITEM; ?></button>
                </div>

              </div>
            </div>

          </form>
        </div>
      </div>
    </div>
  </div>
</div>
</div>
</section>
<!-- EDIT_STORE_PTBR_INJECT -->
<script>
(function () {
  try {
    function run() {
      // 1) Tradução simples de rótulos, títulos e pequenos textos
      document.querySelectorAll('label, legend, th, .section-title h4, .section-title h5, small, .btn').forEach(function (el) {
        var t = (el.textContent || '').trim();

        // "Recommended size: 350 x 350" -> "Tamanho recomendado: 350 x 350"
        if (/recommended size\s*:/i.test(t)) {
          el.textContent = t.replace(/recommended size\s*:\s*/i, 'Tamanho recomendado: ');
          return;
        }

        // Trocas diretas
        var map = {
          // rótulos
          '<?php echo _TABLEFIELDSLUG; ?>': '<?php echo _TABLEFIELDSLUG; ?>',
          '<?php echo _TABLEFIELDDESCRIPTION; ?>': 'Descrição',
          '<?php echo _TABLEFIELDTITLE; ?>': 'Título',
          '<?php echo _TABLEFIELDITEMSTATUS; ?>': '<?php echo _TABLEFIELDITEMSTATUS; ?>',
          '<?php echo _TABLEFIELDFEATURED; ?>': 'Destaque',
          // botões (se algum vier aqui como texto plano)
          '<?php echo _UPDATE; ?>': 'Atualizar',
          '<?php echo _DELETEITEM; ?>': 'Excluir',
          // botão de upload comum em alguns temas
          'Choose File': 'Escolher arquivo'
        };
        if (map[t]) el.textContent = map[t];
      });

      // 2) Placeholders de inputs/textarea
      document.querySelectorAll('input[placeholder], textarea[placeholder]').forEach(function (el) {
        var ph = el.getAttribute('placeholder') || '';
        ph = ph
          .replace(/\bTitle\b/ig, 'Título')
          .replace(/\bSlug\b/ig, '<?php echo _TABLEFIELDSLUG; ?>')
          .replace(/\bDescription\b/ig, 'Descrição');
        el.setAttribute('placeholder', ph);
      });

      // 3) Botões (innerText e value)
      document.querySelectorAll('button, input[type=submit]').forEach(function (btn) {
        var txt = (btn.innerText || btn.value || '').trim();
        if (/^<?php echo _UPDATE; ?>$/i.test(txt)) { btn.innerText = 'Atualizar'; if (btn.value) btn.value = 'Atualizar'; }
        if (/^<?php echo _DELETEITEM; ?>$/i.test(txt)) { btn.innerText = 'Excluir';   if (btn.value) btn.value = 'Excluir'; }
      });

      // 4) Opções de <select> (Yes/No/Hidden/Visible)
      var optMap = { 'Yes': 'Sim', 'No': 'Não', 'Hidden': 'Oculto', 'Visible': 'Visível' };
      document.querySelectorAll('select option').forEach(function (opt) {
        var t = (opt.textContent || '').trim();
        if (optMap[t]) opt.textContent = optMap[t];
      });
    }

    run();
    // reaplica após pequeno atraso caso algo seja re-renderizado
    setTimeout(run, 300);
  } catch (e) {
    console.error('EDIT_STORE_PTBR_INJECT error:', e);
  }
})();
</script>
<!-- /EDIT_STORE_PTBR_INJECT -->

<?php require_once __DIR__ . '/../controller/footer.php'; ?>