<?php
require_once __DIR__ . '/../controller/header.php';
require_once __DIR__ . '/../controller/sidebar.php';

$order = isset($order) && is_array($order) ? $order : [];
$stores = isset($stores) && is_array($stores) ? $stores : [];
$errors = isset($errors) && is_array($errors) ? $errors : [];
$success = isset($success) ? (string)$success : '';

function nd_status_label_admin(string $status): string {
  $s = strtolower(trim($status));
  return match ($s) {
    'pending_payment' => 'Pendente de pagamento',
    'pending_activation' => 'Pendente de ativação',
    'active' => 'Ativo',
    'expired' => 'Expirado',
    'canceled' => 'Cancelado',
    default => $status,
  };
}

$meta = [];
try {
  if (!empty($order['meta_json'])) {
    $decoded = json_decode((string)$order['meta_json'], true);
    if (is_array($decoded)) $meta = $decoded;
  }
} catch (Throwable $e) { $meta = []; }

?>
<div class="content p-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <h3 class="mb-0">Gerenciar Add-on</h3>
      <small class="text-muted">Pedido #<?php echo (int)($order['id'] ?? 0); ?> • <?php echo htmlspecialchars((string)($order['user_email'] ?? ''), ENT_QUOTES, 'UTF-8'); ?></small>
    </div>
    <div>
      <a class="btn btn-outline-secondary" href="./addons.php">Voltar</a>
    </div>
  </div>

  <?php if (!empty($errors)): ?>
    <div class="alert alert-danger">
      <ul class="mb-0">
        <?php foreach ($errors as $e): ?>
          <li><?php echo $e; ?></li>
        <?php endforeach; ?>
      </ul>
    </div>
  <?php endif; ?>

  <?php if ($success): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($success, ENT_QUOTES, 'UTF-8'); ?></div>
  <?php endif; ?>

  <div class="row g-3">
    <div class="col-lg-5">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title mb-3">Detalhes</h5>
          <div class="mb-2"><strong>Add-on:</strong> <?php echo htmlspecialchars((string)($order['addon_title'] ?? $order['addon_key'] ?? ''), ENT_QUOTES, 'UTF-8'); ?></div>
          <div class="mb-2"><strong>Tipo:</strong> <?php echo htmlspecialchars((string)($meta['type'] ?? $order['billing_type'] ?? '-'), ENT_QUOTES, 'UTF-8'); ?></div>
          <div class="mb-2"><strong>Loja:</strong> <?php echo htmlspecialchars((string)($order['store_title'] ?? '-'), ENT_QUOTES, 'UTF-8'); ?></div>
          <div class="mb-2"><strong>Valor:</strong> R$ <?php echo number_format((float)($order['amount_total'] ?? 0), 2, ',', '.'); ?></div>
          <div class="mb-2"><strong>Status atual:</strong> <?php echo htmlspecialchars(nd_status_label_admin((string)($order['status'] ?? '')), ENT_QUOTES, 'UTF-8'); ?></div>
          <div class="mb-2"><strong>Pagamento ID:</strong> <?php echo htmlspecialchars((string)($order['payment_id'] ?? '-'), ENT_QUOTES, 'UTF-8'); ?></div>
          <div class="mb-2"><strong>Criado em:</strong> <?php echo htmlspecialchars((string)($order['created_at'] ?? '-'), ENT_QUOTES, 'UTF-8'); ?></div>
          <hr>
          <div class="small text-muted">
            <div><strong>Dica:</strong> se o cliente pagou via pix/transferência, primeiro marque o pagamento como <strong>Pago</strong> na tela de Pagamentos. Em seguida, aqui você ativa e define as datas do add-on.</div>
          </div>
        </div>
      </div>
    </div>

    <div class="col-lg-7">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title mb-3">Operação</h5>

          <?php
  $currentMode = $meta['mode'] ?? 'rotative';
  $segment = $meta['segment'] ?? '';
  $neighborhood = $meta['neighborhood'] ?? '';
?>

<form method="post" action="">
            <div class="row g-3">
              <div class="col-md-6">
                <label class="form-label">Loja (opcional)</label>
                <select class="form-select" name="store_id">
                  <option value="0">— nenhuma / não se aplica —</option>
                  <?php foreach ($stores as $s): ?>
                    <?php $sid = (int)($s['store_id'] ?? 0); ?>
                    <option value="<?php echo $sid; ?>" <?php echo ((int)($order['store_id'] ?? 0) === $sid ? 'selected' : ''); ?>>
                      <?php echo htmlspecialchars((string)($s['store_title'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>

              <div class="col-md-6">
                <label class="form-label">Status</label>
                <select class="form-select" name="status">
                  <?php $cur = strtolower((string)($order['status'] ?? '')); ?>
                  <?php foreach (['pending_payment','pending_activation','active','expired','canceled'] as $st): ?>
                    <option value="<?php echo $st; ?>" <?php echo ($cur === $st ? 'selected' : ''); ?>><?php echo htmlspecialchars(nd_status_label_admin($st), ENT_QUOTES, 'UTF-8'); ?></option>
                  <?php endforeach; ?>
                </select>
              </div>

        <?php if (in_array($order['addon_code'], ['home7','cat7'], true)): ?>
          <div class="form-group">
            <label>Modo de destaque</label>
            <select name="mode" class="form-control">
              <option value="rotative" <?php echo ($currentMode==='rotative') ? 'selected' : ''; ?>>Rotativo (padrão)</option>
              <option value="fixed" <?php echo ($currentMode==='fixed') ? 'selected' : ''; ?>>Fixo (prioridade máxima)</option>
            </select>
            <small class="text-muted">Dica: use “Fixo” para 1 cliente “dominar” a vitrine/categoria no período.</small>
          </div>
        <?php endif; ?>

        <?php if ($order['addon_code'] === 'exclusive'): ?>
          <div class="form-row">
            <div class="form-group col-md-6">
              <label>Segmento</label>
              <input type="text" name="segment" class="form-control" value="<?php echo htmlspecialchars($segment); ?>" placeholder="Ex.: Farmácia, Restaurante, Mercado">
            </div>
            <div class="form-group col-md-6">
              <label>Bairro</label>
              <input type="text" name="neighborhood" class="form-control" value="<?php echo htmlspecialchars($neighborhood); ?>" placeholder="Ex.: Trindade, Centro, Ingleses">
            </div>
          </div>
          <small class="text-muted">Ao ativar, o sistema bloqueia outra exclusividade com o mesmo Segmento + Bairro no mesmo período.</small>
        <?php endif; ?>


              <div class="col-md-6">
                <label class="form-label">Início (YYYY-MM-DD ou YYYY-MM-DD HH:MM)</label>
                <input class="form-control" name="start_date" value="<?php echo htmlspecialchars((string)($order['start_date'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>">
              </div>

              <div class="col-md-6">
                <label class="form-label">Fim (YYYY-MM-DD ou YYYY-MM-DD HH:MM)</label>
                <input class="form-control" name="end_date" value="<?php echo htmlspecialchars((string)($order['end_date'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>">
                <div class="form-text">Se deixar vazio e marcar como <strong>Ativo</strong>, o sistema calcula pelo prazo padrão.</div>
              </div>

              <div class="col-12">
                <label class="form-label">Notas (interno)</label>
                <textarea class="form-control" name="notes" rows="4" placeholder="Ex.: ativar em 02/01; exclusividade bairro X; etc."><?php echo htmlspecialchars((string)($order['notes'] ?? ''), ENT_QUOTES, 'UTF-8'); ?></textarea>
              </div>

              <div class="col-12 d-flex gap-2">
                <button class="btn btn-primary" type="submit">Salvar</button>
                <a class="btn btn-outline-secondary" href="./addons.php">Cancelar</a>
              </div>
            </div>
          </form>

        </div>
      </div>
    </div>
  </div>
</div>
