<?php
require_once __DIR__ . '/../controller/header.php'; ?>
<?php require_once __DIR__ . '/../controller/sidebar.php'; ?>

<section class="page-container">
  <div class="page-content-wrapper">

    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">

        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h5>Cadastrar associado</h5>
              <p class="text-muted">
                Registre um novo parceiro de mídia (motorista, táxi, van) que vai divulgar os QR Codes.
              </p>
            </div>
          </div>
        </div>

        <?php if (!empty($errors)): ?>
          <div class="alert alert-danger">
            <?php foreach ($errors as $e): ?>
              <p><?php echo htmlspecialchars($e, ENT_QUOTES, 'UTF-8'); ?></p>
            <?php endforeach; ?>
          </div>
        <?php endif; ?>

        <form method="post" autocomplete="off">
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label>Nome do associado *</label>
                <input type="text" name="associate_name" class="form-control" required>
              </div>
            </div>

            <div class="col-md-3">
              <div class="form-group">
                <label>E-mail</label>
                <input type="email" name="associate_email" class="form-control">
              </div>
            </div>

            <div class="col-md-3">
              <div class="form-group">
                <label>Telefone / WhatsApp</label>
                <input type="text" name="associate_phone" class="form-control">
              </div>
            </div>

            <div class="col-md-4">
              <div class="form-group">
                <label>Cidade</label>
                <input type="text" name="associate_city" class="form-control">
              </div>
            </div>

            <div class="col-md-2">
              <div class="form-group">
                <label>UF</label>
                <input type="text" name="associate_state" class="form-control" maxlength="2">
              </div>
            </div>

            <div class="col-md-3">
              <div class="form-group">
                <label>Grupo</label>
                <select name="associate_group" class="custom-select form-control">
                  <option value="">Selecione...</option>
                  <option value="Uber">Uber</option>
                  <option value="99">99</option>
                  <option value="Taxi">Taxi</option>
                  <option value="Van Turismo">Van Turismo</option>
                  <option value="Motoboy">Motoboy</option>
                  <option value="Carteiro">Carteiro</option>
                  <option value="Entregador">Entregador</option>
                  <option value="Outros">Outros</option>
                </select>
              </div>
            </div>

            <div class="col-md-3">
              <div class="form-group">
                <label>Código do associado (opcional)</label>
                <input type="text" name="associate_code" class="form-control"
                       placeholder="Ex: CAR123, UBER-SUL-01">
              </div>
            </div>

            <div class="col-md-3">
              <div class="form-group">
                <label>Status</label>
                <select name="associate_status" class="custom-select form-control">
                  <option value="1">Ativo</option>
                  <option value="0">Inativo</option>
                </select>
              </div>
            </div>

          </div>

          <div class="row mt-3">
            <div class="col-12">
              <button type="submit" class="btn btn-primary">
                <i class="fa fa-save"></i> Salvar associado
              </button>
              <a href="./associates.php" class="btn btn-secondary">
                Cancelar
              </a>
            </div>
          </div>

        </form>

      </div>
    </div>

  </div>
</section>

<?php require_once __DIR__ . '/../controller/footer.php'; ?>
