<?php
require_once __DIR__ . '/../controller/header.php'; ?>
<?php require_once __DIR__ . '/../controller/sidebar.php'; ?>

<!--Page Container--> 
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->

    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h5><?php echo _ADDITEM; ?></h5>
            </div>
          </div>

          <div class="col-md-12">

          <?php if(!empty($errors)): ?>
          <div class="alert alert-danger" role="alert">
          <ul>
          <?php foreach($errors as $key => $value):?>
          <li><?php echo $value; ?></li>
          <?php endforeach; ?>
          </ul>
          </div>
          <?php endif; ?>
          
            <div class="form-block mb-4">

              <form enctype="multipart/form-data" action="" method="post">

                <div class="form-row">
                  <div class="form-group col-12 col-lg-9">
                    <div class="block col-md-12">

                      <label class="required"><?php echo _TABLEFIELDTITLE; ?></label>
                      <input type="text" placeholder="" name="category_title" class="form-control" required="">

                      <label><?php echo _TABLEFIELDDESCRIPTION; ?></label>
                      <textarea type="text" class="mceNoEditor form-control" name="category_description"></textarea>

                      <label><?php echo _ICON; ?></label>
                      <a href="https://tabler-icons.io/" target="_blank"><?php echo _SELECTICON; ?> <i class="dripicons-export"></i></a>
                      <input type="text" placeholder="" name="category_icon" class="form-control">

                      <label class="control-label"><?php echo _TABLEFIELDSHOWMENU; ?></label>
                   <select class="custom-select form-control" name="category_menu">
                     <option value="0"><?php echo _NOTEXT; ?></option>
                     <option value="1"><?php echo _YESTEXT; ?></option>
                   </select>

                   <label class="control-label"><?php echo _TABLEFIELDFEATURED; ?></label>
                   <select class="custom-select form-control" name="category_featured">
                     <option value="0"><?php echo _NOTEXT; ?></option>
                     <option value="1"><?php echo _YESTEXT; ?></option>
                   </select>

                      <br>
                      <br>

                      <fieldset>
                        <legend><?php echo _SEO; ?></legend>

                        <label class="no-margin-top"><?php echo _SEOTITLE; ?></label>
                        <input type="text" name="category_seotitle" class="form-control">

                        <label><?php echo _SEODESCRIPTION; ?></label>
                        <textarea type="text" class="mceNoEditor form-control" name="category_seodescription"></textarea>

                      </fieldset>

                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3 sidebar">

               <div class="block col-md-12">
                 <label><?php echo _TABLEFIELDSTATUS; ?></label>

                 <select class="custom-select form-control" name="category_status">
                  <option value="1" selected=""><?php echo _ENABLED; ?></option>
                  <option value="0"><?php echo _DISABLED; ?></option>
                </select>

              </div>

                    <div class="block col-md-12">
                      <label class="required"><?php echo _TABLEFIELDIMAGE; ?></label>

                      <div class="new-image" id="image-preview">
                        <label for="image-upload" id="image-label"><?php echo _CHOOSEFILE; ?></label>
                        <input type="file" name="category_image" accept=".jpg, .jpeg, .png, .gif" id="image-upload" required="" />
                      </div>

                      <span class="text-danger recomendedsize"><?php echo _RECOMMENDEDSIZE; ?> <b>350 x 350</b> </span>
                      <br/>
                    </div>

                    <button class="btn btn-primary" type="submit" name="save"><?php echo _SAVECHANGES; ?></button>

                  </div>
                </div>

              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<?php /* NEW_CATEGORY_PTBR_INJECT v2 */ ?>
<script>
(function () {
  if (window.__NEW_CATEGORY_PTBR_APPLIED_V2__) return;
  window.__NEW_CATEGORY_PTBR_APPLIED_V2__ = true;

  try {
    function traduz() {
      // ---- 1) rótulos / títulos / botões / textos soltos ----
      var pairs = [
        [/^\s*Title\s*\*?\s*$/i,                  'Título *'],
        [/^\s*TITLE\s*\*?\s*$/i,                  'Título *'],
        [/^\s*Slug\s*\*?\s*$/i,                   'Slug *'],
        [/^\s*Description\s*\*?\s*$/i,            'Descrição *'],
        [/^\s*Description\s*$/i,                  'Descrição'],
        [/^\s*<?php echo _ICON; ?>\s*$/i,                         'Ícone'],
        [/^\s*<?php echo _SELECTICON; ?>\s*$/i,                  'Selecionar ícone'],
        [/^\s*Show in menu\s*$/i,                 'Mostrar no menu'],
        [/^\s*Featured\s*$/i,                     'Destaque'],
        [/^\s*SEO\s*$/i,                          'SEO'],
        [/^\s*Status\s*$/i,                       'Status'],
        [/^\s*Image\s*\*?\s*$/i,                  'Imagem *'],
        [/^\s*Save changes\s*$/i,                 'Salvar alterações'],
        // textos auxiliares
        [/recommended\s*size\s*:/i,               'Tamanho recomendado: ']
      ];

      // percorre elementos comuns
      document.querySelectorAll('label, legend, th, .section-title h4, .section-title h5, small, .btn, button, input[type=submit], a, span')
        .forEach(function(el){
          var raw = (el.innerText || el.value || '').trim();
          if (!raw) return;

          // regra específica do "Recommended size"
          if (/recommended\s*size\s*:/i.test(raw)) {
            var novo = raw.replace(/recommended\s*size\s*:/i, 'Tamanho recomendado: ');
            if ('value' in el && el.type === 'submit') el.value = novo; else el.innerText = novo;
            return;
          }

          // pares genéricos
          for (var i=0;i<pairs.length;i++) {
            if (pairs[i][0].test(raw)) {
              var novo = raw.replace(pairs[i][0], pairs[i][1]);
              if ('value' in el && el.type === 'submit') el.value = novo;
              else el.innerText = novo;
              break;
            }
          }
        });

      // ---- 2) placeholders ----
      document.querySelectorAll('input[placeholder], textarea[placeholder]').forEach(function(el){
        var ph = el.getAttribute('placeholder') || '';
        ph = ph
          .replace(/\bTitle\b/ig, 'Título')
          .replace(/\bSlug\b/ig, 'Slug')
          .replace(/\bDescription\b/ig, 'Descrição')
          .replace(/\bIcon\b/ig, 'Ícone');
        el.setAttribute('placeholder', ph);
      });

      // ---- 3) opções de <select> ----
      var optMap = { 'Yes':'Sim', 'No':'Não', 'Hidden':'Oculto', 'Visible':'Visível',
                     'Enabled':'Ativado','Disabled':'Desativado','Active':'Ativo','Inactive':'Inativo' };
      document.querySelectorAll('select option').forEach(function(opt){
        var t = (opt.textContent || '').trim();
        if (optMap[t]) opt.textContent = optMap[t];
      });
    }

    traduz();
    // reaplicar caso a tela rehidrate/re-renderize
    setTimeout(traduz, 300);
  } catch(e) { console.error('NEW_CATEGORY_PTBR_INJECT v2:', e); }
})();
</script>
<?php /* /NEW_CATEGORY_PTBR_INJECT v2 */ ?>


<?php require_once __DIR__ . '/../controller/footer.php'; ?>
