<?php
require_once __DIR__ . '/../controller/header.php'; ?>
<?php require_once __DIR__ . '/../controller/sidebar.php'; ?>

<!--Page Container--> 
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->

    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h5><?php echo _ADDITEM; ?></h5>
            </div>
          </div>

          <div class="col-md-12">

          <?php if(!empty($errors)): ?>
          <div class="alert alert-danger" role="alert">
          <ul>
          <?php foreach($errors as $key => $value):?>
          <li><?php echo $value; ?></li>
          <?php endforeach; ?>
          </ul>
          </div>
          <?php endif; ?>

            <div class="form-block mb-4">

              <form enctype="multipart/form-data" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" method="post">

                <div class="form-row">
                  <div class="form-group col-12 col-lg-9">
                    <div class="block col-md-12">

                      <label class="required"><?php echo _TABLEFIELDTITLE; ?></label>
                      <input type="text" placeholder="" name="store_title" class="form-control" required="">

                      <label><?php echo _TABLEFIELDDESCRIPTION; ?></label>

                      <textarea type="text" class="mceNoEditor form-control" name="store_description"></textarea>

                   <label class="control-label"><?php echo _TABLEFIELDFEATURED; ?></label>
                   <select class="custom-select form-control" name="store_featured">
                     <option value="0"><?php echo _NOTEXT; ?></option>
                     <option value="1"><?php echo _YESTEXT; ?></option>
                   </select>

                      <br>
                      <br>

                      <fieldset>
                        <legend><?php echo _SEO; ?></legend>

                        <label class="no-margin-top"><?php echo _SEOTITLE; ?></label>
                        <input type="text" name="store_seotitle" class="form-control">

                        <label><?php echo _SEODESCRIPTION; ?></label>
                        <textarea type="text" class="mceNoEditor form-control" name="store_seodescription"></textarea>

                      </fieldset>

                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3 sidebar">

               <div class="block col-md-12">
                 <label><?php echo _TABLEFIELDSTATUS; ?></label>

                 <select class="custom-select form-control" name="store_status">
                  <option value="1" selected=""><?php echo _ENABLED; ?></option>
                  <option value="0"><?php echo _DISABLED; ?></option>
                </select>


                    <div class="block col-md-12">
                      <label><?php echo _TABLEFIELDSELLER; ?> (Anunciante)</label>
                      <select class="custom-select form-control" name="store_user_id">
                        <option value=""><?php echo '---'; ?></option>
                        <?php
                        // Opcional: listar anunciantes para multi-loja diretamente no cadastro
                        try {
                          $sellers_list = array();
                          $sql_sellers = "SELECT s.seller_user, s.seller_title, u.user_email
                                         FROM sellers s
                                         LEFT JOIN users u ON u.user_id = s.seller_user
                                         ORDER BY s.seller_title ASC";
                          $st_sellers = connect()->prepare($sql_sellers);
                          $st_sellers->execute();
                          $sellers_list = $st_sellers->fetchAll(PDO::FETCH_ASSOC);
                        } catch (PDOException $e) {
                          $sellers_list = array();
                        }
                        ?>
                        <?php if (!empty($sellers_list)): ?>
                          <?php foreach ($sellers_list as $seller): ?>
                            <?php $sellerUserId = (int)($seller['seller_user'] ?? 0); ?>
                            <option value="<?php echo $sellerUserId; ?>">
                              <?php echo htmlspecialchars($seller['seller_title'] ?? ''); ?>
                              <?php if (!empty($seller['user_email'])): ?>
                                (<?php echo htmlspecialchars($seller['user_email']); ?>)
                              <?php endif; ?>
                            </option>
                          <?php endforeach; ?>
                        <?php endif; ?>
                      </select>
                      <small class="text-muted">Deixe em branco para loja genérica (não vinculada a um anunciante específico).</small>
                    </div>

              </div>

                    <div class="block col-md-12">
                      <label class="required"><?php echo _TABLEFIELDIMAGE; ?></label>

                      <div class="new-image" id="image-preview">
                        <label for="image-upload" id="image-label"><?php echo _CHOOSEFILE; ?></label>
                        <input type="file" name="store_image" accept=".jpg, .jpeg, .png, .gif" id="image-upload" required="" />
                      </div>

                      <span class="text-danger recomendedsize"><?php echo _RECOMMENDEDSIZE; ?> <b>350 x 350</b> </span>
                      <br/>
                    </div>

                    <button class="btn btn-primary" type="submit" name="save"><?php echo _SAVECHANGES; ?></button>

                  </div>
                </div>

              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<?php require_once __DIR__ . '/../controller/footer.php'; ?>