<?php
require_once __DIR__ . '/../controller/header.php'; ?>
<?php require_once __DIR__ . '/../controller/sidebar.php'; ?>  

<script type="text/javascript">
$(document).ready(function(){

var interval = $(".filters a[class*='active']").data('interval');
var selected = $(".filters a[class*='active']").data('label');

if(interval){
$('.selectedInterval').html(selected);
}

$('#table_id').dataTable({
"bProcessing": true,
"sAjaxSource": "../controller/get_payments.php?interval="+interval,
"responsive": true,
"bPaginate":true,
"aaSorting": [[1,'desc']],
"sPaginationType":"full_numbers",
"iDisplayLength": 10,
"aoColumns": [
{ mData: 'payment_external', "width": "5%", "className": "text-left" },
{ "mData": null , "className":"text-left",
"mRender" : function (data) {
return '<a class="text-muted" href="./edit_user.php?id='+data.payment_user_id+'">'+data.user_email+'</a>';
}
},
{ "mData": null , "className":"text-left",
"mRender" : function (data) {
return '<span class="text-capitalize">'+data.payment_processor+'</span>';
}
},
{ "mData": null , "className":"text-center",
"mRender" : function (data) {
return '<a class="text-muted" href="./edit_plan.php?id='+data.plan_id+'">'+data.plan_title+'</a>';
}
},
{ "mData": null , "width": "8%", "className":"text-center",
"mRender" : function (data) {
return '<span>'+data.payment_total_amount+'</span>';
}
},
{ "mData": null , "width": "8%", "className":"text-center",
"mRender" : function (data) {
return '<span>'+data.payment_currency+'</span>';
}
},
{ "mData": null , "width": "5%", "className":"status text-center",
"mRender" : function (data) {

    var status = parseInt(data.payment_status, 10);
    var label = '';
    var css   = '';

    switch (status) {
      case 0:
        label = "<?php echo _PAYMENTSTATUS_PENDING; ?>";
        css   = "bg-warning";
        break;
      case 2:
        label = "<?php echo _PAYMENTSTATUS_AWAITING_PROOF; ?>";
        css   = "bg-warning";
        break;
      case 3:
        label = "<?php echo _PAYMENTSTATUS_UNDER_REVIEW; ?>";
        css   = "bg-info";
        break;
      case 1:
        label = "<?php echo _PAYMENTSTATUS_APPROVED; ?>";
        css   = "bg-success";
        break;
      case 4:
        label = "<?php echo _PAYMENTSTATUS_REJECTED; ?>";
        css   = "bg-danger";
        break;
      default:
        label = "<?php echo _UNKNOWN; ?>";
        css   = "bg-secondary";
        break;
    }

    return '<span class="label badge-pill '+css+'">'+label+'</span>';
}
},
{ mData: 'payment_date', "className": "text-center" },
{ "mData": null ,
  "width": "14%",
  "className": "text-center",
  "orderable": false,
  "searchable": false,
  "mRender" : function (data) {

    var buttons = "";

    // Botão VER (detalhes do pagamento)
    buttons += "<a class='btn btn-small btn-info mb-1' href='../controller/payment_details.php?id="
        + data.payment_id + "'><?php echo _VIEWITEM; ?></a> ";

    // Botão INVOICE
    buttons += "<a class='btn btn-small btn-secondary mb-1' href='../controller/invoice.php?id="
        + data.payment_id + "'><?php echo _TABLEFIELDINVOICE; ?></a> ";

    // Botão COMPROVANTE (somente banktransfer com arquivo manual)
    if (data.payment_processor === 'banktransfer'
        && data.payment_external
        && data.payment_external.indexOf('manual://') === 0) {

        var proofFile = data.payment_external.replace('manual://', '');

        buttons += "<a class='btn btn-small btn-primary mb-1' target='_blank' "
                 + "href='../../uploads/manual-payments/" + proofFile + "'>"
                 + "Comprovante</a> ";
    }

    // Botões de status (somente banktransfer)
    if (data.payment_processor === 'banktransfer') {

        var status = parseInt(data.payment_status, 10);

        // Em análise
        if (status !== 3) {
            buttons += "<a class='btn btn-small btn-warning mb-1' "
                     + "href='../controller/payment_status.php?id=" + data.payment_id + "&status=3'>"
                     + "Em análise</a> ";
        }

        // Aprovar
        if (status !== 1) {
            buttons += "<a class='btn btn-small btn-success mb-1' "
                     + "href='../controller/payment_status.php?id=" + data.payment_id + "&status=1'>"
                     + "Aprovar</a> ";
        }

        // Rejeitar
        if (status !== 4) {
            buttons += "<a class='btn btn-small btn-danger mb-1' "
                     + "href='../controller/payment_status.php?id=" + data.payment_id + "&status=4'>"
                     + "Rejeitar</a> ";
        }
    }

    return buttons;
  }
}
]
});
});
</script>

<!--Page Container-->
<section class="page-container">
<div class="page-content-wrapper">

<!--Main Content-->

<div class="content sm-gutter">
<div class="container-fluid padding-25 sm-padding-10">

<div class="row">

<div class="col-6 d-flex align-items-center">

<div class="section-title">
<h5 class="text-truncate"><?php echo _PAYMENTS; ?></h5>
</div>

</div>

<div class="col-6 d-flex align-items-center justify-content-end">

<div class="inline-block">

<div class="dropdown dropleft">
<button class="btn btn-primary dropdown-toggle text-capitalize" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-expanded="false">
<i class="fa fa-filter add-new-i"></i> <?php echo (!getInterval() ? _FILTERS : '<span class="selectedInterval"></span>'); ?>
</button>
<div class="dropdown-menu dropdown-menu-right filters " aria-label="dropdownMenuButton">
<a href="./payments.php?interval=today" class="dropdown-item pointer <?php echo (getInterval() == "today" ? "active" : null); ?>" data-interval="today" data-label="<?php echo _INTERVALTODAY; ?>"><?php echo _INTERVALTODAY; ?></a>
<a href="./payments.php?interval=yesterday" class="dropdown-item pointer <?php echo (getInterval() == "yesterday" ? "active" : null); ?>" data-interval="yesterday" data-label="<?php echo _INTERVALYESTERDAY; ?>"><?php echo _INTERVALYESTERDAY; ?></a>
<a href="./payments.php?interval=last7days" class="dropdown-item pointer <?php echo (getInterval() == "last7days" ? "active" : null); ?>" data-interval="last7days" data-label="<?php echo _INTERVALLAST7DAYS; ?>"><?php echo _INTERVALLAST7DAYS; ?></a>
<a href="./payments.php?interval=last30days" class="dropdown-item pointer <?php echo (getInterval() == "last30days" ? "active" : null); ?>" data-interval="last30days" data-label="<?php echo _INTERVALLAST30DAYS; ?>"><?php echo _INTERVALLAST30DAYS; ?></a>
<a href="./payments.php?interval=last6months" class="dropdown-item pointer <?php echo (getInterval() == "last6months" ? "active" : null); ?>" data-interval="last6months" data-label="<?php echo _INTERVALLAST6MONTHS; ?>"><?php echo _INTERVALLAST6MONTHS; ?></a>
<a href="./payments.php?interval=lastyear" class="dropdown-item pointer <?php echo (getInterval() == "lastyear" ? "active" : null); ?>" data-interval="lastyear" data-label="<?php echo _INTERVALLASTYEAR; ?>"><?php echo _INTERVALLASTYEAR; ?></a>
<a href="./payments.php?interval=alltime" class="dropdown-item pointer <?php echo (getInterval() == "alltime" ? "active" : null); ?>" data-interval="alltime" data-label="<?php echo _INTERVALALLTIME; ?>"><?php echo _INTERVALALLTIME; ?></a>
</div>
</div>

</div>

</div>

</div>

<div class="row">

<div class="col-6 col-sm-6 col-md-4 col-lg-4">
<div class="block counter-block mb-4">
<i class="dripicons-wallet i-icon"></i>
<p class="label"><?php echo _EARNINGS; ?></p>
<div class="value"><?php echo getPrice($earnings['total_earnings']); ?> </div>
</div>
</div>

<div class="col-6 col-sm-6 col-md-4 col-lg-4">
<div class="block counter-block mb-4">
<i class="dripicons-card i-icon"></i>
<p class="label"><?php echo _PAYMENTS; ?></p>
<div class="value"><?php echo countFormat($earnings['total_payments']); ?> </div>
</div>
</div>

<div class="col-6 col-sm-6 col-md-4 col-lg-4">
<div class="block counter-block mb-4">
<i class="dripicons-card i-icon"></i>
<p class="label"><?php echo _TABLEFIELDACTIVESUBSCRIPTIONS; ?></p>
<div class="value"><?php echo countFormat($active_users['total']); ?></div>
</div>
</div>

</div>

<div class="block table-block mb-4 c-4">

<div class="row">
<div class="table-responsive">

<table id="table_id" class="table table-striped table-bordered" cellspacing="0" width="100%" style="border-radius: 5px;">
  <thead>
  <tr>
  <th><?php echo _TABLEFIELDID; ?></th>
  <th><?php echo _TABLEFIELDUSEREMAIL; ?></th>
  <th><?php echo _TABLEFIELDMETHOD; ?></th>
  <th><?php echo _TABLEFIELDPLAN; ?></th>
  <th><?php echo _TABLEFIELDAMOUNT; ?></th>
  <th><?php echo _TABLEFIELDCURRENCY; ?></th>
  <th><?php echo _TABLEFIELDSTATUS; ?></th>
  <th><?php echo _TABLEFIELDDATE; ?></th>
  <th><?php echo _TABLEFIELDACTIONS; ?></th>
  </tr>
  </thead>
</table>

</div>
</div>
</div>
</div>
</div>
</div>
</div>
</section>
<?php require_once __DIR__ . '/../controller/footer.php'; ?>

<!-- PAYMENTS_PTBR_INJECTED -->
<script>
(function(){
  // Só atua no controller de pagamentos
  if (!/\/admin\/controller\/payments\.php(\?|$)/i.test(location.pathname + location.search)) return;

  var mapExact = [
    [/^\s*EARNINGS\s*$/i,            'Ganhos'],
    [/^\s*ACTIVE\s+SUBSCRIPTIONS\s*$/i, 'Assinaturas Ativas'],
    [/^\s*LAST\s*7\s*DAYS\s*$/i,    'Últimos 7 dias'],

    // Cabeçalhos
    [/^\s*<?php echo _EMAIL; ?>\s*$/i,               'E-mail'],
    [/^\s*Method\s*$/i,              'Método'],
    [/^\s*Plan\s*$/i,                'Plano'],
    [/^\s*Amount\s*$/i,              'Valor'],
    [/^\s*Currency\s*$/i,            'Moeda'],
    [/^\s*<?php echo _TABLEFIELDITEMSTATUS; ?>\s*$/i,              '<?php echo _TABLEFIELDITEMSTATUS; ?>'],
    [/^\s*Date\s*$/i,                'Data'],
    [/^\s*<?php echo _TABLEFIELDACTIONS; ?>\s*$/i,             'Ações'] // se existir
  ];

  function translateNodeTexts(root){
    try {
      var walker = document.createTreeWalker(root, NodeFilter.SHOW_TEXT, {
        acceptNode: function(n){
          if (!n.nodeValue) return NodeFilter.FILTER_REJECT;
          var t = n.nodeValue.trim();
          if (!t) return NodeFilter.FILTER_REJECT;
          var p = n.parentElement; if (!p) return NodeFilter.FILTER_REJECT;
          var tag = p.tagName; if (tag === 'SCRIPT' || tag === 'STYLE') return NodeFilter.FILTER_REJECT;
          return NodeFilter.FILTER_ACCEPT;
        }
      });
      var nodes = [];
      while (walker.nextNode()) nodes.push(walker.currentNode);
      nodes.forEach(function(node){
        var txt = node.nodeValue;
        for (var i=0;i<mapExact.length;i++){
          var rx = mapExact[i][0], rep = mapExact[i][1];
          if (rx.test(txt)) { node.nodeValue = txt.replace(rx, rep); break; }
        }
      });
    } catch(e) {}
  }

  function translateTableHeaders(){
    document.querySelectorAll('table thead th').forEach(function(th){
      var t = (th.textContent || '').trim();
      var pairs = {
        '<?php echo _EMAIL; ?>':'E-mail','Method':'Método','Plan':'Plano','Amount':'Valor',
        'Currency':'Moeda','<?php echo _TABLEFIELDITEMSTATUS; ?>':'<?php echo _TABLEFIELDITEMSTATUS; ?>','Date':'Data','<?php echo _TABLEFIELDACTIONS; ?>':'Ações'
      };
      if (pairs[t]) th.textContent = pairs[t];
    });
  }

  function run(){
    translateNodeTexts(document.body);
    translateTableHeaders();
  }

  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', function(){ run(); setTimeout(run, 300); });
  } else {
    run(); setTimeout(run, 300);
  }

  // Alguns grids carregam via AJAX depois — tenta novamente
  setTimeout(run, 1000);
})();
</script>
