<?php
require_once __DIR__ . '/../controller/header.php';
require_once __DIR__ . '/../controller/sidebar.php';
?>

<script type="text/javascript">
  $(document).ready(function(){
    $('#table_id').dataTable({
      "bProcessing": true,
      "sAjaxSource": "../controller/get_roles.php",
      "responsive": true,
      "bPaginate": true,
      "sPaginationType": "full_numbers",
      "iDisplayLength": 10,
      "aaSorting": [[1,'desc']],
      "aoColumns": [
        { mData: 'role_id', "width": "5%", "className": "text-center" },
        { mData: 'role_title' },
        {
          "mData": null,
          "width": "14%",
          "className": "text-center",
          "orderable": false,
          "searchable": false,
          "mRender": function (data) {
            return "<a class='btn btn-small btn-primary' href='../controller/edit_role.php?id="+data.role_id+"'>"+EDITITEM+"</a> " +
                   "<a class='btn btn-small btn-danger btn-delete deleteItem' data-url='../controller/delete_role.php?id="+data.role_id+"'>"+DELETEITEM+"</a>";
          }
        }
      ]
    });
  });
</script>

<!--Page Container-->
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->
    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">

        <div class="section-title">
          <?php
          // Usa a chave correta do idioma (_ROLES) e aplica fallback + escape
          $rolesTitle = defined('_ROLES') ? _ROLES : 'Funções';
          ?>
          <h5 class="text-truncate"><?= htmlspecialchars($rolesTitle, ENT_QUOTES, 'UTF-8'); ?></h5>
        </div>

        <div class="row">

          <div class="col-12 c-col-12">
            <a class="btn btn-primary" href="../controller/new_role.php">
              <i class="fa fa-plus add-new-i"></i> <?= htmlspecialchars(defined('_ADDITEM') ? _ADDITEM : 'Adicionar', ENT_QUOTES, 'UTF-8'); ?>
            </a>
          </div>

          <div class="col-12">
            <div class="block table-block mb-4 c-4">
              <div class="row">
                <div class="table-responsive">
                  <table id="table_id" class="table table-striped table-bordered" cellspacing="0" width="100%" style="border-radius: 5px;">
                    <thead>
                      <tr>
                        <th><?= htmlspecialchars(defined('_TABLEFIELDID') ? _TABLEFIELDID : 'ID', ENT_QUOTES, 'UTF-8'); ?></th>
                        <th><?= htmlspecialchars(defined('_TABLEFIELDTITLE') ? _TABLEFIELDTITLE : 'Título', ENT_QUOTES, 'UTF-8'); ?></th>
                        <th><?= htmlspecialchars(defined('_TABLEFIELDACTIONS') ? _TABLEFIELDACTIONS : 'Ações', ENT_QUOTES, 'UTF-8'); ?></th>
                      </tr>
                    </thead>
                  </table>
                </div>
              </div>
            </div>
          </div>

        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div><!-- /.content -->

  </div><!-- /.page-content-wrapper -->
</section>

<?php require_once __DIR__ . '/../controller/footer.php'; ?>
