<?php
require_once __DIR__ . '/../controller/header.php'; ?>
<?php require_once __DIR__ . '/../controller/sidebar.php'; ?>  

<script type="text/javascript">
<?php if(isset($plans) && is_array($plans)): ?>
  window.ND_PLANS_MAP = {
<?php foreach($plans as $pl): ?>
    "<?php echo (int)$pl['plan_id']; ?>": "<?php echo htmlspecialchars($pl['plan_title'], ENT_QUOTES, 'UTF-8'); ?>",
<?php endforeach; ?>
  };
<?php else: ?>
  window.ND_PLANS_MAP = {};
<?php endif; ?>

  $(document).ready(function(){
    $('#table_id').dataTable({
     "bProcessing": true,
     "sAjaxSource": "../controller/get_sellers.php",
     "responsive": true,
     "bPaginate":true,
     "sPaginationType":"full_numbers",
     "iDisplayLength": 10,
     "aoColumns": [
     { mData: 'seller_id', "width": "5%", "className": "text-center" },
     { "mData": null , "width": "12%", "className": "product text-center",
     "mRender" : function (data) {
      return "<img src='"+IMAGES_FOLDER+data.seller_logo+"' class='product-img product-img-vertical'/>";}
    },
    { "mData": null , "className":"text-left",
     "mRender" : function (data) {
        var name = data.user_name || '';
        var url = './edit_user.php?id='+data.seller_id;
        var planTitle = '';
        if (data.plan_title) {
          planTitle = data.plan_title;
        } else if (data.user_plan_title) {
          planTitle = data.user_plan_title;
        } else if (data.user_plan && window.ND_PLANS_MAP && window.ND_PLANS_MAP[String(data.user_plan)]) {
          planTitle = window.ND_PLANS_MAP[String(data.user_plan)];
        }
        var badge = '';
        if (planTitle) {
          var cls = 'bg-info';
          var low = String(planTitle).toLowerCase();
          if (low.indexOf('bronze') !== -1) cls = 'bg-warning';
          else if (low.indexOf('prata') !== -1 || low.indexOf('silver') !== -1) cls = 'bg-secondary';
          else if (low.indexOf('ouro') !== -1 || low.indexOf('gold') !== -1) cls = 'bg-warning';
          badge = ' <span class="badge badge-pill '+cls+'">'+planTitle+'</span>';
        }
        return '<a class="text-muted" href="'+url+'">'+name+'</a>'+badge;
      }
    },
    { mData: 'seller_title'},
    { mData: 'seller_description'},
    { "mData": null , "width": "10%", "className":"status text-center",
     "mRender" : function (data) {
      if (data.seller_status == 1) {
        return '<span class="badge badge-pill bg-success"><i class="dripicons-checkmark"></i></span>';
      }else{
        return '<span class="badge badge-pill bg-danger"><i class="dripicons-cross"></i></span>';
        }
      }
    },
    { "mData": null ,
    "width": "14%",
    "className": "text-center",
    'orderable': false,
    'searchable': false,
    "mRender" : function (data) {
      return "<a class='btn btn-small btn-primary' href='../controller/edit_seller.php?id="+data.seller_id+"'>"+EDITITEM+"</a> <a class='btn btn-small btn-danger btn-delete deleteItem' data-url='../controller/delete_seller.php?id="+data.seller_id+"'>"+DELETEITEM+"</a>";}
    }
    ]
  });
  
    var table = $('#table_id').DataTable();
    $('#filter_plan_seller').on('change', function(){
      var v = this.value || '';
      table.search(v).draw();
    });
});
</script>

<!--Page Container-->
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->

    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">

        <div class="section-title">
          <h5 class="text-truncate"><?php echo _SELLERS; ?></h5>
        </div>

        <div class="row">

          <div class="col-12 c-col-12">
            <a class="btn btn-primary" href="../controller/new_seller.php">
              <i class="fa fa-plus add-new-i"></i> <?php echo _ADDITEM; ?>
            </a>
          </div>

          <div class="col-12 c-col-12 mt-2">
            <div class="form-group">
              <label><?php echo _TABLEFIELDPLAN; ?> (filtro)</label>
              <select id="filter_plan_seller" class="custom-select form-control">
                <option value=""><?php echo 'Todos os planos'; ?></option>
                <?php if(isset($plans) && is_array($plans)): ?>
                  <?php foreach($plans as $pl): ?>
                    <option value="<?php echo htmlspecialchars($pl['plan_title'], ENT_QUOTES, 'UTF-8'); ?>">
                      <?php echo htmlspecialchars($pl['plan_title'], ENT_QUOTES, 'UTF-8'); ?>
                    </option>
                  <?php endforeach; ?>
                <?php endif; ?>
              </select>
            </div>
          </div>

          <div class="col-12">
            <div class="block table-block mb-4 c-4">

              <div class="row">
                <div class="table-responsive">
                  <table id="table_id" class="table table-striped table-bordered" cellspacing="0" width="100%" style="border-radius: 5px;">
                    <thead>
                      <tr>
                        <th><?php echo _TABLEFIELDID; ?></th>
                        <th><?php echo _TABLEFIELDIMAGE; ?></th>
                        <th><?php echo _TABLEFIELDSELLER; ?></th>
                        <th><?php echo _TABLEFIELDTITLE; ?></th>
                        <th><?php echo _TABLEFIELDDESCRIPTION; ?></th>
                        <th><?php echo _TABLEFIELDSTATUS; ?></th>
                        <th><?php echo _TABLEFIELDACTIONS; ?></th>
                      </tr>
                    </thead>
                  </table>

                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<?php require_once __DIR__ . '/../controller/footer.php'; ?>

<!-- SELLERS_HEADERS_PTBR_MIN -->
<script>
(function(){
  function traduzirCabecalhos(){
    var tbl = document.querySelector('#table_id') ||
              document.querySelector('table.dataTable') ||
              document.querySelector('.dataTables_wrapper table') ||
              document.querySelector('table');
    if (!tbl) return;

    var map = {
      'id': 'ID',
      'image': 'Imagem',
      'seller': 'Anunciante',
      'title': 'Título',
      'description': 'Descrição',
      'status': '<?php echo _TABLEFIELDITEMSTATUS; ?>',
      'actions': 'Ações'
    };

    var ths = tbl.querySelectorAll('thead th');
    ths.forEach(function(th){
      var txt = (th.textContent || '').trim().toLowerCase();
      if (map.hasOwnProperty(txt)) th.textContent = map[txt];
    });
  }

  function traduzirBotoes(){
    // Botões de ação na grid
    document.querySelectorAll('table button, table a.btn').forEach(function(el){
      var t = (el.textContent || '').trim();
      if (/^view$/i.test(t)) el.textContent = 'Ver';
      if (/^edit$/i.test(t)) el.textContent = 'Editar';
      if (/^delete$/i.test(t)) el.textContent = 'Excluir';
    });
    // Botão do topo
    document.querySelectorAll('a.btn, button.btn').forEach(function(el){
      var t = (el.textContent || '').trim();
      if (/^add\s*new$/i.test(t)) el.textContent = 'Adicionar Novo';
    });
  }

  function run(){ traduzirCabecalhos(); traduzirBotoes(); }
  if (document.readyState !== 'loading') { run(); setTimeout(run, 300); }
  else document.addEventListener('DOMContentLoaded', function(){ run(); setTimeout(run, 300); });
})();
</script>
