<?php if (!isset($menuItems) || !is_array($menuItems)) { $menuItems = []; } ?>
<?php
if (!function_exists('__menu_label_ptbr')) {
  function __menu_label_ptbr($s) {
    $forced = getenv('APP_LANG');
    if (!$forced && defined('APP_LANG')) { $forced = APP_LANG; }
    $forced = strtolower((string)$forced);
    $al = isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? strtolower($_SERVER['HTTP_ACCEPT_LANGUAGE']) : '';
    $pt = in_array($forced, ['pt-br','pt_br','ptbr','pt']) || strpos($al, 'pt-br') !== false;
    if (!$pt) return $s;
    $map = array(
      'Deals'=>'Ofertas','Categories'=>'Categorias','Sub Categories'=>'Subcategorias','Stores'=>'Lojas','Locations'=>'Localidades',
      'Sliders'=>'Slides','Comments'=>'Comentários','Pages'=>'Páginas','Users'=>'Usuários','Sellers'=>'Anunciantes','Subscribers'=>'Assinantes',
      'Menus'=>'Menus','Ads'=>'Anúncios','Theme'=>'Tema','Email Notifications'=>'Notificações por Email','Payments'=>'Pagamentos',
      'Site Statistics'=>'Estatísticas do Site','Codes'=>'Cupons','Taxes'=>'Impostos','Plans'=>'Planos','Settings'=>'Configurações',
    );
    $key = is_string($s) ? trim($s) : (string)$s;
    return isset($map[$key]) ? $map[$key] : $s;
  }
}
?>
<style>
    .menu-section-title {
        padding: 0;
    }
    .menu-section-toggle {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 10px 20px 6px;
        font-size: 11px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: .08em;
        color: rgba(255,255,255,.7);
        text-decoration: none;
        cursor: pointer;
    }
    .menu-section-toggle:hover {
        color: #ffffff;
    }
    .menu-section-title .title-section {
        border-bottom: 1px solid rgba(255,255,255,.18);
        padding-bottom: 3px;
        flex: 1;
    }
    .menu-section-title .toggle-icon {
        font-size: 10px;
        margin-left: 8px;
        opacity: .8;
    }
    .submenu {
        list-style: none;
        margin: 0;
        padding: 4px 0 4px 10px;
        display: none;
    }
    .submenu.open {
        display: block;
    }
</style>

<nav id="navigation" class="navigation-sidebar navbar-expand-lg static-top bg-primary">
        <div class="navigation-header">
        <a href="<?php echo SITE_URL ?>/admin/controller/home.php"><img src="../assets/images/wbdashboard.png" class="logo-side"></a>
    </div>

    <div class="welcome">
        <?php echo _WELCOME; ?> <b><?php echo $userInfo['user_name']; ?></b> <a href="../controller/logout.php" class="sidebar-user"><i class="dripicons-exit"></i></a>
    </div>

    <div class="navigation-menu">

        <ul class="menu-items custom-scroll">

            <?php
            // Mapeia quais controllers pertencem a cada seção
            $sectionsMap = [
                'sistema' => [
                    'settings.php',
                    '2fa-setup.php',
                    '2fa-reset.php',
                    'statistics.php',
                    'subscribers.php',
                    'etemplates.php',
                    'theme.php',
                    'sliders.php',
                    'pages.php',
                    'ads.php',
                    'menus.php',
                    'users.php',
                ],
                'financeiro' => [
                    'plans.php',
                    'taxes.php',
                    'payments.php',
                    'addons.php',
                ],
                'anuncios' => [
                    'deals.php',
                    'categories.php',
                    'subcategories.php',
                    'stores.php',
                    'locations.php',
                    'sellers.php',
                    'associates.php',
                    'comments.php',
                    'deal_reports.php',
                    'codes.php',
                ],
            ];

            $sectionLabels = [
                'sistema'   => 'Sistema',
                'financeiro'=> 'Financeiro',
                'anuncios'  => 'Anúncios Locais',
            ];

            // Ordem de exibição: Anúncios Locais, Financeiro, Sistema
            $sectionOrder = ['anuncios', 'financeiro', 'sistema'];

            // Agrupa os itens por seção
            $grouped = [
                'sistema'   => [],
                'financeiro'=> [],
                'anuncios'  => [],
                'other'     => [],
            ];

            foreach ($menuItems as $item) {
                $file = basename($item['url']);
                $sectionKey = null;
                foreach ($sectionsMap as $key => $files) {
                    if (in_array($file, $files, true)) {
                        $sectionKey = $key;
                        break;
                    }
                }
                if ($sectionKey === null) {
                    $grouped['other'][] = $item;
                } else {
                    $grouped[$sectionKey][] = $item;
                }
            }

            // Renderiza as seções na ordem desejada
            foreach ($sectionOrder as $sectionKey):
                if (empty($grouped[$sectionKey])) {
                    continue;
                }
                ?>
                <li class="menu-section-title">
                    <a href="javascript:void(0);" class="menu-section-toggle" data-section="<?php echo $sectionKey; ?>">
                        <span class="title-section"><?php echo $sectionLabels[$sectionKey]; ?></span>
                        <span class="toggle-icon">▸</span>
                    </a>
                    <ul class="submenu submenu-<?php echo $sectionKey; ?>">
                        <?php foreach ($grouped[$sectionKey] as $item): ?>
                            <li>
                                <a href="<?php echo $item['url']; ?>">
                                    <span class="icon-thumbnail"><i class="<?php echo $item['icon']; ?>"></i></span>
                                    <span class="title"><?php echo __menu_label_ptbr($item['title']); ?></span>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </li>
            <?php endforeach; ?>

            <?php if (!empty($grouped['other'])): ?>
                <?php foreach ($grouped['other'] as $item): ?>
                    <li>
                        <a href="<?php echo $item['url']; ?>">
                            <span class="icon-thumbnail"><i class="<?php echo $item['icon']; ?>"></i></span>
                            <span class="title"><?php echo __menu_label_ptbr($item['title']); ?></span>
                        </a>
                    </li>
                <?php endforeach; ?>
            <?php endif; ?>

        </ul>
    </div>
</nav>

<div class="header fixed-header">
    <div class="container-fluid side-padding">
        <div class="row">
            
            <div class="col-7 col-md-6 d-lg-none">
                <a id="toggle-navigation" href="javascript:void(0);" class="icon-btn mr-3"><i class="fa fa-bars"></i></a>
                <img src="../assets/images/wbdashboard-dark.png" class="logo-side-dark">
            </div>

            <div class="col-lg-8 d-none d-lg-block">
                <p class="sidebar-relative"><?php echo _WELCOME; ?> <b><?php echo $userInfo['user_name']; ?></b> <a href="../controller/logout.php" class="sidebar-logout"><i class="dripicons-exit"></i></a></p>
            </div>
            
            <div class="col-5 col-md-6 col-lg-4 sidebar-right">
            <span style="position: relative; float: right;"> <a href="<?php echo SITE_URL ?>" target="_blank" style="color: var(--primary-color); top: -2px; position: relative; margin-right: 8px; font-weight: 500; font-size: 14px; margin-left: 6px;"><i class="dripicons-preview d-none d-sm-inline" style="top: 5px; position: relative; font-size: 22px; margin-right: 6px;"></i><?php echo _VIEWSITE; ?></a></span>
            </div> 

        </div>
    </div>
    
</div>

<script>
(function() {
  function initMenuDropdowns() {
    var toggles = document.querySelectorAll('.menu-section-toggle');
    if (!toggles || !toggles.length) return;

    toggles.forEach(function(t) {
      t.addEventListener('click', function(e) {
        e.preventDefault();
        var li = t.closest('.menu-section-title');
        if (!li) return;
        var submenu = li.querySelector('.submenu');
        if (!submenu) return;
        var isOpen = submenu.classList.toggle('open');
        submenu.style.display = isOpen ? 'block' : 'none';
        var icon = t.querySelector('.toggle-icon');
        if (icon) icon.textContent = isOpen ? '▾' : '▸';
      });
    });

    // Abre por padrão o primeiro grupo (Anúncios Locais, se existir)
    var firstSub = document.querySelector('.submenu-anuncios');
    if (firstSub) {
      firstSub.classList.add('open');
      firstSub.style.display = 'block';
      var parent = firstSub.closest('.menu-section-title');
      if (parent) {
        var icon = parent.querySelector('.toggle-icon');
        if (icon) icon.textContent = '▾';
      }
    }
  }

  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', initMenuDropdowns);
  } else {
    initMenuDropdowns();
  }
})();
</script>

