<?php
require_once __DIR__ . '/../controller/header.php'; ?>
<?php require_once __DIR__ . '/../controller/sidebar.php'; ?>  

<script type="text/javascript">
  $(document).ready(function(){
    $('#table_id').dataTable({
     "bProcessing": true,
     "sAjaxSource": "../controller/get_taxes.php",
     "responsive": true,
     "bPaginate":true,
     "sPaginationType":"full_numbers",
     "iDisplayLength": 10,
     "aaSorting": [[1,'desc']],
     "aoColumns": [
     { mData: 'tax_id', "width": "5%", "className": "text-center" },
     { mData: 'tax_title'},
     { "mData": null , "width": "10%", "className":"status text-center",
     "mRender" : function (data) {
        return '<span>'+data.tax_percentage+'%</span>';
      }
    },
     { mData: 'tax_type', "className": "text-capitalize"},
     { "mData": null ,
  "width": "14%",
  "className": "text-center",
  'orderable': false,
  'searchable': false,
  "mRender" : function (data) {
    return "<a class='btn btn-small btn-primary' href='../controller/edit_tax.php?id="+data.tax_id+"'>"+EDITITEM+"</a>";}
  }
  ]
});
  });
</script>

<!--Page Container-->
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->

    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">

        <div class="section-title">
          <h5 class="text-truncate"><?php echo _TAXES; ?></h5>
        </div>

        <div class="row">

          <div class="col-12 c-col-12">
            <a class="btn btn-primary" href="../controller/new_tax.php">
              <i class="fa fa-plus add-new-i"></i> <?php echo _ADDITEM; ?>
            </a>
          </div>

          <div class="col-12">
            <div class="block table-block mb-4 c-4">

              <div class="row">
                <div class="table-responsive">
                  <table id="table_id" class="table table-striped table-bordered" cellspacing="0" width="100%" style="border-radius: 5px;">
                    <thead>
                      <tr>
                        <th><?php echo _TABLEFIELDID; ?></th>
                        <th><?php echo _TABLEFIELDTITLE; ?></th>
                        <th><?php echo _TABLEFIELDTAXRATE; ?></th>
                        <th><?php echo _TABLEFIELDTAXTYPE; ?></th>
                        <th><?php echo _TABLEFIELDACTIONS; ?></th>
                      </tr>
                    </thead>
                  </table>

                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<?php require_once __DIR__ . '/../controller/footer.php'; ?>
<!-- TAXES_PTBR_RUNTIME -->
<script>
(function(){
  try {
    // Só roda na tela de impostos
    if (!/\/admin\/controller\/taxes\.php/i.test(location.pathname)) return;

    var map = {
      'Tax Rate': 'Alíquota',
      'Tax Type': 'Tipo de Imposto'
      // 'ID': 'ID'         // já está ok
      // '<?php echo _TABLEFIELDTITLE; ?>': 'Título'  // já está ok
      // '<?php echo _TABLEFIELDACTIONS; ?>': 'Ações' // já está ok
      // '<?php echo _TABLEFIELDITEMSTATUS; ?>': '<?php echo _TABLEFIELDITEMSTATUS; ?>' // se houver
    };

    function translateHeaders(root){
      (root || document).querySelectorAll('th, thead td, .dataTables_scrollHead th').forEach(function(th){
        var t = (th.textContent || '').trim();
        if (map[t]) th.textContent = map[t];
      });
    }

    function run(){ translateHeaders(document); }
    run();

    // Reaplica após o redraw do DataTables (quando presente)
    if (window.jQuery) {
      try { jQuery(document).on('draw.dt', function(){ run(); }); } catch(e){}
    }

    // Observa mudanças no DOM (fallback)
    var obs = new MutationObserver(function(){ run(); });
    obs.observe(document.body, {subtree:true, childList:true});
  } catch(e) { /* silencioso */ }
})();
</script>
<!-- /TAXES_PTBR_RUNTIME -->
