<?php
declare(strict_types=1);
require_once __DIR__ . '/../core.php';

header('Content-Type: application/json; charset=utf-8');

try {
    $segment = isset($_GET['segment']) ? (string)$_GET['segment'] : '';
    $neighborhood = isset($_GET['neighborhood']) ? (string)$_GET['neighborhood'] : '';
    $segment = trim($segment);
    $neighborhood = trim($neighborhood);

    if ($segment === '' || $neighborhood === '') {
        echo json_encode(['available' => true, 'message' => ''], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
        exit;
    }

    // Disponível = não existe exclusividade ativa no mesmo segmento+bairro
    $ok = nd_exclusive_is_available($connect, $segment, $neighborhood);

    if ($ok) {
        echo json_encode(['available' => true, 'message' => 'Disponível'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
    } else {
        echo json_encode(['available' => false, 'message' => 'Indisponível: já existe exclusividade ativa para este Segmento + Bairro.'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
    }
} catch (Throwable $e) {
    error_log('check-exclusive error: ' . $e->getMessage());
    // fail-open
    echo json_encode(['available' => true, 'message' => ''], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
}
